/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.PortForwardingInformationProvider;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.session.ReservedSessionMessagesManager;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandlerManager;
import org.apache.sshd.common.session.SessionListenerManager;
import org.apache.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.apache.sshd.common.session.helpers.TimeoutIndicator;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public interface Session
extends SessionContext,
MutableUserHolder,
KexFactoryManager,
SessionListenerManager,
ReservedSessionMessagesManager,
SessionDisconnectHandlerManager,
ChannelListenerManager,
ChannelStreamWriterResolverManager,
PortForwardingEventListenerManager,
UnknownChannelReferenceHandlerManager,
FactoryManagerHolder,
PortForwardingInformationProvider {
    default public Buffer createBuffer(byte cmd) {
        return this.createBuffer(cmd, 0);
    }

    public Buffer createBuffer(byte var1, int var2);

    public Buffer prepareBuffer(byte var1, Buffer var2);

    public IoWriteFuture sendDebugMessage(boolean var1, Object var2, String var3) throws IOException;

    public IoWriteFuture sendIgnoreMessage(byte ... var1) throws IOException;

    public IoWriteFuture writePacket(Buffer var1) throws IOException;

    default public IoWriteFuture writePacket(Buffer buffer, Duration timeout) throws IOException {
        Objects.requireNonNull(timeout, "No timeout was specified");
        return this.writePacket(buffer, timeout.toMillis());
    }

    default public IoWriteFuture writePacket(Buffer buffer, long maxWaitMillis) throws IOException {
        return this.writePacket(buffer, maxWaitMillis, TimeUnit.MILLISECONDS);
    }

    public IoWriteFuture writePacket(Buffer var1, long var2, TimeUnit var4) throws IOException;

    default public Buffer request(String request, Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        ValidateUtils.checkTrue((timeout > 0L ? 1 : 0) != 0, (String)"Non-positive timeout requested: %d", (long)timeout);
        return this.request(request, buffer, TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    default public Buffer request(String request, Buffer buffer, Duration timeout) throws IOException {
        Objects.requireNonNull(timeout, "No timeout specified");
        return this.request(request, buffer, timeout.toMillis());
    }

    public Buffer request(String var1, Buffer var2, long var3) throws IOException;

    public void exceptionCaught(Throwable var1);

    public KeyExchangeFuture reExchangeKeys() throws IOException;

    public <T extends Service> T getService(Class<T> var1);

    public IoSession getIoSession();

    default public SocketAddress getLocalAddress() {
        IoSession s = this.getIoSession();
        return s == null ? null : s.getLocalAddress();
    }

    default public SocketAddress getRemoteAddress() {
        IoSession s = this.getIoSession();
        return s == null ? null : s.getRemoteAddress();
    }

    public TimeoutIndicator getTimeoutStatus();

    public Duration getIdleTimeout();

    public Instant getIdleTimeoutStart();

    public Instant resetIdleTimeout();

    public Duration getAuthTimeout();

    public Instant getAuthTimeoutStart();

    public Instant resetAuthTimeout();

    public void setAuthenticated() throws IOException;

    public KeyExchange getKex();

    public void disconnect(int var1, String var2) throws IOException;

    public void startService(String var1, Buffer var2) throws Exception;

    default public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        return Session.resolveAttribute(this, key);
    }

    public static <T> T resolveAttribute(Session session, AttributeRepository.AttributeKey<T> key) {
        Objects.requireNonNull(key, "No key");
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(key);
        return (T)(value != null ? value : FactoryManager.resolveAttribute(session.getFactoryManager(), key));
    }
}

