/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.net.InetAddress;
import java.util.ArrayList;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestNetStatPort
extends SigarTestCase {
    public TestNetStatPort(String name) {
        super(name);
    }

    private void netstat(Sigar sigar, String addr, long port) throws Exception {
        NetStat netstat;
        InetAddress address = InetAddress.getByName(addr);
        this.traceln("");
        this.traceln("using address=" + address + ":" + port);
        try {
            netstat = sigar.getNetStat(address.getAddress(), port);
        }
        catch (SigarNotImplementedException e) {
            return;
        }
        catch (SigarPermissionDeniedException e) {
            return;
        }
        this.assertGtEqZeroTrace("AllOutbound", netstat.getAllOutboundTotal());
        this.assertGtEqZeroTrace("Outbound", netstat.getTcpOutboundTotal());
        this.assertGtEqZeroTrace("Inbound", netstat.getTcpInboundTotal());
        this.assertGtEqZeroTrace("AllInbound", netstat.getAllInboundTotal());
        int[] states = netstat.getTcpStates();
        for (int i = 0; i < 14; ++i) {
            this.assertGtEqZeroTrace(NetConnection.getStateString(i), states[i]);
        }
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        NetInterfaceConfig ifconfig = sigar.getNetInterfaceConfig(null);
        ArrayList<String> addrs = new ArrayList<String>();
        addrs.add(ifconfig.getAddress());
        addrs.add("127.0.0.1");
        if (JDK_14_COMPAT) {
            addrs.add("::1");
        }
        for (int i = 0; i < addrs.size(); ++i) {
            String addr = (String)addrs.get(i);
            this.netstat(sigar, addr, 22L);
        }
    }
}

