/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import org.iq80.leveldb.impl.ValueType;

public final class SequenceNumber {
    public static final long MAX_SEQUENCE_NUMBER = 0xFFFFFFFFFFFFFFL;

    public static long packSequenceAndValueType(long sequence, ValueType valueType) {
        Preconditions.checkArgument((sequence <= 0xFFFFFFFFFFFFFFL ? 1 : 0) != 0, (Object)"Sequence number is greater than MAX_SEQUENCE_NUMBER");
        Preconditions.checkNotNull((Object)((Object)valueType), (Object)"valueType is null");
        return sequence << 8 | (long)valueType.getPersistentId();
    }

    public static ValueType unpackValueType(long num) {
        return ValueType.getValueTypeByPersistentId((byte)num);
    }

    public static long unpackSequenceNumber(long num) {
        return num >>> 8;
    }
}

