.TH FBQUANT 1 25-Jun-90
.CM 3
.SH NAME
fbquant \- quantize a 24 bit color image
.SH SYNOPSIS
.nf
fbquant [ -c<numcolors> ] [ -<type> ] [ -m<map> ] < rgb-image > mapped-image
.fi
.SH DESCRIPTION
.PP
Converts a 3 plane red-green-blue color image into a
mapped color image.  Uses Heckbert's adaptive partitioning
color quantizing algorithm.  It is strongly suggested that you make the
number of colors used a power of 2, but not necessary for proper
operation of FBM.
.sp
If you wish to requantize an image that is already mapped (for example,
to reduce the number of colors), use "gray2clr -u" to unmap the image
first.  This unmapping step is also necessary to resize a color image
using fbext(1).
.sp
You may specify a particular color map with the
.B -m
option.  The argument is another mapped color image.
.sp
Note that even if you specify fewer than 256 colors, some output
formats (SUN and FBM) will still use 8 bits to store each color index.
The color map will be the specified length.
.SH OPTIONS
.TP
.BR -c<num>
.I number of colors
to use for dithering.  The range is 8 to 256, and the default is 256.
.TP
.BR -m<map>
.I colormap
option, specifies that the colormap from the
.I map
image is to be used to quantize he input.  Colormaps may be efficiently
stored by extracting very small rectangles
from another color image:
.sp
	% fbext 0 0 1 1 < image.clr > map.clr
.sp
which stores a 1 pixel image with the desired map.
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
It is recommended that you use 16 or 32 colors, because the EL Arts
code limits IFF files to 6 planes, and most Amiga software cannot
handle more than 32 colors anyway.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.SH EXAMPLE
.PP
To convert a 24 bit Sun rasterfile to an 8 bit mapped color rasterfile:
.sp
    % fbquant -S < foo.24bit > foo.clr
.sp
To convert a 24 bit Sun rasterfile to a 32 color Amiga image:
.sp
    % fbext -a1.2 -w320 < foo.24bit | \
.br
      fbquant -I -c32 > foo.iff
.sp
To convert an FBM format RGB color image to a 16 color GIF image:
    % fbext -a1.2 -w320 < foo.24bit | \
.br
      fbquant -G -c16 > foo.gif
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
