/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.customizer;

import com.sun.media.customizer.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDiag
extends JDialog
implements ActionListener {
    String srcname;
    String dstname;
    JLabel srcfilesize;
    JLabel srcclasscount;
    JLabel dstfilesize;
    JLabel dstclasscount;
    JLabel note;
    JProgressBar pb;
    JButton doneButton;
    boolean twojars;

    public ProgressDiag(Frame parent, String srcname, String dstname, boolean twojars) {
        super(parent, I18N.getResource("ProgressDiag.DTITLE"), true);
        this.srcname = srcname;
        this.dstname = dstname;
        this.twojars = twojars;
        this.init();
    }

    public void updateValue(int val) {
        if (val >= this.pb.getMinimum() && val <= this.pb.getMaximum()) {
            this.pb.setValue(val);
        }
    }

    public void updateNote(String str) {
        this.note.setText(str);
    }

    public void updateSourceInfo(long fsize, int cno) {
        this.srcfilesize.setText(new Long(fsize).toString());
        this.srcclasscount.setText(new Integer(cno).toString());
    }

    public void enableDone() {
        this.doneButton.setEnabled(true);
    }

    public void sentErr(String msg) {
        JOptionPane.showMessageDialog(this, msg, I18N.getResource("ProgressDiag.ERR"), 0);
        this.dispose();
    }

    public void updateTargetInfo(long fsize, int cno) {
        this.dstfilesize.setText(new Long(fsize).toString());
        this.dstclasscount.setText(new Integer(cno).toString());
    }

    void init() {
        JLabel dstn;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 420;
        int h = 350;
        ((Component)this).setLocation(screenSize.width / 2 - w / 2, screenSize.height / 2 - h / 2);
        ((Component)this).setSize(w, h);
        this.setResizable(false);
        if (this.srcname.length() > 40) {
            this.srcname = this.nameOnly(this.srcname);
        }
        BorderLayout borderlayout = new BorderLayout();
        GridLayout grid31 = new GridLayout(3, 1);
        JPanel srcPane = new JPanel(grid31);
        JPanel dstPane = new JPanel(grid31);
        JPanel barPane = new JPanel(grid31);
        srcPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("ProgressDiag.SRCJAR")));
        dstPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18N.getResource("ProgressDiag.TJAR")));
        FlowLayout leftflow = new FlowLayout(0);
        JPanel srcnamePane = new JPanel(leftflow);
        srcnamePane.add(new JLabel(I18N.getResource("ProgressDiag.FN")));
        JLabel srcn = new JLabel(this.srcname);
        srcn.setForeground(Color.black);
        srcnamePane.add(srcn);
        JPanel srcsizePane = new JPanel(leftflow);
        srcsizePane.add(new JLabel(I18N.getResource("ProgressDiag.FS")));
        this.srcfilesize = new JLabel(" ");
        this.srcfilesize.setForeground(Color.black);
        srcsizePane.add(this.srcfilesize);
        JPanel srcclscountPane = new JPanel(leftflow);
        srcclscountPane.add(new JLabel(I18N.getResource("ProgressDiag.NOC")));
        this.srcclasscount = new JLabel(" ");
        this.srcclasscount.setForeground(Color.black);
        srcclscountPane.add(this.srcclasscount);
        srcPane.add(srcnamePane);
        srcPane.add(srcsizePane);
        srcPane.add(srcclscountPane);
        if (!this.twojars) {
            if (this.dstname.length() > 40) {
                this.dstname = this.nameOnly(this.dstname);
            }
            dstn = new JLabel(this.dstname);
        } else {
            File df1 = new File(this.dstname);
            String pp = df1.getParent() + File.separator;
            String fn = df1.getName();
            String newdst = pp + "core_" + fn + " & " + "plugin_" + fn;
            if (newdst.length() > 40) {
                newdst = this.nameOnly(newdst);
            }
            dstn = new JLabel(newdst);
        }
        JPanel dstnamePane = new JPanel(leftflow);
        dstnamePane.add(new JLabel(I18N.getResource("ProgressDiag.FN")));
        dstn.setForeground(Color.black);
        dstnamePane.add(dstn);
        JPanel dstsizePane = new JPanel(leftflow);
        dstsizePane.add(new JLabel(I18N.getResource("ProgressDiag.FS")));
        this.dstfilesize = new JLabel(" ");
        this.dstfilesize.setForeground(Color.black);
        dstsizePane.add(this.dstfilesize);
        JPanel dstclscountPane = new JPanel(leftflow);
        dstclscountPane.add(new JLabel(I18N.getResource("ProgressDiag.NOC")));
        this.dstclasscount = new JLabel(" ");
        this.dstclasscount.setForeground(Color.black);
        dstclscountPane.add(this.dstclasscount);
        dstPane.add(dstnamePane);
        dstPane.add(dstsizePane);
        dstPane.add(dstclscountPane);
        JPanel notePane = new JPanel();
        JPanel buttonPane = new JPanel();
        this.note = new JLabel(I18N.getResource("ProgressDiag.LOAD"));
        this.note.setForeground(Color.black);
        notePane.add(this.note);
        this.doneButton = new JButton(I18N.getResource("ProgressDiag.DONE"));
        this.doneButton.addActionListener(this);
        this.doneButton.setEnabled(false);
        buttonPane.add(this.doneButton);
        this.pb = new JProgressBar();
        JPanel pbPane = new JPanel();
        pbPane.add(this.pb);
        barPane.add(notePane);
        barPane.add(pbPane);
        barPane.add(buttonPane);
        JPanel holder = new JPanel(new GridLayout(2, 1));
        holder.add(srcPane);
        holder.add(dstPane);
        this.getContentPane().setLayout(borderlayout);
        this.getContentPane().add("Center", holder);
        this.getContentPane().add("South", barPane);
    }

    public void actionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private String nameOnly(String srcStr) {
        String ret = null;
        if (srcStr == null) {
            return null;
        }
        int i = srcStr.lastIndexOf(File.separatorChar);
        ret = srcStr.substring(i + 1);
        if (ret != null && ret.length() > 40) {
            ret = ret.substring(0, 40);
        }
        return ret;
    }
}

