/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.demos.util.VSNetStartPage;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;

public class ViewDemo
extends JFrame
implements DockingConstants {
    public static void main(String[] args) {
        SwingUtility.setPlaf("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ViewDemo.startup();
            }
        });
    }

    private static void startup() {
        DockingManager.setFloatingEnabled(true);
        ViewDemo f = new ViewDemo();
        f.setSize(800, 600);
        SwingUtility.centerOnScreen(f);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
    }

    public ViewDemo() {
        super("Viewport Demo");
        this.setContentPane(this.createContentPane());
    }

    private JPanel createContentPane() {
        JPanel p = new JPanel(new BorderLayout(0, 0));
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        Viewport viewport = new Viewport();
        p.add((Component)viewport, "Center");
        View startPage = this.createStartPage();
        View view1 = this.createView("solution.explorer", "Solution Explorer");
        View view2 = this.createView("task.list", "Task List");
        View view3 = this.createView("class.view", "Class View");
        View view4 = this.createView("message.log", "Message Log");
        viewport.dock(startPage);
        startPage.dock(view1, "WEST", 0.3f);
        startPage.dock(view2, "SOUTH", 0.3f);
        startPage.dock(view4, "EAST", 0.3f);
        view1.dock(view3, "SOUTH", 0.3f);
        return p;
    }

    private View createView(String id, String text) {
        View view = new View(id, text);
        view.addAction("close");
        view.addAction("pin");
        JPanel p = new JPanel();
        p.setBorder(new LineBorder(Color.GRAY, 1));
        JTextField t = new JTextField(text);
        t.setPreferredSize(new Dimension(100, 20));
        p.add(t);
        view.setContentPane(p);
        return view;
    }

    private View createStartPage() {
        String id = "startPage";
        View view = new View(id, null, null);
        view.setTerritoryBlocked("CENTER", true);
        view.setTitlebar(null);
        view.setContentPane(new VSNetStartPage());
        return view;
    }
}

