/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.Log;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;

public class Packetizer
extends BasicCodec {
    static final JPEGFormat fJPEG = new JPEGFormat();
    private VideoFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private int PACKET_SIZE = 960;
    private int currentSeq = 0;
    private int copyLength = this.PACKET_SIZE;
    private boolean newFrame = true;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private int offset = 0;
    private int frameLength = 0;
    private static final int J_SOF = 192;
    private static final int J_SOF1 = 193;
    private int decimation = -1;
    private static final int DEFAULT_FRAMERATE = 15;
    private float frame_duration = -1.0f;

    public Packetizer() {
        this.inputFormats = new VideoFormat[]{new VideoFormat("jpeg")};
        this.outputFormats = new VideoFormat[]{new VideoFormat("jpeg/rtp")};
        FrameProcessingControl fpc = new FrameProcessingControl(){

            public boolean setMinimalProcessing(boolean newMinimal) {
                Packetizer.this.minimal = newMinimal;
                return Packetizer.this.minimal;
            }

            public void setFramesBehind(float frames) {
                if (frames >= 1.0f) {
                    Packetizer.this.dropFrame = true;
                } else {
                    Packetizer.this.dropFrame = false;
                }
            }

            public Component getControlComponent() {
                return null;
            }

            public int getFramesDropped() {
                return 0;
            }
        };
        this.controls = new Control[1];
        this.controls[0] = fpc;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(in)) {
            return new Format[0];
        }
        Format[] out = new Format[]{((VideoFormat)in).getFrameRate() == -1.0f ? new VideoFormat("jpeg/rtp", ((VideoFormat)in).getSize(), ((VideoFormat)in).getMaxDataLength(), Format.byteArray, 15.0f) : new VideoFormat("jpeg/rtp", ((VideoFormat)in).getSize(), ((VideoFormat)in).getMaxDataLength(), Format.byteArray, ((VideoFormat)in).getFrameRate())};
        return out;
    }

    private boolean verifyInputFormat(Format input) {
        return fJPEG.matches(input);
    }

    public Format setInputFormat(Format input) {
        if (!this.verifyInputFormat(input)) {
            return null;
        }
        this.inputFormat = (VideoFormat)input;
        float rate = this.inputFormat.getFrameRate();
        if (rate != -1.0f) {
            this.frame_duration = 1000.0f / rate;
        }
        if (this.opened) {
            this.outputFormat = (VideoFormat)this.getSupportedOutputFormats(input)[0];
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (BasicPlugIn.matches(output, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)output;
        return output;
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on JPEG Packetizer");
        }
        Dimension size = this.inputFormat.getSize();
        if (size != null && (size.width % 8 != 0 || size.height % 8 != 0)) {
            Log.error("Class: " + this);
            Log.error("  can only packetize in sizes of multiple of 8 pixels.");
            throw new ResourceUnavailableException("Incorrect formats set on JPEG Packetizer");
        }
        super.open();
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (inBuffer.isDiscard()) {
            this.updateOutput(outBuffer, this.outputFormat, 0, 0);
            outBuffer.setDiscard(true);
            return 4;
        }
        if (inBuffer.getLength() <= 0) {
            outBuffer.setDiscard(true);
            return 4;
        }
        byte[] inData = (byte[])inBuffer.getData();
        outBuffer.setFormat(this.outputFormat);
        Dimension size = this.inputFormat.getSize();
        int keyFrame = 0;
        if (this.newFrame) {
            if (this.dropFrame || this.minimal) {
                outBuffer.setDiscard(true);
                return 0;
            }
            int tempdec = this.peekJPEGDecimation(inData, inBuffer.getLength());
            if (tempdec >= 0) {
                this.decimation = tempdec;
            }
            if (this.inputFormat instanceof JPEGFormat) {
                this.stripTables(inBuffer);
            }
            this.frameLength = inBuffer.getLength();
            this.offset = 0;
            this.newFrame = false;
            keyFrame = 16;
        }
        this.copyLength = this.frameLength - this.offset < this.PACKET_SIZE ? this.frameLength - this.offset : this.PACKET_SIZE;
        byte[] outData = (byte[])outBuffer.getData();
        if (outData == null || outData.length < this.copyLength + 8) {
            outData = new byte[this.copyLength + 8];
            outBuffer.setData(outData);
        }
        System.arraycopy(inData, this.offset + inBuffer.getOffset(), outData, 8, this.copyLength);
        int qfactor = this.inputFormat instanceof JPEGFormat ? ((JPEGFormat)this.inputFormat).getQFactor() : 80;
        int n2 = this.decimation = this.inputFormat instanceof JPEGFormat ? ((JPEGFormat)this.inputFormat).getDecimation() : this.decimation;
        if (this.decimation == -1) {
            this.decimation = 1;
        }
        outBuffer.setLength(this.copyLength + 8);
        outBuffer.setOffset(0);
        outBuffer.setSequenceNumber(this.currentSeq++);
        outBuffer.setFormat(this.outputFormat);
        outData[0] = 0;
        outData[1] = (byte)(this.offset >> 16);
        outData[2] = (byte)(this.offset >> 8);
        outData[3] = (byte)this.offset;
        outData[4] = (byte)this.decimation;
        outData[5] = (byte)qfactor;
        outData[6] = (byte)(size.width / 8);
        outData[7] = (byte)(size.height / 8);
        this.offset += this.copyLength;
        outBuffer.setFlags(outBuffer.getFlags() | keyFrame);
        if (this.offset == this.frameLength) {
            outBuffer.setFlags(outBuffer.getFlags() | 0x800);
            this.newFrame = true;
            return 0;
        }
        return 2;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Packetizer";
    }

    /*
     * Unable to fully structure code
     */
    int peekJPEGDecimation(byte[] data, int dataLen) {
        i = 0;
        if ((data[0] & 255) == 255 && data[1] != 0) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((data[i] & 255) == 255) {
                code = data[++i] & 255;
                ++i;
                switch (code) {
                    case 192: 
                    case 193: {
                        return this.getDecimationFromSOF(data, i, dataLen);
                    }
                }
                continue;
            }
            ++i;
lbl12:
            // 3 sources

            ** while (i < dataLen - 2)
        }
lbl13:
        // 1 sources

        return -1;
    }

    private void stripTables(Buffer inb) {
        byte[] data = (byte[])inb.getData();
        int offset = inb.getOffset();
        int length = inb.getLength();
        int i2 = offset;
        while (i2 < length + offset - 8) {
            if (data[i2] == -1 && data[i2 + 1] == -38) {
                int blockSize = (data[i2 + 2] & 0xFF) << 8 | data[i2 + 3] & 0xFF;
                System.arraycopy(data, i2 += 2 + blockSize, data, 0, length + offset - i2);
                inb.setOffset(0);
                inb.setLength(length + offset - i2);
                break;
            }
            ++i2;
        }
    }

    int getDecimationFromSOF(byte[] data, int i2, int length) {
        int ncomp;
        int sectionLen = (data[i2++] & 0xFF) << 8;
        int n2 = i2++;
        i2 += 5;
        if ((sectionLen |= data[n2] & 0xFF) != (ncomp = data[i2++] & 0xFF) * 3 + 8) {
            System.err.println("Bogus SOF length");
        }
        int id = data[i2++] & 0xFF;
        int deccode = data[i2++] & 0xFF;
        int hsf = deccode >> 4 & 0xF;
        int vsf = deccode & 0xF;
        if (vsf == 2 && hsf == 2) {
            return 1;
        }
        if (vsf == 1 && hsf == 1) {
            return 2;
        }
        return 0;
    }
}

