/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChatMessage
extends DOMMessage {
    private String sender;
    private final String message;
    private final boolean privateChat;

    public ChatMessage(Player player, String message, boolean privateChat) {
        super(ChatMessage.getXMLElementTagName());
        this.sender = player.getId();
        this.message = message;
        this.privateChat = privateChat;
    }

    public ChatMessage(Game game, Element element) {
        super(ChatMessage.getXMLElementTagName());
        this.sender = element.getAttribute("sender");
        this.message = element.getAttribute("message");
        this.privateChat = Boolean.parseBoolean(element.getAttribute("privateChat"));
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.sender, Player.class);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isPrivate() {
        return this.privateChat;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        this.sender = serverPlayer.getId();
        return server.getInGameController().chat(serverPlayer, this.message, this.privateChat);
    }

    @Override
    public Element toXMLElement() {
        return ChatMessage.createMessage(ChatMessage.getXMLElementTagName(), "sender", this.sender, "message", this.message, "privateChat", String.valueOf(this.privateChat));
    }

    public static String getXMLElementTagName() {
        return "chat";
    }
}

