/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.problems.internal.DeprecationData;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.internal.featurelifecycle.FeatureUsage;

public class DeprecatedFeatureUsage
extends FeatureUsage {
    private final String removalDetails;
    private final String advice;
    private final String contextualAdvice;
    private final DocLink documentation;
    private final String problemIdDisplayName;
    private final String problemId;
    private final Type type;

    public DeprecatedFeatureUsage(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice, @Nullable DocLink documentation, Type type, String problemIdDisplayName, String problemId, Class<?> calledFrom) {
        super(summary, calledFrom);
        this.removalDetails = (String)Preconditions.checkNotNull((Object)removalDetails);
        this.advice = advice;
        this.contextualAdvice = contextualAdvice;
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.documentation = documentation;
        this.problemIdDisplayName = problemIdDisplayName;
        this.problemId = problemId;
    }

    @VisibleForTesting
    DeprecatedFeatureUsage(DeprecatedFeatureUsage usage) {
        super(usage.getSummary(), usage.getCalledFrom());
        this.removalDetails = usage.removalDetails;
        this.advice = usage.advice;
        this.contextualAdvice = usage.contextualAdvice;
        this.documentation = usage.documentation;
        this.type = usage.type;
        this.problemIdDisplayName = usage.problemIdDisplayName;
        this.problemId = usage.problemId;
    }

    @Nullable
    public String getProblemId() {
        return this.problemId;
    }

    public String getRemovalDetails() {
        return this.removalDetails;
    }

    @Nullable
    public String getAdvice() {
        return this.advice;
    }

    @Nullable
    public String getContextualAdvice() {
        return this.contextualAdvice;
    }

    @Nullable
    public DocLink getDocumentationUrl() {
        return this.documentation;
    }

    public Type getType() {
        return this.type;
    }

    public String getProblemIdDisplayName() {
        return this.problemIdDisplayName;
    }

    @Override
    public String formattedMessage() {
        StringBuilder outputBuilder = new StringBuilder(this.getSummary());
        DeprecatedFeatureUsage.append(outputBuilder, this.removalDetails);
        DeprecatedFeatureUsage.append(outputBuilder, this.contextualAdvice);
        DeprecatedFeatureUsage.append(outputBuilder, this.advice);
        if (this.documentation != null) {
            DeprecatedFeatureUsage.append(outputBuilder, this.documentation.getConsultDocumentationMessage());
        }
        return outputBuilder.toString();
    }

    private static void append(StringBuilder outputBuilder, @Nullable String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            outputBuilder.append(" ").append(message);
        }
    }

    public static enum Type {
        USER_CODE_DIRECT,
        USER_CODE_INDIRECT,
        BUILD_INVOCATION;


        public DeprecationData.Type toDeprecationDataType() {
            switch (this) {
                case USER_CODE_DIRECT: {
                    return DeprecationData.Type.USER_CODE_DIRECT;
                }
                case USER_CODE_INDIRECT: {
                    return DeprecationData.Type.USER_CODE_INDIRECT;
                }
                case BUILD_INVOCATION: {
                    return DeprecationData.Type.BUILD_INVOCATION;
                }
            }
            throw new IllegalStateException("Unknown deprecation type: " + (Object)((Object)this));
        }
    }
}

