/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.core;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.Codec;
import org.gradle.internal.serialize.graph.CombinatorsKt;
import org.gradle.internal.serialize.graph.ReadContext;
import org.gradle.internal.serialize.graph.WriteContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u0002*\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gradle/internal/serialize/codecs/core/DirectoryCodec;", "Lorg/gradle/internal/serialize/graph/Codec;", "Lorg/gradle/api/file/Directory;", "fileFactory", "Lorg/gradle/api/internal/file/FileFactory;", "(Lorg/gradle/api/internal/file/FileFactory;)V", "decode", "Lorg/gradle/internal/serialize/graph/ReadContext;", "(Lorg/gradle/internal/serialize/graph/ReadContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encode", "", "Lorg/gradle/internal/serialize/graph/WriteContext;", "value", "(Lorg/gradle/internal/serialize/graph/WriteContext;Lorg/gradle/api/file/Directory;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core-serialization-codecs"})
public final class DirectoryCodec
implements Codec<Directory> {
    @NotNull
    private final FileFactory fileFactory;

    public DirectoryCodec(@NotNull FileFactory fileFactory) {
        Intrinsics.checkNotNullParameter((Object)fileFactory, (String)"fileFactory");
        this.fileFactory = fileFactory;
    }

    @Nullable
    public Object encode(@NotNull WriteContext $this$encode, @NotNull Directory value, @NotNull Continuation<? super Unit> $completion) {
        Encoder encoder = (Encoder)$this$encode;
        File file = value.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"value.asFile");
        CombinatorsKt.writeFile((Encoder)encoder, (File)file);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object decode(@NotNull ReadContext $this$decode, @NotNull Continuation<? super Directory> $completion) {
        Directory directory = this.fileFactory.dir(CombinatorsKt.readFile((Decoder)((Decoder)$this$decode)));
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"fileFactory.dir(readFile())");
        return directory;
    }
}

