/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.ProperTrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceTrackingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.common.TrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "CapturedVarDescriptor", "Transformer", "backend"})
public final class CapturedVarsOptimizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        new Transformer(internalClassName, methodNode).run();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010/\u001a\u00020\u000eJ\b\u00100\u001a\u000201H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010*R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\f\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceValueDescriptor;", "newInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "refType", "Lorg/jetbrains/org/objectweb/asm/Type;", "valueType", "(Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getFieldInsns", "", "Lorg/jetbrains/org/objectweb/asm/tree/FieldInsnNode;", "getGetFieldInsns", "()Ljava/util/Collection;", "hazard", "", "getHazard", "()Z", "setHazard", "(Z)V", "initCallInsn", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "getInitCallInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "setInitCallInsn", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;)V", "localVar", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "getLocalVar", "()Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "setLocalVar", "(Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;)V", "localVarIndex", "", "getLocalVarIndex", "()I", "setLocalVarIndex", "(I)V", "getNewInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "putFieldInsns", "getPutFieldInsns", "getRefType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getValueType", "wrapperInsns", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getWrapperInsns", "canRewrite", "onUseAsTainted", "", "backend"})
    private static final class CapturedVarDescriptor
    implements ReferenceValueDescriptor {
        @NotNull
        private final TypeInsnNode newInsn;
        @NotNull
        private final Type refType;
        @NotNull
        private final Type valueType;
        private boolean hazard;
        @Nullable
        private MethodInsnNode initCallInsn;
        @Nullable
        private LocalVariableNode localVar;
        private int localVarIndex;
        @NotNull
        private final Collection<AbstractInsnNode> wrapperInsns;
        @NotNull
        private final Collection<FieldInsnNode> getFieldInsns;
        @NotNull
        private final Collection<FieldInsnNode> putFieldInsns;

        public CapturedVarDescriptor(@NotNull TypeInsnNode newInsn, @NotNull Type refType, @NotNull Type valueType) {
            Intrinsics.checkNotNullParameter((Object)newInsn, (String)"newInsn");
            Intrinsics.checkNotNullParameter((Object)refType, (String)"refType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            this.newInsn = newInsn;
            this.refType = refType;
            this.valueType = valueType;
            this.localVarIndex = -1;
            this.wrapperInsns = new LinkedHashSet();
            this.getFieldInsns = new LinkedHashSet();
            this.putFieldInsns = new LinkedHashSet();
        }

        @NotNull
        public final TypeInsnNode getNewInsn() {
            return this.newInsn;
        }

        @NotNull
        public final Type getRefType() {
            return this.refType;
        }

        @NotNull
        public final Type getValueType() {
            return this.valueType;
        }

        public final boolean getHazard() {
            return this.hazard;
        }

        public final void setHazard(boolean bl) {
            this.hazard = bl;
        }

        @Nullable
        public final MethodInsnNode getInitCallInsn() {
            return this.initCallInsn;
        }

        public final void setInitCallInsn(@Nullable MethodInsnNode methodInsnNode) {
            this.initCallInsn = methodInsnNode;
        }

        @Nullable
        public final LocalVariableNode getLocalVar() {
            return this.localVar;
        }

        public final void setLocalVar(@Nullable LocalVariableNode localVariableNode) {
            this.localVar = localVariableNode;
        }

        public final int getLocalVarIndex() {
            return this.localVarIndex;
        }

        public final void setLocalVarIndex(int n) {
            this.localVarIndex = n;
        }

        @NotNull
        public final Collection<AbstractInsnNode> getWrapperInsns() {
            return this.wrapperInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getGetFieldInsns() {
            return this.getFieldInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getPutFieldInsns() {
            return this.putFieldInsns;
        }

        @Override
        public void onUseAsTainted() {
            this.hazard = true;
        }

        public final boolean canRewrite() {
            return !this.hazard && this.initCallInsn != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J%\u0010\u001a\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\t*\u00020\u0014H\u0002J\f\u0010 \u001a\u00020!*\u00020\u001dH\u0002J\u0014\u0010\"\u001a\u00020\u0010*\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "refValues", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lkotlin/collections/ArrayList;", "refValuesByNewInsn", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "Lkotlin/collections/LinkedHashMap;", "assignLocalVars", "", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "([Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "createRefValues", "rewriteRefValue", "capturedVar", "run", "trackPops", "findCleanInstructions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "getCapturedVarOrNull", "getIndex", "", "removeOrReplaceByNop", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "insn", "Interpreter", "backend"})
    @SourceDebugExtension(value={"SMAP\nCapturedVarsOptimizationMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedVarsOptimizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1#2:244\n2624#3,3:245\n1855#3,2:248\n1855#3,2:250\n1855#3,2:252\n*S KotlinDebug\n*F\n+ 1 CapturedVarsOptimizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer\n*L\n201#1:245,3\n225#1:248,2\n226#1:250,2\n227#1:252,2\n*E\n"})
    private static final class Transformer {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final ArrayList<CapturedVarDescriptor> refValues;
        @NotNull
        private final LinkedHashMap<TypeInsnNode, CapturedVarDescriptor> refValuesByNewInsn;

        public Transformer(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
            this.refValues = new ArrayList();
            this.refValuesByNewInsn = new LinkedHashMap();
        }

        public final void run() {
            this.createRefValues();
            if (this.refValues.isEmpty()) {
                return;
            }
            Frame<V>[] frameArray = MethodTransformer.analyze(this.internalClassName, this.methodNode, new Interpreter());
            Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(...)");
            Frame<V>[] frames = frameArray;
            this.trackPops(frames);
            this.assignLocalVars(frames);
            for (CapturedVarDescriptor refValue : this.refValues) {
                if (!refValue.canRewrite()) continue;
                Intrinsics.checkNotNull((Object)refValue);
                this.rewriteRefValue(refValue);
            }
            UtilKt.removeEmptyCatchBlocks(this.methodNode);
            UtilKt.removeUnusedLocalVariables(this.methodNode);
        }

        private final int getIndex(AbstractInsnNode $this$getIndex) {
            return this.methodNode.instructions.indexOf($this$getIndex);
        }

        private final void createRefValues() {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            for (AbstractInsnNode insn : UtilKt.asSequence(insnList)) {
                Type valueType;
                Type type2;
                if (insn.getOpcode() != 187 || !(insn instanceof TypeInsnNode) || !AsmTypes.isSharedVarType(type2 = Type.getObjectType(((TypeInsnNode)insn).desc)) || CapturedVarsOptimizationMethodTransformerKt.getREF_TYPE_TO_ELEMENT_TYPE().get(type2.getInternalName()) == null) continue;
                TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
                Intrinsics.checkNotNull((Object)type2);
                CapturedVarDescriptor refValue = new CapturedVarDescriptor(typeInsnNode, type2, valueType);
                this.refValues.add(refValue);
                ((Map)this.refValuesByNewInsn).put(insn, refValue);
            }
        }

        private final void trackPops(Frame<BasicValue>[] frames) {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterator iterator2 = UtilKt.asSequence(insnList).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                AbstractInsnNode insn = (AbstractInsnNode)iterator2.next();
                if (frames[i] == null) continue;
                switch (insn.getOpcode()) {
                    case 87: {
                        Frame<BasicValue> frame;
                        Object object = StackTransformationUtilsKt.top(frame);
                        if (object != null && (object = this.getCapturedVarOrNull((BasicValue)object)) != null) {
                            Object $this$trackPops_u24lambda_u240 = object;
                            boolean bl = false;
                            ((CapturedVarDescriptor)$this$trackPops_u24lambda_u240).getWrapperInsns().add(insn);
                        }
                        break;
                    }
                    case 88: {
                        BasicValue top;
                        Frame<BasicValue> frame;
                        BasicValue basicValue = top = StackTransformationUtilsKt.top(frame);
                        boolean bl = basicValue != null ? basicValue.getSize() == 1 : false;
                        if (!bl) break;
                        CapturedVarDescriptor capturedVarDescriptor = this.getCapturedVarOrNull(top);
                        if (capturedVarDescriptor != null) {
                            capturedVarDescriptor.setHazard(true);
                        }
                        BasicValue basicValue2 = StackTransformationUtilsKt.peek(frame, 1);
                        CapturedVarDescriptor capturedVarDescriptor2 = basicValue2 != null ? this.getCapturedVarOrNull(basicValue2) : null;
                        if (capturedVarDescriptor2 == null) break;
                        capturedVarDescriptor2.setHazard(true);
                    }
                }
            }
        }

        private final CapturedVarDescriptor getCapturedVarOrNull(BasicValue $this$getCapturedVarOrNull) {
            ProperTrackedReferenceValue properTrackedReferenceValue = $this$getCapturedVarOrNull instanceof ProperTrackedReferenceValue ? (ProperTrackedReferenceValue)$this$getCapturedVarOrNull : null;
            ReferenceValueDescriptor referenceValueDescriptor = properTrackedReferenceValue != null ? properTrackedReferenceValue.getDescriptor() : null;
            return referenceValueDescriptor instanceof CapturedVarDescriptor ? (CapturedVarDescriptor)referenceValueDescriptor : null;
        }

        private final void assignLocalVars(Frame<BasicValue>[] frames) {
            for (LocalVariableNode localVar : this.methodNode.localVariables) {
                CapturedVarDescriptor descriptor2;
                Frame<BasicValue> startFrame;
                Type type2 = Type.getType(localVar.desc);
                if (!AsmTypes.isSharedVarType(type2)) continue;
                LabelNode labelNode = localVar.start;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
                if (frames[this.getIndex(labelNode)] == null) continue;
                BasicValue basicValue = startFrame.getLocal(localVar.index);
                ProperTrackedReferenceValue properTrackedReferenceValue = basicValue instanceof ProperTrackedReferenceValue ? (ProperTrackedReferenceValue)basicValue : null;
                if (properTrackedReferenceValue == null) continue;
                ProperTrackedReferenceValue refValue = properTrackedReferenceValue;
                ReferenceValueDescriptor referenceValueDescriptor = refValue.getDescriptor();
                CapturedVarDescriptor capturedVarDescriptor = referenceValueDescriptor instanceof CapturedVarDescriptor ? (CapturedVarDescriptor)referenceValueDescriptor : null;
                if (capturedVarDescriptor == null || (descriptor2 = capturedVarDescriptor).getHazard()) continue;
                if (descriptor2.getLocalVar() == null) {
                    descriptor2.setLocalVar(localVar);
                    continue;
                }
                descriptor2.setHazard(true);
            }
            for (CapturedVarDescriptor refValue : this.refValues) {
                if (refValue.getHazard()) continue;
                if (refValue.getLocalVar() == null || refValue.getValueType().getSize() != 1) {
                    refValue.setLocalVarIndex(this.methodNode.maxLocals);
                    MethodNode methodNode = this.methodNode;
                    methodNode.maxLocals += refValue.getValueType().getSize();
                    continue;
                }
                LocalVariableNode localVariableNode = refValue.getLocalVar();
                Intrinsics.checkNotNull((Object)localVariableNode);
                refValue.setLocalVarIndex(localVariableNode.index);
            }
        }

        private final Sequence<AbstractInsnNode> findCleanInstructions(LocalVariableNode $this$findCleanInstructions) {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            return SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)new InsnSequence(insnList), (Function1)((Function1)new Function1<AbstractInsnNode, Boolean>($this$findCleanInstructions){
                final /* synthetic */ LocalVariableNode $this_findCleanInstructions;
                {
                    this.$this_findCleanInstructions = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AbstractInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$this_findCleanInstructions.start);
                }
            })), (Function1)((Function1)new Function1<AbstractInsnNode, Boolean>($this$findCleanInstructions){
                final /* synthetic */ LocalVariableNode $this_findCleanInstructions;
                {
                    this.$this_findCleanInstructions = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AbstractInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$this_findCleanInstructions.end);
                }
            })), (Function1)((Function1)new Function1<AbstractInsnNode, Boolean>($this$findCleanInstructions){
                final /* synthetic */ LocalVariableNode $this_findCleanInstructions;
                {
                    this.$this_findCleanInstructions = $receiver;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull AbstractInsnNode it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it instanceof VarInsnNode && ((VarInsnNode)it).getOpcode() == 58 && ((VarInsnNode)it).var == this.$this_findCleanInstructions.index) {
                        AbstractInsnNode abstractInsnNode = ((VarInsnNode)it).getPrevious();
                        boolean bl2 = abstractInsnNode != null ? abstractInsnNode.getOpcode() == 1 : false;
                        if (bl2) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            }));
        }

        private final void removeOrReplaceByNop(InsnList $this$removeOrReplaceByNop, AbstractInsnNode insn) {
            if (insn.getPrevious() instanceof LineNumberNode && insn.getNext() instanceof LabelNode && insn.getNext().getNext() instanceof LineNumberNode) {
                $this$removeOrReplaceByNop.set(insn, new InsnNode(0));
            } else {
                $this$removeOrReplaceByNop.remove(insn);
            }
        }

        private final void rewriteRefValue(CapturedVarDescriptor capturedVar) {
            AbstractInsnNode it;
            InsnList $this$rewriteRefValue_u24lambda_u245 = this.methodNode.instructions;
            boolean bl = false;
            int loadOpcode = capturedVar.getValueType().getOpcode(21);
            int storeOpcode = capturedVar.getValueType().getOpcode(54);
            LocalVariableNode localVar = capturedVar.getLocalVar();
            if (localVar != null) {
                boolean bl2;
                block10: {
                    Iterable $this$none$iv = capturedVar.getPutFieldInsns();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator iterator2 = $this$none$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            it = (FieldInsnNode)element$iv;
                            boolean bl3 = false;
                            int n = this.getIndex(it);
                            LabelNode labelNode = localVar.start;
                            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
                            if (!(n < this.getIndex(labelNode))) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    $this$rewriteRefValue_u24lambda_u245.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                    $this$rewriteRefValue_u24lambda_u245.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
                }
                for (AbstractInsnNode insn : this.findCleanInstructions(localVar)) {
                    if (storeOpcode == 58) {
                        $this$rewriteRefValue_u24lambda_u245.set(insn.getPrevious(), new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                        continue;
                    }
                    $this$rewriteRefValue_u24lambda_u245.remove(insn.getPrevious());
                    $this$rewriteRefValue_u24lambda_u245.remove(insn);
                }
                localVar.index = capturedVar.getLocalVarIndex();
                localVar.desc = capturedVar.getValueType().getDescriptor();
                localVar.signature = null;
            }
            $this$rewriteRefValue_u24lambda_u245.remove(capturedVar.getNewInsn());
            MethodInsnNode methodInsnNode = capturedVar.getInitCallInsn();
            Intrinsics.checkNotNull((Object)methodInsnNode);
            $this$rewriteRefValue_u24lambda_u245.remove(methodInsnNode);
            Iterable $this$forEach$iv = capturedVar.getWrapperInsns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)$this$rewriteRefValue_u24lambda_u245);
                this.removeOrReplaceByNop($this$rewriteRefValue_u24lambda_u245, it);
            }
            $this$forEach$iv = capturedVar.getGetFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl5 = false;
                $this$rewriteRefValue_u24lambda_u245.set(it, new VarInsnNode(loadOpcode, capturedVar.getLocalVarIndex()));
            }
            $this$forEach$iv = capturedVar.getPutFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl6 = false;
                $this$rewriteRefValue_u24lambda_u245.set(it, new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer$Interpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceTrackingInterpreter;", "(Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;)V", "newOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "processRefValueUsage", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/common/TrackedReferenceValue;", "position", "", "backend"})
        @SourceDebugExtension(value={"SMAP\nCapturedVarsOptimizationMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedVarsOptimizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer$Interpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
        private final class Interpreter
        extends ReferenceTrackingInterpreter {
            @Override
            @NotNull
            public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
                BasicValue basicValue;
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                CapturedVarDescriptor capturedVarDescriptor = (CapturedVarDescriptor)((Map)Transformer.this.refValuesByNewInsn).get(insn);
                if (capturedVarDescriptor != null) {
                    CapturedVarDescriptor it = capturedVarDescriptor;
                    boolean bl = false;
                    basicValue = new ProperTrackedReferenceValue(it.getRefType(), it);
                } else {
                    BasicValue basicValue2 = super.newOperation(insn);
                    basicValue = basicValue2;
                    Intrinsics.checkNotNullExpressionValue((Object)basicValue2, (String)"newOperation(...)");
                }
                return basicValue;
            }

            @Override
            protected void processRefValueUsage(@NotNull TrackedReferenceValue value2, @NotNull AbstractInsnNode insn, int position) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                for (ReferenceValueDescriptor descriptor2 : value2.getDescriptors()) {
                    if (!(descriptor2 instanceof CapturedVarDescriptor)) {
                        throw new AssertionError((Object)("Unexpected descriptor: " + descriptor2));
                    }
                    if (insn.getOpcode() == 89) {
                        ((CapturedVarDescriptor)descriptor2).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 25) {
                        ((CapturedVarDescriptor)descriptor2).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 58) {
                        ((CapturedVarDescriptor)descriptor2).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 180 && insn instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insn).name, (Object)"element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor2).getGetFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 181 && insn instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insn).name, (Object)"element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor2).getPutFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 183 && insn instanceof MethodInsnNode && Intrinsics.areEqual((Object)((MethodInsnNode)insn).name, (Object)"<init>") && position == 0) {
                        if (((CapturedVarDescriptor)descriptor2).getInitCallInsn() != null && !Intrinsics.areEqual((Object)((CapturedVarDescriptor)descriptor2).getInitCallInsn(), (Object)insn)) {
                            ((CapturedVarDescriptor)descriptor2).setHazard(true);
                            continue;
                        }
                        ((CapturedVarDescriptor)descriptor2).setInitCallInsn((MethodInsnNode)insn);
                        continue;
                    }
                    ((CapturedVarDescriptor)descriptor2).setHazard(true);
                }
            }
        }
    }
}

