/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.shared.impl;

import java.util.NoSuchElementException;

public class InternalPreconditions {
    public static void checkArrayType(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ArrayStoreException(String.valueOf(errorMessage));
        }
    }

    public static void checkElement(boolean expression) {
        InternalPreconditions.checkCriticalElement(expression);
    }

    public static void checkElement(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new NoSuchElementException(String.valueOf(errorMessage));
        }
    }

    public static void checkCriticalElement(boolean expression) {
        if (!expression) {
            throw new NoSuchElementException();
        }
    }

    public static void checkArgument(boolean expression) {
        InternalPreconditions.checkCriticalArgument(expression);
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        InternalPreconditions.checkCriticalArgument(expression, errorMessage);
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        InternalPreconditions.checkCriticalArgument(expression, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkCriticalArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkCriticalArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkCriticalArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(InternalPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static void checkNotNull(Object reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
    }

    public static void checkArraySize(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("Negative array size: " + size);
        }
    }

    public static void checkElementIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    public static void checkPositionIndex(int index, int size) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        InternalPreconditions.checkCriticalPositionIndexes(start, end, size);
    }

    public static void checkCriticalPositionIndexes(int start, int end, int size) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("fromIndex: " + start + " < 0");
        }
        if (end > size) {
            throw new IndexOutOfBoundsException("toIndex: " + end + " > size " + size);
        }
        if (start > end) {
            throw new IllegalArgumentException("fromIndex: " + start + " > toIndex: " + end);
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

