/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.lang.MutableString;
import org.campagnelab.goby.util.pool.Resettable;

public class GobyQuickSeqvar
implements Resettable {
    MutableString from = new MutableString();
    MutableString to = new MutableString();
    private int readIndex;
    private int position;
    ByteList toQuals = new ByteArrayList();
    int lastIndexPosition;

    public GobyQuickSeqvar() {
        this.reset();
    }

    @Override
    public void reset() {
        this.from.length(0);
        this.to.length(0);
        this.toQuals.clear();
        this.setReadIndex(1);
        this.setPosition(0);
        this.lastIndexPosition = Integer.MAX_VALUE;
    }

    public String getFrom() {
        return this.from.toString();
    }

    public String getTo() {
        return this.to.toString();
    }

    public ByteList getToQualities() {
        return this.toQuals;
    }

    public byte[] getToQualitiesAsBytes() {
        return this.toQuals.toByteArray();
    }

    public int getReadIndex() {
        return this.readIndex;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        String s = "sequence_variations {\n";
        s = s + "  to: \"" + this.to.toString() + "\"\n";
        s = s + "  from: \"" + this.from.toString() + "\"\n";
        s = s + "  position: " + this.getPosition() + "\n";
        s = s + "  to_quality: \"" + this.toQuals.toString() + "\"\n";
        s = s + "  read_index: " + this.getReadIndex() + "\n";
        s = s + "}\n";
        return s;
    }

    public final void setPosition(int position) {
        assert (position >= 0) : "position must be positive. seqVar.position must be >=0.";
        this.position = position;
    }

    public final void setReadIndex(int readIndex) {
        assert (readIndex >= 1) : "readIndex cannot be zero. seqVar.readIndex is one-based.";
        this.readIndex = readIndex;
    }
}

