/*
 * Decompiled with CFR 0.152.
 */
package free.util.audio;

import free.util.IOUtilities;
import free.util.audio.AudioClip;
import free.util.audio.AudioPlayer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UnixDevAudioPlayer
implements AudioPlayer {
    public boolean isSupported() {
        return new File("/dev/audio").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(AudioClip audioClip) throws IOException {
        OutputStream outputStream = null;
        try {
            byte[] byArray = audioClip.getData();
            outputStream = new FileOutputStream("/dev/audio");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            IOUtilities.pump(byteArrayInputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

