/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.swing.StrictPlainDocument;

public class IntegerStrictPlainDocument
extends StrictPlainDocument {
    private final long minValue;
    private final long maxValue;
    private final int radix;

    public IntegerStrictPlainDocument(long l, long l2, int n) {
        this.minValue = l;
        this.maxValue = l2;
        this.radix = n;
    }

    public IntegerStrictPlainDocument(long l, long l2) {
        this(l, l2, 10);
    }

    public boolean isChangeAccepted(String string, String string2) {
        if (string2.length() == 0) {
            return true;
        }
        try {
            long l = Long.parseLong(string2, this.getRadix());
            return l >= this.getMinValue() && l <= this.getMaxValue();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int getRadix() {
        return this.radix;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }
}

