/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedTableImpl;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamMapValues;
import org.apache.kafka.streams.kstream.internals.KStreamPeek;
import org.apache.kafka.streams.kstream.internals.KStreamPrint;
import org.apache.kafka.streams.kstream.internals.KTableFilter;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableInnerJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoinMerger;
import org.apache.kafka.streams.kstream.internals.KTableKTableLeftJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableOuterJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.kstream.internals.KTableMapValues;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableRepartitionMap;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KTableSourceValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.PrintForeachAction;
import org.apache.kafka.streams.kstream.internals.SerializedInternal;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

public class KTableImpl<K, S, V>
extends AbstractStream<K>
implements KTable<K, V> {
    public static final String SOURCE_NAME = "KTABLE-SOURCE-";
    public static final String STATE_STORE_NAME = "STATE-STORE-";
    private static final String FILTER_NAME = "KTABLE-FILTER-";
    private static final String FOREACH_NAME = "KTABLE-FOREACH-";
    private static final String JOINTHIS_NAME = "KTABLE-JOINTHIS-";
    private static final String JOINOTHER_NAME = "KTABLE-JOINOTHER-";
    private static final String MAPVALUES_NAME = "KTABLE-MAPVALUES-";
    private static final String MERGE_NAME = "KTABLE-MERGE-";
    private static final String PRINTING_NAME = "KSTREAM-PRINTER-";
    private static final String SELECT_NAME = "KTABLE-SELECT-";
    private static final String TOSTREAM_NAME = "KTABLE-TOSTREAM-";
    private final ProcessorSupplier<?, ?> processorSupplier;
    private final KeyValueMapper<K, V, String> defaultKeyValueMapper;
    private final String queryableStoreName;
    private final boolean isQueryable;
    private boolean sendOldValues = false;
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;

    public KTableImpl(InternalStreamsBuilder builder, String name, ProcessorSupplier<?, ?> processorSupplier, Set<String> sourceNodes, String queryableStoreName, boolean isQueryable) {
        super(builder, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.queryableStoreName = queryableStoreName;
        this.keySerde = null;
        this.valSerde = null;
        this.isQueryable = isQueryable;
        this.defaultKeyValueMapper = new KeyValueMapper<K, V, String>(){

            @Override
            public String apply(K key, V value) {
                return String.format("%s, %s", key, value);
            }
        };
    }

    public KTableImpl(InternalStreamsBuilder builder, String name, ProcessorSupplier<?, ?> processorSupplier, Serde<K> keySerde, Serde<V> valSerde, Set<String> sourceNodes, String queryableStoreName, boolean isQueryable) {
        super(builder, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.queryableStoreName = queryableStoreName;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.isQueryable = isQueryable;
        this.defaultKeyValueMapper = new KeyValueMapper<K, V, String>(){

            @Override
            public String apply(K key, V value) {
                return String.format("%s, %s", key, value);
            }
        };
    }

    @Override
    public String queryableStoreName() {
        if (!this.isQueryable) {
            return null;
        }
        return this.queryableStoreName;
    }

    private KTable<K, V> doFilter(Predicate<? super K, ? super V> predicate, StateStoreSupplier<KeyValueStore> storeSupplier, boolean isFilterNot) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        String name = this.builder.newProcessorName(FILTER_NAME);
        String internalStoreName = null;
        if (storeSupplier != null) {
            internalStoreName = storeSupplier.name();
        }
        KTableFilter<? super K, ? super V> processorSupplier = new KTableFilter<K, V>(this, predicate, isFilterNot, internalStoreName);
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        if (storeSupplier != null) {
            this.builder.internalTopologyBuilder.addStateStore(storeSupplier, name);
            return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.keySerde, this.valSerde, this.sourceNodes, internalStoreName, true);
        }
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.sourceNodes, this.queryableStoreName, false);
    }

    private KTable<K, V> doFilter(Predicate<? super K, ? super V> predicate, MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized, boolean filterNot) {
        String name = this.builder.newProcessorName(FILTER_NAME);
        KTableFilter<? super K, ? super V> processorSupplier = new KTableFilter<K, V>(this, predicate, filterNot, materialized.storeName());
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        StoreBuilder<KeyValueStore<K, V>> builder = new KeyValueStoreMaterializer<K, V>(materialized).materialize();
        this.builder.internalTopologyBuilder.addStateStore(builder, name);
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.keySerde, this.valSerde, this.sourceNodes, builder.name(), true);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate) {
        return this.filter(predicate, (String)null);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        return this.doFilter(predicate, new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, FILTER_NAME), false);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate, String queryableStoreName) {
        StateStoreSupplier<KeyValueStore> storeSupplier = null;
        if (queryableStoreName != null) {
            storeSupplier = KTableImpl.keyValueStore(this.keySerde, this.valSerde, queryableStoreName);
        }
        return this.doFilter(predicate, storeSupplier, false);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doFilter(predicate, storeSupplier, false);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate) {
        return this.filterNot(predicate, (String)null);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        return this.doFilter(predicate, new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, FILTER_NAME), true);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate, String queryableStoreName) {
        StateStoreSupplier<KeyValueStore> storeSupplier = null;
        if (queryableStoreName != null) {
            storeSupplier = KTableImpl.keyValueStore(this.keySerde, this.valSerde, queryableStoreName);
        }
        return this.doFilter(predicate, storeSupplier, true);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doFilter(predicate, storeSupplier, true);
    }

    private <V1> KTable<K, V1> doMapValues(ValueMapperWithKey<? super K, ? super V, ? extends V1> mapper, Serde<V1> valueSerde, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(mapper);
        String name = this.builder.newProcessorName(MAPVALUES_NAME);
        String internalStoreName = null;
        if (storeSupplier != null) {
            internalStoreName = storeSupplier.name();
        }
        KTableMapValues<? super K, ? super V, ? extends V1> processorSupplier = new KTableMapValues<K, V, V1>(this, mapper, internalStoreName);
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        if (storeSupplier != null) {
            this.builder.internalTopologyBuilder.addStateStore(storeSupplier, name);
            return new KTableImpl<K, S, V1>(this.builder, name, processorSupplier, this.keySerde, valueSerde, this.sourceNodes, internalStoreName, true);
        }
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.sourceNodes, this.queryableStoreName, false);
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper) {
        return this.doMapValues(KTableImpl.withKey(mapper), null, null);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> mapper) {
        return this.doMapValues(mapper, null, null);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapper<? super V, ? extends VR> mapper, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.mapValues(KTableImpl.withKey(mapper), materialized);
    }

    @Override
    public <VR> KTable<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> mapper, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, MAPVALUES_NAME);
        String name = this.builder.newProcessorName(MAPVALUES_NAME);
        KTableMapValues<? super K, ? super V, ? extends VR> processorSupplier = new KTableMapValues<K, V, VR>(this, mapper, materializedInternal.storeName());
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
        this.builder.internalTopologyBuilder.addStateStore(new KeyValueStoreMaterializer<K, VR>(materializedInternal).materialize(), name);
        return new KTableImpl<K, S, V>(this.builder, name, processorSupplier, this.sourceNodes, this.queryableStoreName, true);
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper, Serde<V1> valueSerde, String queryableStoreName) {
        return this.mapValues(KTableImpl.withKey(mapper), Materialized.as(queryableStoreName).withValueSerde(valueSerde).withKeySerde(this.keySerde));
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper, Serde<V1> valueSerde, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doMapValues(KTableImpl.withKey(mapper), valueSerde, storeSupplier);
    }

    @Override
    public void print() {
        this.print(null, null, this.name);
    }

    @Override
    public void print(String label) {
        this.print(null, null, label);
    }

    @Override
    public void print(Serde<K> keySerde, Serde<V> valSerde) {
        this.print(keySerde, valSerde, this.name);
    }

    @Override
    public void print(Serde<K> keySerde, Serde<V> valSerde, String label) {
        Objects.requireNonNull(label, "label can't be null");
        String name = this.builder.newProcessorName(PRINTING_NAME);
        this.builder.internalTopologyBuilder.addProcessor(name, new KStreamPrint<K, V>(new PrintForeachAction<K, V>(null, this.defaultKeyValueMapper, label)), this.name);
    }

    @Override
    public void writeAsText(String filePath) {
        this.writeAsText(filePath, this.name, null, null);
    }

    @Override
    public void writeAsText(String filePath, String label) {
        this.writeAsText(filePath, label, null, null);
    }

    @Override
    public void writeAsText(String filePath, Serde<K> keySerde, Serde<V> valSerde) {
        this.writeAsText(filePath, this.name, keySerde, valSerde);
    }

    @Override
    public void writeAsText(String filePath, String label, Serde<K> keySerde, Serde<V> valSerde) {
        Objects.requireNonNull(filePath, "filePath can't be null");
        Objects.requireNonNull(label, "label can't be null");
        if (filePath.trim().isEmpty()) {
            throw new TopologyException("filePath can't be an empty string");
        }
        String name = this.builder.newProcessorName(PRINTING_NAME);
        try {
            PrintWriter printWriter = new PrintWriter(filePath, StandardCharsets.UTF_8.name());
            this.builder.internalTopologyBuilder.addProcessor(name, new KStreamPrint<K, V>(new PrintForeachAction<K, V>(printWriter, this.defaultKeyValueMapper, label)), this.name);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new TopologyException(String.format("Unable to write stream to file at [%s] %s", filePath, e.getMessage()));
        }
    }

    @Override
    public void foreach(final ForeachAction<? super K, ? super V> action) {
        Objects.requireNonNull(action, "action can't be null");
        String name = this.builder.newProcessorName(FOREACH_NAME);
        KStreamPeek processorSupplier = new KStreamPeek(new ForeachAction<K, Change<V>>(){

            @Override
            public void apply(K key, Change<V> value) {
                action.apply(key, value.newValue);
            }
        }, false);
        this.builder.internalTopologyBuilder.addProcessor(name, processorSupplier, this.name);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic, String queryableStoreName) {
        this.to(keySerde, valSerde, partitioner, topic);
        return this.builder.table(topic, new ConsumedInternal<K, V>(keySerde, valSerde, new FailOnInvalidTimestamp(), null), new MaterializedInternal(Materialized.with(keySerde, valSerde), this.builder, TOSTREAM_NAME));
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        this.to(keySerde, valSerde, partitioner, topic);
        ConsumedInternal<K, V> consumed = new ConsumedInternal<K, V>(Consumed.with(keySerde, valSerde, new FailOnInvalidTimestamp(), null));
        return this.builder.table(topic, consumed, storeSupplier);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        return this.through(keySerde, valSerde, partitioner, topic, (String)null);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic, String queryableStoreName) {
        return this.through(keySerde, valSerde, null, topic, queryableStoreName);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.through(keySerde, valSerde, null, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        return this.through(keySerde, valSerde, null, topic, (String)null);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, String topic, String queryableStoreName) {
        return this.through(null, null, partitioner, topic, queryableStoreName);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.through(null, null, partitioner, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        return this.through(null, null, partitioner, topic, (String)null);
    }

    @Override
    public KTable<K, V> through(String topic, String queryableStoreName) {
        return this.through(null, null, null, topic, queryableStoreName);
    }

    @Override
    public KTable<K, V> through(String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.through(null, null, null, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(String topic) {
        return this.through(null, null, null, topic, (String)null);
    }

    @Override
    public void to(String topic) {
        this.to(null, null, null, topic);
    }

    @Override
    public void to(StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        this.to(null, null, partitioner, topic);
    }

    @Override
    public void to(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        this.toStream().to(keySerde, valSerde, null, topic);
    }

    @Override
    public void to(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        this.toStream().to(keySerde, valSerde, partitioner, topic);
    }

    @Override
    public KStream<K, V> toStream() {
        String name = this.builder.newProcessorName(TOSTREAM_NAME);
        this.builder.internalTopologyBuilder.addProcessor(name, new KStreamMapValues(new ValueMapperWithKey<K, Change<V>, V>(){

            @Override
            public V apply(K key, Change<V> change) {
                return change.newValue;
            }
        }), this.name);
        return new KStreamImpl(this.builder, name, this.sourceNodes, false);
    }

    @Override
    public <K1> KStream<K1, V> toStream(KeyValueMapper<? super K, ? super V, ? extends K1> mapper) {
        return this.toStream().selectKey(mapper);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, null, false, false);
    }

    @Override
    public <VO, VR> KTable<K, VR> join(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        return this.doJoin(other, joiner, new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, MERGE_NAME), false, false);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, Serde<R> joinSerde, String queryableStoreName) {
        return this.doJoin(other, joiner, false, false, joinSerde, queryableStoreName);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doJoin(other, joiner, false, false, storeSupplier);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, null, true, true);
    }

    @Override
    public <VO, VR> KTable<K, VR> outerJoin(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.doJoin(other, joiner, new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, MERGE_NAME), true, true);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, Serde<R> joinSerde, String queryableStoreName) {
        return this.doJoin(other, joiner, true, true, joinSerde, queryableStoreName);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doJoin(other, joiner, true, true, storeSupplier);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, null, true, false);
    }

    @Override
    public <VO, VR> KTable<K, VR> leftJoin(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.doJoin(other, joiner, new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, MERGE_NAME), true, false);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, Serde<R> joinSerde, String queryableStoreName) {
        return this.doJoin(other, joiner, true, false, joinSerde, queryableStoreName);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doJoin(other, joiner, true, false, storeSupplier);
    }

    private <V1, R> KTable<K, R> doJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, boolean leftOuter, boolean rightOuter, Serde<R> joinSerde, String queryableStoreName) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        StateStoreSupplier<KeyValueStore> storeSupplier = queryableStoreName == null ? null : KTableImpl.keyValueStore(this.keySerde, joinSerde, queryableStoreName);
        return this.doJoin(other, joiner, leftOuter, rightOuter, storeSupplier);
    }

    private <V1, R> KTable<K, R> doJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, boolean leftOuter, boolean rightOuter, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        String joinMergeName = this.builder.newProcessorName(MERGE_NAME);
        String internalQueryableName = storeSupplier == null ? null : storeSupplier.name();
        KTable<K, ? extends R> result = this.buildJoin((AbstractStream)((Object)other), joiner, leftOuter, rightOuter, joinMergeName, internalQueryableName);
        if (internalQueryableName != null) {
            this.builder.internalTopologyBuilder.addStateStore(storeSupplier, joinMergeName);
        }
        return result;
    }

    private <VO, VR> KTable<K, VR> doJoin(KTable<K, VO> other, ValueJoiner<? super V, ? super VO, ? extends VR> joiner, MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materialized, boolean leftOuter, boolean rightOuter) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        String internalQueryableName = materialized == null ? null : materialized.storeName();
        String joinMergeName = this.builder.newProcessorName(MERGE_NAME);
        KTable<K, ? extends VR> result = this.buildJoin((AbstractStream)((Object)other), joiner, leftOuter, rightOuter, joinMergeName, internalQueryableName);
        if (materialized != null) {
            StoreBuilder<KeyValueStore<K, VR>> storeBuilder = new KeyValueStoreMaterializer<K, VR>(materialized).materialize();
            this.builder.internalTopologyBuilder.addStateStore(storeBuilder, joinMergeName);
        }
        return result;
    }

    private <V1, R> KTable<K, R> buildJoin(AbstractStream<K> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, boolean leftOuter, boolean rightOuter, String joinMergeName, String internalQueryableName) {
        KTableKTableAbstractJoin joinOther;
        KTableKTableAbstractJoin joinThis;
        Set<String> allSourceNodes = this.ensureJoinableWith(other);
        if (leftOuter) {
            this.enableSendingOldValues();
        }
        if (rightOuter) {
            ((KTableImpl)other).enableSendingOldValues();
        }
        String joinThisName = this.builder.newProcessorName(JOINTHIS_NAME);
        String joinOtherName = this.builder.newProcessorName(JOINOTHER_NAME);
        if (!leftOuter) {
            joinThis = new KTableKTableInnerJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableInnerJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        } else if (!rightOuter) {
            joinThis = new KTableKTableLeftJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableRightJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        } else {
            joinThis = new KTableKTableOuterJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableOuterJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        }
        KTableKTableJoinMerger<K, V> joinMerge = new KTableKTableJoinMerger<K, V>(new KTableImpl<K, S, V>(this.builder, joinThisName, joinThis, this.sourceNodes, this.queryableStoreName, false), new KTableImpl<K, S, V>(this.builder, joinOtherName, joinOther, ((KTableImpl)other).sourceNodes, ((KTableImpl)other).queryableStoreName, false), internalQueryableName);
        this.builder.internalTopologyBuilder.addProcessor(joinThisName, joinThis, this.name);
        this.builder.internalTopologyBuilder.addProcessor(joinOtherName, joinOther, ((KTableImpl)other).name);
        this.builder.internalTopologyBuilder.addProcessor(joinMergeName, joinMerge, joinThisName, joinOtherName);
        this.builder.internalTopologyBuilder.connectProcessorAndStateStores(joinThisName, ((KTableImpl)other).valueGetterSupplier().storeNames());
        this.builder.internalTopologyBuilder.connectProcessorAndStateStores(joinOtherName, this.valueGetterSupplier().storeNames());
        return new KTableImpl<K, S, V>(this.builder, joinMergeName, joinMerge, allSourceNodes, internalQueryableName, internalQueryableName != null);
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector, Serde<K1> keySerde, Serde<V1> valueSerde) {
        return this.groupBy(selector, Serialized.with(keySerde, valueSerde));
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector) {
        return this.groupBy(selector, Serialized.with(null, null));
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector, Serialized<K1, V1> serialized) {
        Objects.requireNonNull(selector, "selector can't be null");
        Objects.requireNonNull(serialized, "serialized can't be null");
        String selectName = this.builder.newProcessorName(SELECT_NAME);
        KTableRepartitionMap<? super K, ? super V, K1, V1> selectSupplier = new KTableRepartitionMap<K, V, K1, V1>(this, selector);
        this.builder.internalTopologyBuilder.addProcessor(selectName, selectSupplier, this.name);
        this.enableSendingOldValues();
        SerializedInternal<K1, V1> serializedInternal = new SerializedInternal<K1, V1>(serialized);
        return new KGroupedTableImpl<K1, V1>(this.builder, selectName, this.name, serializedInternal.keySerde(), serializedInternal.valueSerde());
    }

    KTableValueGetterSupplier<K, V> valueGetterSupplier() {
        if (this.processorSupplier instanceof KTableSource) {
            KTableSource source = (KTableSource)this.processorSupplier;
            return new KTableSourceValueGetterSupplier(source.storeName);
        }
        if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
            return ((KStreamAggProcessorSupplier)this.processorSupplier).view();
        }
        return ((KTableProcessorSupplier)this.processorSupplier).view();
    }

    void enableSendingOldValues() {
        if (!this.sendOldValues) {
            if (this.processorSupplier instanceof KTableSource) {
                KTableSource source = (KTableSource)this.processorSupplier;
                source.enableSendingOldValues();
            } else if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
                ((KStreamAggProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            } else {
                ((KTableProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            }
            this.sendOldValues = true;
        }
    }

    boolean sendingOldValueEnabled() {
        return this.sendOldValues;
    }
}

