/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.AdminClientIntegrationTest;
import kafka.api.Both$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011eU1tYN\u001bH.\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\u000eBI6Lgn\u00117jK:$\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u0002\n\u001b%\u0011aB\u0001\u0002\n'\u0006\u001cHnU3ukBDQ\u0001\u0005\u0001\u0005\u0002E\ta\u0001P5oSRtD#\u0001\n\u0011\u0005%\u0001\u0001\"\u0002\u000b\u0001\t#*\u0012\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u00051\u0002CA\f$\u001b\u0005A\"BA\r\u001b\u0003\u0011\tW\u000f\u001e5\u000b\u0005ma\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005uq\u0012AB2p[6|gN\u0003\u0002\u0006?)\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0013\t!\u0003D\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"Aa\u0005\u0001EC\u0002\u0013Es%\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0003!\u00022!\u000b\u0017/\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#\u0001B*p[\u0016\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0005%|'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012AAR5mK\")q\u0007\u0001C!q\u0005\u00193m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=CK\u001a|'/Z*feZ,'o]*uCJ$H#A\u001d\u0011\u0005%R\u0014BA\u001e+\u0005\u0011)f.\u001b;\t\u000bu\u0002A\u0011\t\u001d\u0002\u000bM,G/\u00169)\u0005qz\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\"\u0003\u0015QWO\\5u\u0013\t!\u0015I\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\r\u0002!IaR\u0001\u000bG2,8\u000f^3s\u0003\u000edGc\u0001%O'B\u0011\u0011\nT\u0007\u0002\u0015*\u0011\u0011d\u0013\u0006\u00037\u0011I!!\u0014&\u0003\u0007\u0005\u001bG\u000eC\u0003P\u000b\u0002\u0007\u0001+\u0001\bqKJl\u0017n]:j_:$\u0016\u0010]3\u0011\u0005%\u000b\u0016B\u0001*K\u00059\u0001VM]7jgNLwN\u001c+za\u0016DQ\u0001V#A\u0002U\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u0005%3\u0016BA,K\u0005%y\u0005/\u001a:bi&|g\u000eC\u0003Z\u0001\u0011%!,A\u0007bI\u0012\u001cE.^:uKJ\f5\r\u001c\u000b\u0004smc\u0006\"B(Y\u0001\u0004\u0001\u0006\"\u0002+Y\u0001\u0004)\u0006\"\u00020\u0001\t\u0013y\u0016\u0001\u0005:f[>4Xm\u00117vgR,'/Q2m)\rI\u0004-\u0019\u0005\u0006\u001fv\u0003\r\u0001\u0015\u0005\u0006)v\u0003\r!\u0016\u0005\u0006G\u0002!\t\u0005O\u0001\ti\u0016\f'\u000fR8x]\"\u0012!-\u001a\t\u0003\u0001\u001aL!aZ!\u0003\u000b\u00053G/\u001a:\t\u000f%\u0004!\u0019!C\u0001U\u0006!\u0011m\u001973+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018\u001d\u0003\r\t7\r\\\u0005\u0003a6\u0014!\"Q2m\u0005&tG-\u001b8h\u0011\u0019\u0011\b\u0001)A\u0005W\u0006)\u0011m\u001973A!9A\u000f\u0001b\u0001\n\u0003Q\u0017\u0001B1dYNBaA\u001e\u0001!\u0002\u0013Y\u0017!B1dYN\u0002\u0003b\u0002=\u0001\u0005\u0004%\tA[\u0001\u0007M>|\u0017i\u00197\t\ri\u0004\u0001\u0015!\u0003l\u0003\u001d1wn\\!dY\u0002Bq\u0001 \u0001C\u0002\u0013\u0005!.\u0001\nue\u0006t7/Y2uS>t\u0017\r\\%e\u0003\u000ed\u0007B\u0002@\u0001A\u0003%1.A\nue\u0006t7/Y2uS>t\u0017\r\\%e\u0003\u000ed\u0007\u0005\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001k\u0003!9'o\\;q\u0003\u000ed\u0007bBA\u0003\u0001\u0001\u0006Ia[\u0001\nOJ|W\u000f]!dY\u0002Ba!!\u0003\u0001\t\u0003B\u0014!\u0005;fgR\f5\r\\(qKJ\fG/[8og\"\"\u0011qAA\u0007!\r\u0001\u0015qB\u0005\u0004\u0003#\t%\u0001\u0002+fgRDq!!\u0006\u0001\t\u0003\t9\"A\nxC&$hi\u001c:EKN\u001c'/\u001b2f\u0003\u000ed7\u000fF\u0004:\u00033\ti#a\u000e\t\u0011\u0005m\u00111\u0003a\u0001\u0003;\taa\u00197jK:$\b\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003Oq\u0012aB2mS\u0016tGo]\u0005\u0005\u0003W\t\tCA\u0006BI6Lgn\u00117jK:$\b\u0002CA\u0018\u0003'\u0001\r!!\r\u0002\r\u0019LG\u000e^3s!\ra\u00171G\u0005\u0004\u0003ki'\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0011!\tI$a\u0005A\u0002\u0005m\u0012\u0001B1dYN\u0004R!!\u0010\u0002L-tA!a\u0010\u0002HA\u0019\u0011\u0011\t\u0016\u000e\u0005\u0005\r#bAA#\r\u00051AH]8pizJ1!!\u0013+\u0003\u0019\u0001&/\u001a3fM&!\u0011QJA(\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u0013R\u0003BBA*\u0001\u0011\u0005\u0001(\u0001\nuKN$\u0018i\u00197Pa\u0016\u0014\u0018\r^5p]N\u0014\u0004\u0006BA)\u0003\u001bAa!!\u0017\u0001\t\u0003A\u0014A\b;fgR\fE\u000f^3naR$vn\u0011:fCR,\u0017J\u001c<bY&$\u0017i\u00197tQ\u0011\t9&!\u0004\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b\u0005Ab/\u001a:jMf\u001c\u0015-^:f\u0013N\u001cE.^:uKJ\fU\u000f\u001e5\u0015\u0007e\n\u0019\u0007\u0003\u0005\u0002f\u0005u\u0003\u0019AA4\u0003\u0005)\u0007\u0003BA5\u0003grA!a\u001b\u0002p9!\u0011\u0011IA7\u0013\u0005Y\u0013bAA9U\u00059\u0001/Y2lC\u001e,\u0017\u0002BA;\u0003o\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005E$\u0006C\u0004\u0002|\u0001!I!! \u0002-Q,7\u000f^!dY\u000e\u0013X-\u0019;f\u000f\u0016$H)\u001a7fi\u0016$2!OA@\u0011!\t\t)!\u001fA\u0002\u0005\r\u0015AC3ya\u0016\u001cG/Q;uQB\u0019\u0011&!\"\n\u0007\u0005\u001d%FA\u0004C_>dW-\u00198\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\u0006QA/Z:u\u0003\u000edw)\u001a;\u0015\u0007e\ny\t\u0003\u0005\u0002\u0002\u0006%\u0005\u0019AAB\u0011\u0019\t\u0019\n\u0001C\u0001q\u0005QB/Z:u\u0003\u000ed\u0017)\u001e;i_JL'0\u0019;j_:$UM\\5fI\"\"\u0011\u0011SA\u0007\u0001")
public class SaslSslAdminClientIntegrationTest
extends AdminClientIntegrationTest
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final AclBinding acl2;
    private final AclBinding acl3;
    private final AclBinding fooAcl;
    private final AclBinding transactionalIdAcl;
    private final AclBinding groupAcl;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    private Some<File> trustStoreFile$lzycompute() {
        SaslSslAdminClientIntegrationTest saslSslAdminClientIntegrationTest = this;
        synchronized (saslSslAdminClientIntegrationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        try (Authorizer authorizer = (Authorizer)CoreUtils$.MODULE$.createObject(SimpleAclAuthorizer.class.getName(), (Seq)Predef$.MODULE$.wrapRefArray(new Object[0]));){
            authorizer.configure(((KafkaConfig)this.configs().head()).originals());
            authorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)})), new Resource((kafka.security.auth.ResourceType)Topic$.MODULE$, "*"));
            authorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)})), new Resource((kafka.security.auth.ResourceType)Group$.MODULE$, "*"));
            authorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)Create$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)Delete$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)ClusterAction$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)AlterConfigs$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)Alter$.MODULE$)})), Resource$.MODULE$.ClusterResource());
        }
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GSSAPI"}))), (Option<String>)new Some((Object)"GSSAPI"), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    private Acl clusterAcl(PermissionType permissionType, Operation operation) {
        return new Acl(new KafkaPrincipal("User", "*"), permissionType, Acl$.MODULE$.WildCardHost(), operation);
    }

    private void addClusterAcl(PermissionType permissionType, Operation operation) {
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.clusterAcl(permissionType, operation)}));
        Authorizer authorizer = (Authorizer)((KafkaServer)this.servers().head()).apis().authorizer().get();
        Set prevAcls = authorizer.getAcls(Resource$.MODULE$.ClusterResource());
        authorizer.addAcls(acls, Resource$.MODULE$.ClusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)prevAcls.$plus$plus((GenTraversableOnce)acls)), authorizer, Resource$.MODULE$.ClusterResource());
    }

    private void removeClusterAcl(PermissionType permissionType, Operation operation) {
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.clusterAcl(permissionType, operation)}));
        Authorizer authorizer = (Authorizer)((KafkaServer)this.servers().head()).apis().authorizer().get();
        Set prevAcls = authorizer.getAcls(Resource$.MODULE$.ClusterResource());
        Assert.assertTrue((boolean)authorizer.removeAcls(acls, Resource$.MODULE$.ClusterResource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)prevAcls.$minus$minus((GenTraversableOnce)acls)), authorizer, Resource$.MODULE$.ClusterResource());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    public AclBinding acl2() {
        return this.acl2;
    }

    public AclBinding acl3() {
        return this.acl3;
    }

    public AclBinding fooAcl() {
        return this.fooAcl;
    }

    public AclBinding transactionalIdAcl() {
        return this.transactionalIdAcl;
    }

    public AclBinding groupAcl() {
        return this.groupAcl;
    }

    @Override
    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Assert.assertEquals((long)7L, (long)((Collection)this.client().describeAcls(AclBindingFilter.ANY).values().get()).size());
        CreateAclsResult results = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl3()}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl3()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results.values().keySet()).asScala());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results.values().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)value -> (Void)value.get());
        AclBinding aclUnknown = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.UNKNOWN, AclPermissionType.ALLOW));
        CreateAclsResult results2 = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclUnknown}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclUnknown})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results2.values().keySet()).asScala());
        this.assertFutureExceptionTypeEquals(results2.all(), InvalidRequestException.class);
        Map results3 = this.client().deleteAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.ACL1().toFilter(), this.acl2().toFilter(), this.acl3().toFilter()}))).asJava()).values();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.ACL1().toFilter(), this.acl2().toFilter(), this.acl3().toFilter()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results3.keySet()).asScala());
        Assert.assertEquals((long)0L, (long)((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.ACL1().toFilter())).get()).values().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.acl2().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl3()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.acl3().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    public void waitForDescribeAcls(AdminClient client, AclBindingFilter filter, Set<AclBinding> acls) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Collection results = (Collection)client.describeAcls(filter).values().get();
            Set set = acls;
            Set set2 = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results).asScala()).toSet();
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for ACLs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{acls})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAclOperations2() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        CreateAclsResult results = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl2(), this.transactionalIdAcl()}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl2(), this.transactionalIdAcl()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results.values().keySet()).asScala());
        results.all().get();
        this.waitForDescribeAcls(this.client(), this.acl2().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()}))));
        this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        AclBindingFilter filterA = new AclBindingFilter(new ResourceFilter(ResourceType.GROUP, null), AccessControlEntryFilter.ANY);
        AclBindingFilter filterB = new AclBindingFilter(new ResourceFilter(ResourceType.TOPIC, "mytopic2"), AccessControlEntryFilter.ANY);
        AclBindingFilter filterC = new AclBindingFilter(new ResourceFilter(ResourceType.TRANSACTIONAL_ID, null), AccessControlEntryFilter.ANY);
        this.waitForDescribeAcls(this.client(), filterA, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.groupAcl()}))));
        this.waitForDescribeAcls(this.client(), filterC, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        DeleteAclsResult results2 = this.client().deleteAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filterA, filterB, filterC}))).asJava(), new DeleteAclsOptions());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filterA, filterB, filterC})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results2.values().keySet()).asScala());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.groupAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterA)).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterC)).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterB)).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        this.waitForDescribeAcls(this.client(), filterB, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.waitForDescribeAcls(this.client(), filterC, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    @Test
    public void testAttemptToCreateInvalidAcls() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AclBinding clusterAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.CLUSTER, "foobar"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding emptyResourceNameAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, ""), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        CreateAclsResult results = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{clusterAcl, emptyResourceNameAcl}))).asJava(), new CreateAclsOptions());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{clusterAcl, emptyResourceNameAcl})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results.values().keySet()).asScala());
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.values().get(clusterAcl), InvalidRequestException.class);
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.values().get(emptyResourceNameAcl), InvalidRequestException.class);
    }

    private void verifyCauseIsClusterAuth(Throwable e) {
        if (!(e.getCause() instanceof ClusterAuthorizationException)) {
            throw e.getCause();
        }
    }

    private void testAclCreateGetDelete(boolean expectAuth) {
        block1: {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                CreateAclsResult result = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl(), this.transactionalIdAcl()}))).asJava(), new CreateAclsOptions());
                if (expectAuth) {
                    boolean bl2;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Void)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl2 = false;
                    } else if (try_ instanceof Success) {
                        bl2 = true;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl2;
                } else {
                    boolean bl3;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Void)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl3 = true;
                    } else if (try_ instanceof Success) {
                        bl3 = false;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl3;
                }
                return bl;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for createAcls to " + (expectAuth ? "succeed" : "fail"), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            if (expectAuth) {
                this.waitForDescribeAcls(this.client(), this.fooAcl().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()}))));
                this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
            }
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                DeleteAclsResult result = this.client().deleteAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.fooAcl().toFilter(), this.transactionalIdAcl().toFilter()}))).asJava(), new DeleteAclsOptions());
                if (expectAuth) {
                    boolean bl2;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl2 = false;
                    } else if (try_ instanceof Success) {
                        bl2 = true;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl2;
                } else {
                    boolean bl3;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl3 = true;
                    } else if (try_ instanceof Success) {
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl(), this.transactionalIdAcl()})), result.values().keySet());
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get(this.fooAcl().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get(this.transactionalIdAcl().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
                        bl3 = true;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl3;
                }
                return bl;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for deleteAcls to " + (expectAuth ? "succeed" : "fail"), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            if (!expectAuth) break block1;
            this.waitForDescribeAcls(this.client(), this.fooAcl().toFilter(), (Set<AclBinding>)Predef$.MODULE$.Set().empty());
            this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (Set<AclBinding>)Predef$.MODULE$.Set().empty());
        }
    }

    private void testAclGet(boolean expectAuth) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            AclBinding userAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "*"), new AccessControlEntry("User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW));
            DescribeAclsResult results = this.client().describeAcls(userAcl.toFilter());
            if (expectAuth) {
                boolean bl2;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)results.values().get());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.verifyCauseIsClusterAuth(e);
                    bl2 = false;
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Collection acls = (Collection)success.value();
                    bl2 = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{userAcl}))).equals((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(acls).asScala()).toSet());
                } else {
                    throw new MatchError((Object)try_);
                }
                bl = bl2;
            } else {
                boolean bl3;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)results.values().get());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.verifyCauseIsClusterAuth(e);
                    bl3 = true;
                } else if (try_ instanceof Success) {
                    bl3 = false;
                } else {
                    throw new MatchError((Object)try_);
                }
                bl = bl3;
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for describeAcls to " + (expectAuth ? "succeed" : "fail"), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAclAuthorizationDenied() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.addClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Alter$.MODULE$);
        this.testAclGet(true);
        this.testAclCreateGetDelete(false);
        this.addClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Describe$.MODULE$);
        this.testAclGet(false);
        this.testAclCreateGetDelete(false);
        this.removeClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Describe$.MODULE$);
        this.removeClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Alter$.MODULE$);
        this.testAclGet(true);
        this.testAclCreateGetDelete(true);
        this.removeClusterAcl((PermissionType)Allow$.MODULE$, (Operation)Alter$.MODULE$);
        this.removeClusterAcl((PermissionType)Allow$.MODULE$, (Operation)Delete$.MODULE$);
        this.testAclGet(false);
        this.testAclCreateGetDelete(false);
        this.addClusterAcl((PermissionType)Allow$.MODULE$, (Operation)Describe$.MODULE$);
        this.testAclGet(true);
        this.testAclCreateGetDelete(false);
    }

    public SaslSslAdminClientIntegrationTest() {
        SaslSetup.$init$(this);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.acl2 = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "mytopic2"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        this.acl3 = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.fooAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "foobar"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.transactionalIdAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TRANSACTIONAL_ID, "transactional_id"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        this.groupAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.GROUP, "*"), new AccessControlEntry("User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }
}

