/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.omegat.gui.glossary.GlossaryRenderers;
import org.omegat.gui.glossary.IGlossaryRenderer;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.GlossaryPreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DelegatingComboBoxRenderer;

public class GlossaryPreferencesController
extends BasePreferencesController {
    private GlossaryPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_GLOSSARY");
    }

    private void initGui() {
        this.panel = new GlossaryPreferencesPanel();
        this.panel.cbGlossaryLayout.setModel(new DefaultComboBoxModel<IGlossaryRenderer>(GlossaryRenderers.getAll().toArray(new IGlossaryRenderer[0])));
        this.panel.cbGlossaryLayout.setRenderer((ListCellRenderer<IGlossaryRenderer>)new DelegatingComboBoxRenderer<IGlossaryRenderer, String>(){

            @Override
            protected String getDisplayText(IGlossaryRenderer value) {
                return value.getName();
            }
        });
    }

    @Override
    protected void initFromPrefs() {
        this.panel.displayContextCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_tbx_display_context", true));
        this.panel.useSeparateTermsCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_not_exact_match", true));
        this.panel.useStemmingCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_stemming", true));
        this.panel.replaceHitsCheckBox.setSelected(Preferences.isPreference("glossary_replace_on_insert"));
        this.panel.requireSimilarCaseCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_require_similar_case", true));
        this.panel.cbGlossaryLayout.setSelectedItem(GlossaryRenderers.getPreferredGlossaryRenderer());
        this.panel.mergeAlternateDefinitionsCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_merge_alternate_definitions", true));
        this.panel.sortBySrcTextLengthCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_sort_by_src_length", false));
        this.panel.sortByTextLengthCheckBox.setSelected(Preferences.isPreferenceDefault("glossary_sort_by_length", false));
    }

    @Override
    public void restoreDefaults() {
        this.panel.displayContextCheckBox.setSelected(true);
        this.panel.useSeparateTermsCheckBox.setSelected(true);
        this.panel.useStemmingCheckBox.setSelected(true);
        this.panel.replaceHitsCheckBox.setSelected(false);
        this.panel.requireSimilarCaseCheckBox.setSelected(true);
        this.panel.cbGlossaryLayout.setSelectedItem(GlossaryRenderers.DEFAULT_RENDERER);
        this.panel.mergeAlternateDefinitionsCheckBox.setSelected(true);
        this.panel.sortBySrcTextLengthCheckBox.setSelected(false);
        this.panel.sortByTextLengthCheckBox.setSelected(false);
    }

    @Override
    public void persist() {
        Preferences.setPreference("glossary_tbx_display_context", this.panel.displayContextCheckBox.isSelected());
        Preferences.setPreference("glossary_not_exact_match", this.panel.useSeparateTermsCheckBox.isSelected());
        Preferences.setPreference("glossary_stemming", this.panel.useStemmingCheckBox.isSelected());
        Preferences.setPreference("glossary_replace_on_insert", this.panel.replaceHitsCheckBox.isSelected());
        Preferences.setPreference("glossary_require_similar_case", this.panel.requireSimilarCaseCheckBox.isSelected());
        GlossaryRenderers.setPreferredGlossaryRenderer((IGlossaryRenderer)this.panel.cbGlossaryLayout.getSelectedItem());
        Preferences.setPreference("glossary_merge_alternate_definitions", this.panel.mergeAlternateDefinitionsCheckBox.isSelected());
        Preferences.setPreference("glossary_sort_by_length", this.panel.sortByTextLengthCheckBox.isSelected());
        Preferences.setPreference("glossary_sort_by_src_length", this.panel.sortBySrcTextLengthCheckBox.isSelected());
    }
}

