/*
 * Decompiled with CFR 0.152.
 */
package net.pflaeging.PortableSigner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import net.pflaeging.PortableSigner.Main;

public class GetPKCS12 {
    public static PrivateKey privateKey;
    public static Certificate[] certificateChain;
    public static String subject;
    public static BigInteger serial;
    public static Date notBefore;
    public static Date notAfter;
    public static String issuer;
    public static String atEgovOID;
    X509Certificate x509cert;

    public GetPKCS12(String pkcs12FileName, String pkcs12Password) throws KeyStoreException {
        KeyStore ks = null;
        if (pkcs12Password == null) {
            pkcs12Password = "";
        }
        try {
            ks = KeyStore.getInstance("pkcs12");
            ks.load(new FileInputStream(pkcs12FileName), pkcs12Password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificateAlgorythm"), true, e.getLocalizedMessage());
        }
        catch (CertificateException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificate"), true, e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificateNotAccessible"), true, e.getLocalizedMessage());
        }
        catch (IOException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificateIO"), true, e.getLocalizedMessage());
        }
        String alias = "";
        try {
            Enumeration<String> aliases = ks.aliases();
            alias = aliases.nextElement();
            while (aliases.hasMoreElements() && !ks.isKeyEntry(alias)) {
                alias = aliases.nextElement();
            }
            privateKey = (PrivateKey)ks.getKey(alias, pkcs12Password.toCharArray());
        }
        catch (NoSuchElementException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificateNoKey"), true, e.getLocalizedMessage());
        }
        catch (NoSuchAlgorithmException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificateAlgorythm"), true, e.getLocalizedMessage());
        }
        catch (UnrecoverableKeyException e) {
            Main.setResult(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("ErrorReadingCertificateAlgorythm"), true, e.getLocalizedMessage());
        }
        certificateChain = ks.getCertificateChain(alias);
        this.x509cert = (X509Certificate)ks.getCertificate(alias);
        subject = this.x509cert.getSubjectX500Principal().toString();
        serial = this.x509cert.getSerialNumber();
        notBefore = this.x509cert.getNotBefore();
        notAfter = this.x509cert.getNotAfter();
        issuer = this.x509cert.getIssuerX500Principal().toString();
        ResourceBundle oid = ResourceBundle.getBundle("net/pflaeging/PortableSigner/SpecialOID");
        atEgovOID = "";
        Enumeration<String> o = oid.getKeys();
        while (o.hasMoreElements()) {
            String element = o.nextElement();
            Set<String> bCert = this.x509cert.getNonCriticalExtensionOIDs();
            if (bCert == null || !bCert.contains(element)) continue;
            if (!atEgovOID.equals("")) {
                atEgovOID = atEgovOID + ", ";
            }
            atEgovOID = atEgovOID + oid.getString(element) + " (OID=" + element + ")";
        }
    }
}

