/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Status;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.TreeBasedTask;

public class StarTeamCheckin
extends TreeBasedTask {
    private boolean createFolders = true;
    private String comment = null;
    private boolean addUncontrolled = false;
    private int lockStatus = 3;

    public StarTeamCheckin() {
        this.setRecursive(false);
    }

    public void setCreateFolders(boolean argCreateFolders) {
        this.createFolders = argCreateFolders;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isAddUncontrolled() {
        return this.addUncontrolled;
    }

    public void setAddUncontrolled(boolean addUncontrolled) {
        this.addUncontrolled = addUncontrolled;
    }

    public void setUnlocked(boolean v) {
        this.lockStatus = v ? 0 : 3;
    }

    protected View createSnapshotView(View raw) {
        return new View(raw, ViewConfiguration.createTip());
    }

    protected void testPreconditions() throws BuildException {
    }

    protected void logOperationDescription(Folder starteamrootFolder, File targetrootFolder) {
        this.log((this.isRecursive() ? "Recursive" : "Non-recursive") + " Checkin from" + (null == this.getRootLocalFolder() ? " (default): " : ": ") + targetrootFolder.getAbsolutePath());
        this.log("Checking in to: " + starteamrootFolder.getFolderHierarchy());
        this.logIncludes();
        this.logExcludes();
        if (this.lockStatus == 0) {
            this.log("  Items will be checked in unlocked.");
        } else {
            this.log("  Items will be checked in with no change in lock status.");
        }
        if (this.isForced()) {
            this.log("  Items will be checked in in accordance with repository status and regardless of lock status.");
        } else {
            this.log("  Items will be checked in regardless of repository status only if locked.");
        }
    }

    protected void visit(Folder starteamFolder, File targetFolder) throws BuildException {
        try {
            int i;
            if (null != this.getRootLocalFolder()) {
                starteamFolder.setAlternatePathFragment(targetFolder.getAbsolutePath());
            }
            Folder[] foldersList = starteamFolder.getSubFolders();
            Item[] stFiles = starteamFolder.getItems(this.getTypeNames().FILE);
            TreeBasedTask.UnmatchedFileMap ufm = new CheckinMap().init(targetFolder.getAbsoluteFile(), starteamFolder);
            int size = foldersList.length;
            for (i = 0; i < size; ++i) {
                Folder stFolder = foldersList[i];
                File subfolder = new File(targetFolder, stFolder.getName());
                ufm.removeControlledItem(subfolder);
                if (!this.isRecursive()) continue;
                this.visit(stFolder, subfolder);
            }
            size = stFiles.length;
            for (i = 0; i < size; ++i) {
                com.starbase.starteam.File stFile = (com.starbase.starteam.File)stFiles[i];
                this.processFile(stFile);
                ufm.removeControlledItem(new File(targetFolder, stFile.getName()));
            }
            if (this.addUncontrolled) {
                ufm.processUncontrolledItems();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String describeCheckin(com.starbase.starteam.File remotefile) {
        StringBuffer sb = new StringBuffer();
        sb.append(remotefile.getFullName()).append(" --> ").append(TreeBasedTask.getFullRepositoryPath(remotefile));
        return sb.toString();
    }

    private void processFile(com.starbase.starteam.File eachFile) throws IOException {
        String filename = eachFile.getName();
        if (!this.shouldProcess(filename)) {
            this.log("Excluding " + TreeBasedTask.getFullRepositoryPath(eachFile));
            return;
        }
        boolean checkin = true;
        int fileStatus = eachFile.getStatus();
        if (fileStatus == 1 || fileStatus == 6) {
            eachFile.updateStatus(true, true);
            fileStatus = eachFile.getStatus();
        }
        if (fileStatus == 3) {
            this.log("Checking in: " + this.describeCheckin(eachFile));
        } else if (fileStatus == 2) {
            this.log("Local file missing: " + this.describeCheckin(eachFile));
            checkin = false;
        } else if (this.isForced()) {
            this.log("Forced checkin of " + this.describeCheckin(eachFile) + " over status " + Status.name((int)fileStatus));
        } else {
            this.log("Skipping: " + TreeBasedTask.getFullRepositoryPath(eachFile) + " - status: " + Status.name((int)fileStatus));
            checkin = false;
        }
        if (checkin) {
            eachFile.checkin(this.comment, this.lockStatus, this.isForced(), true, true);
        }
    }

    private class CheckinMap
    extends TreeBasedTask.UnmatchedFileMap {
        private CheckinMap() {
            super(StarTeamCheckin.this);
        }

        protected boolean isActive() {
            return StarTeamCheckin.this.addUncontrolled;
        }

        void processUncontrolledItems() throws BuildException {
            if (this.isActive()) {
                Enumeration e = this.keys();
                while (e.hasMoreElements()) {
                    File local = (File)e.nextElement();
                    Item remoteItem = (Item)this.get(local);
                    remoteItem.update();
                    if (local.isDirectory()) {
                        Folder folder = (Folder)remoteItem;
                        StarTeamCheckin.this.log("Added uncontrolled folder " + folder.getFolderHierarchy() + " from " + local.getAbsoluteFile());
                        if (!StarTeamCheckin.this.isRecursive()) continue;
                        TreeBasedTask.UnmatchedFileMap submap = new CheckinMap().init(local, folder);
                        submap.processUncontrolledItems();
                        continue;
                    }
                    com.starbase.starteam.File remoteFile = (com.starbase.starteam.File)remoteItem;
                    StarTeamCheckin.this.log("Added uncontrolled file " + TreeBasedTask.getFullRepositoryPath(remoteFile) + " from " + local.getAbsoluteFile());
                }
            }
        }
    }
}

