/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionInverted;
import org.apache.cassandra.stress.generate.Seed;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.DynamicList;

public class SeedManager {
    final Distribution visits;
    final Generator writes;
    final Generator reads;
    final ConcurrentHashMap<Long, Seed> managing = new ConcurrentHashMap();
    final DynamicList<Seed> sampleFrom;
    final Distribution sample;
    final long sampleOffset;
    final int sampleSize;
    final boolean updateSampleImmediately;

    public SeedManager(StressSettings settings) {
        Generator reads;
        Generator writes;
        if (settings.generate.sequence != null) {
            long[] seq = settings.generate.sequence;
            if (settings.generate.readlookback != null) {
                LookbackableWriteGenerator series = new LookbackableWriteGenerator(seq[0], seq[1], settings.generate.wrap, settings.generate.readlookback.get());
                writes = series;
                reads = series.reads;
            } else {
                writes = reads = new SeriesGenerator(seq[0], seq[1], settings.generate.wrap);
            }
        } else {
            writes = reads = new RandomGenerator(settings.generate.distribution.get());
        }
        this.visits = settings.insert.visits.get();
        this.writes = writes;
        this.reads = reads;
        Distribution sample = settings.insert.revisit.get();
        this.sampleOffset = Math.min(sample.minValue(), sample.maxValue());
        long sampleSize = 1L + Math.max(sample.minValue(), sample.maxValue()) - this.sampleOffset;
        if (this.sampleOffset < 0L || sampleSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("sample range is invalid");
        }
        this.sampleFrom = new DynamicList((int)sampleSize);
        this.sample = DistributionInverted.invert(sample);
        this.sampleSize = (int)sampleSize;
        this.updateSampleImmediately = this.visits.average() > 1L;
    }

    public Seed next(Operation op) {
        if (!op.isWrite()) {
            Seed seed = this.reads.next(-1);
            if (seed == null) {
                return null;
            }
            Seed managing = this.managing.get(seed);
            return managing == null ? seed : managing;
        }
        int index;
        Seed seed;
        while ((seed = this.sampleFrom.get(index = (int)(this.sample.next() - this.sampleOffset))) == null || !seed.isSaved()) {
            seed = this.writes.next((int)this.visits.next());
            if (seed == null) {
                return null;
            }
            if (this.managing.putIfAbsent(seed.seed, seed) != null) continue;
            if (!this.updateSampleImmediately || seed.save(this.sampleFrom, this.sampleSize)) {
                return seed;
            }
            this.managing.remove(seed.seed, seed);
        }
        return seed;
    }

    public void markLastWrite(Seed seed, boolean first) {
        if (this.managing.remove(seed.seed, seed) && !first) {
            seed.remove(this.sampleFrom);
        }
    }

    public void markFirstWrite(Seed seed, boolean last) {
        if (!last && !this.updateSampleImmediately) {
            seed.save(this.sampleFrom, Integer.MAX_VALUE);
        }
        this.writes.finishWrite(seed);
    }

    private class LookbackableWriteGenerator
    extends SeriesGenerator {
        final AtomicLong writeCount;
        final ConcurrentSkipListMap<Seed, Seed> afterMin;
        final LookbackReadGenerator reads;

        public LookbackableWriteGenerator(long start, long end, boolean wrap, Distribution readLookback) {
            super(start, end, wrap);
            this.writeCount = new AtomicLong();
            this.afterMin = new ConcurrentSkipListMap();
            this.writeCount.set(0L);
            this.reads = new LookbackReadGenerator(readLookback);
        }

        @Override
        public Seed next(int visits) {
            long next = this.next.getAndIncrement();
            if (!this.wrap && next >= this.totalCount) {
                return null;
            }
            return new Seed(this.start + next % this.totalCount, visits);
        }

        @Override
        void finishWrite(Seed seed) {
            if (seed.seed <= this.writeCount.get()) {
                return;
            }
            this.afterMin.put(seed, seed);
            while (true) {
                Map.Entry<Seed, Seed> head;
                if ((head = this.afterMin.firstEntry()) == null) {
                    return;
                }
                long min = this.writeCount.get();
                if (head.getKey().seed <= min) {
                    return;
                }
                if (head.getKey().seed != min + 1L || !this.writeCount.compareAndSet(min, min + 1L)) break;
                this.afterMin.remove(head.getKey());
            }
        }

        private class LookbackReadGenerator
        extends Generator {
            final Distribution lookback;

            public LookbackReadGenerator(Distribution lookback) {
                this.lookback = lookback;
                if (lookback.maxValue() > LookbackableWriteGenerator.this.start + LookbackableWriteGenerator.this.totalCount) {
                    throw new IllegalArgumentException("Invalid lookback distribution; max value is " + lookback.maxValue() + ", but series only ranges from " + LookbackableWriteGenerator.this.writeCount + " to " + (LookbackableWriteGenerator.this.start + LookbackableWriteGenerator.this.totalCount));
                }
            }

            @Override
            public Seed next(int visits) {
                long lookback = this.lookback.next();
                long range = LookbackableWriteGenerator.this.writeCount.get();
                long startOffset = range - lookback;
                if (startOffset < 0L) {
                    if (range == LookbackableWriteGenerator.this.totalCount && !LookbackableWriteGenerator.this.wrap) {
                        return null;
                    }
                    startOffset = range == 0L ? 0L : lookback % range;
                }
                return new Seed(LookbackableWriteGenerator.this.start + startOffset, visits);
            }
        }
    }

    private class SeriesGenerator
    extends Generator {
        final long start;
        final long totalCount;
        final boolean wrap;
        final AtomicLong next;

        public SeriesGenerator(long start, long end, boolean wrap) {
            this.next = new AtomicLong();
            this.wrap = wrap;
            if (start > end) {
                throw new IllegalStateException();
            }
            this.start = start;
            this.totalCount = 1L + end - start;
        }

        @Override
        public Seed next(int visits) {
            long next = this.next.getAndIncrement();
            if (!this.wrap && next >= this.totalCount) {
                return null;
            }
            return new Seed(this.start + next % this.totalCount, visits);
        }
    }

    private class RandomGenerator
    extends Generator {
        final Distribution distribution;

        public RandomGenerator(Distribution distribution) {
            this.distribution = distribution;
        }

        @Override
        public Seed next(int visits) {
            return new Seed(this.distribution.next(), visits);
        }
    }

    private abstract class Generator {
        private Generator() {
        }

        abstract Seed next(int var1);

        void finishWrite(Seed seed) {
        }
    }
}

