/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

abstract class LocalAsyncLoadingCache<C extends LocalCache<K, CompletableFuture<V>>, K, V>
implements AsyncLoadingCache<K, V> {
    static final Logger logger = Logger.getLogger(LocalAsyncLoadingCache.class.getName());
    final C cache;
    final boolean canBulkLoad;
    final AsyncCacheLoader<K, V> loader;
    LoadingCacheView localCacheView;

    LocalAsyncLoadingCache(C cache, AsyncCacheLoader<? super K, V> loader) {
        this.loader = loader;
        this.canBulkLoad = LocalAsyncLoadingCache.canBulkLoad(loader);
        this.cache = cache;
    }

    protected abstract Policy<K, V> policy();

    private static boolean canBulkLoad(AsyncCacheLoader<?, ?> loader) {
        try {
            Class<AsyncCacheLoader> defaultLoaderClass = AsyncCacheLoader.class;
            if (loader instanceof CacheLoader) {
                Method defaultLoadAll;
                defaultLoaderClass = CacheLoader.class;
                Method classLoadAll = loader.getClass().getMethod("loadAll", Iterable.class);
                if (!classLoadAll.equals(defaultLoadAll = CacheLoader.class.getMethod("loadAll", Iterable.class))) {
                    return true;
                }
            }
            Method classAsyncLoadAll = loader.getClass().getMethod("asyncLoadAll", Iterable.class, Executor.class);
            Method defaultAsyncLoadAll = defaultLoaderClass.getMethod("asyncLoadAll", Iterable.class, Executor.class);
            return !classAsyncLoadAll.equals(defaultAsyncLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e);
            return false;
        }
    }

    @Override
    public CompletableFuture<V> getIfPresent(@Nonnull Object key) {
        return (CompletableFuture)this.cache.getIfPresent(key, true);
    }

    @Override
    public CompletableFuture<V> get(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.get(key, (? super K k1, Executor executor) -> CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), executor));
    }

    @Override
    public CompletableFuture<V> get(K key, BiFunction<? super K, Executor, CompletableFuture<V>> mappingFunction) {
        long startTime = this.cache.statsTicker().read();
        CompletableFuture[] result = new CompletableFuture[1];
        CompletableFuture future = this.cache.computeIfAbsent(key, k -> {
            result[0] = (CompletableFuture)mappingFunction.apply((K)key, this.cache.executor());
            if (result[0] == null) {
                this.cache.statsCounter().recordLoadFailure(this.cache.statsTicker().read() - startTime);
            }
            return result[0];
        }, true);
        if (result[0] != null) {
            AtomicBoolean completed = new AtomicBoolean();
            result[0].whenComplete((value, error) -> {
                if (!completed.compareAndSet(false, true)) {
                    return;
                }
                long loadTime = this.cache.statsTicker().read() - startTime;
                if (value == null) {
                    this.cache.statsCounter().recordLoadFailure(loadTime);
                    this.cache.remove(key, result[0]);
                } else {
                    this.cache.replace(key, (CompletableFuture)result[0], (CompletableFuture)result[0]);
                    this.cache.statsCounter().recordLoadSuccess(loadTime);
                }
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<V> get(K key) {
        CompletableFuture<V> future = this.get(key, this.loader::asyncLoad);
        return Objects.requireNonNull(future);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAll(Iterable<? extends K> keys) {
        if (this.canBulkLoad) {
            return this.getAllBulk(keys);
        }
        HashMap<K, CompletableFuture<V>> result = new HashMap<K, CompletableFuture<V>>();
        for (K key : keys) {
            result.put(key, this.get(key));
        }
        return this.composeResult(result);
    }

    private CompletableFuture<Map<K, V>> getAllBulk(Iterable<? extends K> keys) {
        HashMap futures = new HashMap();
        HashMap proxies = new HashMap();
        for (K key : keys) {
            CompletableFuture proxy;
            CompletableFuture future = (CompletableFuture)this.cache.getIfPresent(key, false);
            if (future == null && (future = this.cache.putIfAbsent(key, proxy = new CompletableFuture())) == null) {
                future = proxy;
                proxies.put(key, proxy);
            }
            futures.put(key, future);
        }
        this.cache.statsCounter().recordMisses(proxies.size());
        this.cache.statsCounter().recordHits(futures.size() - proxies.size());
        if (proxies.isEmpty()) {
            return this.composeResult(futures);
        }
        this.loader.asyncLoadAll(proxies.keySet(), this.cache.executor()).whenComplete((BiConsumer)new AsyncBulkCompleter(proxies));
        return this.composeResult(futures);
    }

    private CompletableFuture<Map<K, V>> composeResult(Map<K, CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        CompletableFuture[] array = futures.values().toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(array).thenApply(ignored -> {
            HashMap result = new HashMap(futures.size());
            futures.forEach((key, future) -> {
                Object value = future.getNow(null);
                if (value != null) {
                    result.put(key, value);
                }
            });
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    public void put(K key, CompletableFuture<V> valueFuture) {
        if (valueFuture.isCompletedExceptionally() || valueFuture.isDone() && valueFuture.join() == null) {
            this.cache.statsCounter().recordLoadFailure(0L);
            this.cache.remove(key);
            return;
        }
        AtomicBoolean completed = new AtomicBoolean();
        long startTime = this.cache.statsTicker().read();
        this.cache.put(key, valueFuture);
        valueFuture.whenComplete((value, error) -> {
            if (!completed.compareAndSet(false, true)) {
                return;
            }
            long loadTime = this.cache.statsTicker().read() - startTime;
            if (value == null) {
                this.cache.remove(key, valueFuture);
                this.cache.statsCounter().recordLoadFailure(loadTime);
            } else {
                this.cache.replace(key, (CompletableFuture)valueFuture, (CompletableFuture)valueFuture);
                this.cache.statsCounter().recordLoadSuccess(loadTime);
            }
        });
    }

    @Override
    public LoadingCache<K, V> synchronous() {
        return this.localCacheView == null ? (this.localCacheView = new LoadingCacheView()) : this.localCacheView;
    }

    static final class AsMapView<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V> {
        final LocalCache<K, CompletableFuture<V>> delegate;
        Collection<V> values;
        Set<Map.Entry<K, V>> entries;

        AsMapView(LocalCache<K, CompletableFuture<V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            Objects.requireNonNull(value);
            for (CompletableFuture valueFuture : this.delegate.values()) {
                if (!value.equals(Async.getIfReady(valueFuture))) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object key) {
            return Async.getIfReady((CompletableFuture)this.delegate.get(key));
        }

        @Override
        public V putIfAbsent(K key, V value) {
            Objects.requireNonNull(value);
            CompletableFuture<V> valueFuture = this.delegate.putIfAbsent(key, CompletableFuture.completedFuture(value));
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        public V put(K key, V value) {
            Objects.requireNonNull(value);
            CompletableFuture<V> oldValueFuture = this.delegate.put(key, CompletableFuture.completedFuture(value));
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public V remove(Object key) {
            CompletableFuture oldValueFuture = (CompletableFuture)this.delegate.remove(key);
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public V replace(K key, V value) {
            Objects.requireNonNull(value);
            CompletableFuture<V> oldValueFuture = this.delegate.replace(key, CompletableFuture.completedFuture(value));
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Objects.requireNonNull(oldValue);
            Objects.requireNonNull(newValue);
            CompletableFuture oldValueFuture = (CompletableFuture)this.delegate.get(key);
            return oldValue.equals(Async.getIfReady(oldValueFuture)) && this.delegate.replace(key, oldValueFuture, CompletableFuture.completedFuture(newValue));
        }

        @Override
        public boolean remove(Object key, Object value) {
            Objects.requireNonNull(key);
            if (value == null) {
                return false;
            }
            CompletableFuture oldValueFuture = (CompletableFuture)this.delegate.get(key);
            return value.equals(Async.getIfReady(oldValueFuture)) && this.delegate.remove(key, oldValueFuture);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            CompletableFuture valueFuture = this.delegate.computeIfAbsent(key, k -> {
                Object newValue = mappingFunction.apply((Object)key);
                return newValue == null ? null : CompletableFuture.completedFuture(newValue);
            });
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Objects.requireNonNull(remappingFunction);
            CompletableFuture valueFuture = this.delegate.computeIfPresent(key, (k, oldValueFuture) -> {
                Object oldValue = Async.getWhenSuccessful(oldValueFuture);
                if (oldValue == null) {
                    return null;
                }
                Object newValue = remappingFunction.apply((Object)key, (Object)oldValue);
                return newValue == null ? null : CompletableFuture.completedFuture(newValue);
            });
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Objects.requireNonNull(remappingFunction);
            long startTime = this.delegate.statsTicker().read();
            CompletableFuture valueFuture = this.delegate.compute(key, (k, oldValueFuture) -> {
                Object oldValue = Async.getWhenSuccessful(oldValueFuture);
                Object newValue = remappingFunction.apply((K)key, (V)oldValue);
                long loadTime = this.delegate.statsTicker().read() - startTime;
                if (newValue == null) {
                    this.delegate.statsCounter().recordLoadFailure(loadTime);
                    return null;
                }
                this.delegate.statsCounter().recordLoadSuccess(loadTime);
                return CompletableFuture.completedFuture(newValue);
            }, false, true);
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Objects.requireNonNull(value);
            Objects.requireNonNull(remappingFunction);
            CompletableFuture mergedValueFuture = this.delegate.merge(key, CompletableFuture.completedFuture(value), (oldValueFuture, valueFuture) -> {
                Object oldValue = Async.getWhenSuccessful(oldValueFuture);
                if (oldValue == null) {
                    return valueFuture;
                }
                Object newValue = remappingFunction.apply((Object)oldValue, (Object)value);
                return newValue == null ? null : CompletableFuture.completedFuture(newValue);
            });
            return Async.getWhenSuccessful(mergedValueFuture);
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.values == null ? (this.values = new Values()) : this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entries == null ? (this.entries = new EntrySet()) : this.entries;
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object value = AsMapView.this.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }

            @Override
            public boolean remove(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                return AsMapView.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, CompletableFuture<V>>> iterator;
                    Map.Entry<K, V> cursor;
                    K removalKey;
                    {
                        this.iterator = AsMapView.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.cursor == null && this.iterator.hasNext()) {
                            Map.Entry entry = this.iterator.next();
                            Object value = Async.getIfReady(entry.getValue());
                            if (value == null) continue;
                            this.cursor = new WriteThroughEntry(AsMapView.this, entry.getKey(), value);
                        }
                        return this.cursor != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.removalKey = this.cursor.getKey();
                        Map.Entry entry = this.cursor;
                        this.cursor = null;
                        return entry;
                    }

                    @Override
                    public void remove() {
                        Caffeine.requireState(this.removalKey != null);
                        AsMapView.this.delegate.remove(this.removalKey);
                        this.removalKey = null;
                    }
                };
            }
        }

        private final class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return AsMapView.this.containsValue(o);
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = AsMapView.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iterator.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }
        }
    }

    final class LoadingCacheView
    implements LoadingCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        transient AsMapView<K, V> asMapView;

        LoadingCacheView() {
        }

        LocalAsyncLoadingCache<C, K, V> getOuter() {
            return LocalAsyncLoadingCache.this;
        }

        @Override
        public V getIfPresent(Object key) {
            CompletableFuture future = (CompletableFuture)LocalAsyncLoadingCache.this.cache.getIfPresent(key, true);
            return Async.getIfReady(future);
        }

        @Override
        public Map<K, V> getAllPresent(Iterable<?> keys) {
            int hits = 0;
            int misses = 0;
            LinkedHashMap result = new LinkedHashMap();
            for (Object key : keys) {
                CompletableFuture future = (CompletableFuture)LocalAsyncLoadingCache.this.cache.get(key);
                Object value = Async.getIfReady(future);
                if (value == null) {
                    ++misses;
                    continue;
                }
                ++hits;
                Object castKey = key;
                result.put(castKey, value);
            }
            LocalAsyncLoadingCache.this.cache.statsCounter().recordHits(hits);
            LocalAsyncLoadingCache.this.cache.statsCounter().recordMisses(misses);
            return Collections.unmodifiableMap(result);
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            CompletableFuture future = LocalAsyncLoadingCache.this.get(key, (? super K k, Executor executor) -> CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), executor));
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public V get(K key) {
            try {
                return LocalAsyncLoadingCache.this.get(key).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public Map<K, V> getAll(Iterable<? extends K> keys) {
            try {
                return LocalAsyncLoadingCache.this.getAll(keys).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public void put(K key, V value) {
            Objects.requireNonNull(value);
            LocalAsyncLoadingCache.this.cache.put(key, CompletableFuture.completedFuture(value));
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            map.forEach(this::put);
        }

        @Override
        public void invalidate(Object key) {
            LocalAsyncLoadingCache.this.cache.remove(key);
        }

        @Override
        public void invalidateAll(Iterable<?> keys) {
            LocalAsyncLoadingCache.this.cache.invalidateAll(keys);
        }

        @Override
        public void invalidateAll() {
            LocalAsyncLoadingCache.this.cache.clear();
        }

        @Override
        public long estimatedSize() {
            return LocalAsyncLoadingCache.this.cache.size();
        }

        @Override
        public CacheStats stats() {
            return LocalAsyncLoadingCache.this.cache.statsCounter().snapshot();
        }

        @Override
        public void cleanUp() {
            LocalAsyncLoadingCache.this.cache.cleanUp();
        }

        @Override
        public void refresh(K key) {
            Objects.requireNonNull(key);
            BiFunction<Object, CompletableFuture, CompletableFuture> refreshFunction = (k, oldValueFuture) -> {
                try {
                    Object oldValue = Async.getWhenSuccessful(oldValueFuture);
                    if (LocalAsyncLoadingCache.this.loader instanceof CacheLoader) {
                        CacheLoader cacheLoader = (CacheLoader)LocalAsyncLoadingCache.this.loader;
                        Object newValue = oldValue == null ? cacheLoader.load(key) : cacheLoader.reload(key, oldValue);
                        return newValue == null ? null : CompletableFuture.completedFuture(newValue);
                    }
                    CompletableFuture newValueFuture = oldValue == null ? LocalAsyncLoadingCache.this.loader.asyncLoad(key, Runnable::run) : LocalAsyncLoadingCache.this.loader.asyncReload(key, oldValue, Runnable::run);
                    Object newValue = newValueFuture.get();
                    return newValue == null ? null : newValueFuture;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return (CompletableFuture)LocalCache.throwUnchecked(e);
                }
                catch (ExecutionException e) {
                    return (CompletableFuture)LocalCache.throwUnchecked(e.getCause());
                }
                catch (Exception e) {
                    return (CompletableFuture)LocalCache.throwUnchecked(e);
                }
            };
            LocalAsyncLoadingCache.this.cache.executor().execute(() -> {
                try {
                    LocalAsyncLoadingCache.this.cache.compute(key, refreshFunction, false, false);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Exception thrown during refresh", t);
                }
            });
        }

        @Override
        public Policy<K, V> policy() {
            return this.getOuter().policy();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            if (this.asMapView == null) {
                this.asMapView = new AsMapView(LocalAsyncLoadingCache.this.cache);
            }
            return this.asMapView;
        }
    }

    private final class AsyncBulkCompleter
    implements BiConsumer<Map<K, V>, Throwable> {
        private final Map<K, CompletableFuture<V>> proxies;
        private final long startTime;

        AsyncBulkCompleter(Map<K, CompletableFuture<V>> proxies) {
            this.startTime = LocalAsyncLoadingCache.this.cache.statsTicker().read();
            this.proxies = proxies;
        }

        @Override
        public void accept(Map<K, V> result, Throwable error) {
            long loadTime = LocalAsyncLoadingCache.this.cache.statsTicker().read() - this.startTime;
            if (result == null) {
                if (error == null) {
                    error = new CompletionException("null map", null);
                }
                for (Map.Entry entry : this.proxies.entrySet()) {
                    LocalAsyncLoadingCache.this.cache.remove(entry.getKey(), entry.getValue());
                    entry.getValue().obtrudeException(error);
                }
                LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadFailure(loadTime);
            } else {
                this.fillProxies(result);
                this.addNewEntries(result);
                LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadSuccess(result.size());
            }
        }

        private void fillProxies(Map<K, V> result) {
            this.proxies.forEach((key, future) -> {
                Object value = result.get(key);
                future.obtrudeValue(value);
                if (value == null) {
                    LocalAsyncLoadingCache.this.cache.remove(key, future);
                } else {
                    LocalAsyncLoadingCache.this.cache.replace((Object)key, (CompletableFuture)future, (CompletableFuture)future);
                }
            });
        }

        private void addNewEntries(Map<K, V> result) {
            if (this.proxies.size() == result.size()) {
                return;
            }
            result.forEach((key, value) -> {
                if (!this.proxies.containsKey(key)) {
                    LocalAsyncLoadingCache.this.cache.put((Object)key, CompletableFuture.completedFuture(value));
                }
            });
        }
    }
}

