/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.stress.util.ResultLogger;

public class MultiResultLogger
implements ResultLogger {
    private final List<PrintStream> streams = new ArrayList<PrintStream>();

    public MultiResultLogger(PrintStream printStream) {
        this.streams.add(printStream);
    }

    @Override
    public void println(String line) {
        for (PrintStream stream : this.streams) {
            stream.println(line);
        }
    }

    @Override
    public void println() {
        for (PrintStream stream : this.streams) {
            stream.println();
        }
    }

    @Override
    public void printException(Exception e) {
        for (PrintStream stream : this.streams) {
            e.printStackTrace(stream);
        }
    }

    @Override
    public void flush() {
        for (PrintStream stream : this.streams) {
            stream.flush();
        }
    }

    @Override
    public void printf(String s, Object ... args) {
        for (PrintStream stream : this.streams) {
            stream.printf(s, args);
        }
    }

    public void addStream(PrintStream additionalPrintStream) {
        this.streams.add(additionalPrintStream);
    }
}

