/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.rangecoder;

import java.io.IOException;
import org.tukaani.xz.rangecoder.RangeCoder;

public abstract class RangeEncoder
extends RangeCoder {
    private static final int MOVE_REDUCING_BITS = 4;
    private static final int BIT_PRICE_SHIFT_BITS = 4;
    private static final int[] prices = new int[128];
    private long low;
    private int range;
    long cacheSize;
    private byte cache;

    public void reset() {
        this.low = 0L;
        this.range = -1;
        this.cache = 0;
        this.cacheSize = 1L;
    }

    public int getPendingSize() {
        throw new Error();
    }

    public int finish() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.shiftLow();
        }
        return -1;
    }

    abstract void writeByte(int var1) throws IOException;

    private void shiftLow() throws IOException {
        int n = (int)(this.low >>> 32);
        if (n != 0 || this.low < 0xFF000000L) {
            int n2 = this.cache;
            do {
                this.writeByte(n2 + n);
                n2 = 255;
            } while (--this.cacheSize != 0L);
            this.cache = (byte)(this.low >>> 24);
        }
        ++this.cacheSize;
        this.low = (this.low & 0xFFFFFFL) << 8;
    }

    public void encodeBit(short[] sArray, int n, int n2) throws IOException {
        short s = sArray[n];
        int n3 = (this.range >>> 11) * s;
        if (n2 == 0) {
            this.range = n3;
            sArray[n] = (short)(s + (2048 - s >>> 5));
        } else {
            this.low += (long)n3 & 0xFFFFFFFFL;
            this.range -= n3;
            sArray[n] = (short)(s - (s >>> 5));
        }
        if ((this.range & 0xFF000000) == 0) {
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public static int getBitPrice(int n, int n2) {
        assert (n2 == 0 || n2 == 1);
        return prices[(n ^ -n2 & 0x7FF) >>> 4];
    }

    public void encodeBitTree(short[] sArray, int n) throws IOException {
        int n2 = 1;
        int n3 = sArray.length;
        do {
            int n4 = n & (n3 >>>= 1);
            this.encodeBit(sArray, n2, n4);
            n2 <<= 1;
            if (n4 == 0) continue;
            n2 |= 1;
        } while (n3 != 1);
    }

    public static int getBitTreePrice(short[] sArray, int n) {
        int n2 = 0;
        n |= sArray.length;
        do {
            int n3 = n & 1;
            n2 += RangeEncoder.getBitPrice(sArray[n >>>= 1], n3);
        } while (n != 1);
        return n2;
    }

    public void encodeReverseBitTree(short[] sArray, int n) throws IOException {
        int n2 = 1;
        n |= sArray.length;
        do {
            int n3 = n & 1;
            this.encodeBit(sArray, n2, n3);
            n2 = n2 << 1 | n3;
        } while ((n >>>= 1) != 1);
    }

    public static int getReverseBitTreePrice(short[] sArray, int n) {
        int n2 = 0;
        int n3 = 1;
        n |= sArray.length;
        do {
            int n4 = n & 1;
            n2 += RangeEncoder.getBitPrice(sArray[n3], n4);
            n3 = n3 << 1 | n4;
        } while ((n >>>= 1) != 1);
        return n2;
    }

    public void encodeDirectBits(int n, int n2) throws IOException {
        do {
            this.range >>>= 1;
            this.low += (long)(this.range & 0 - (n >>> --n2 & 1));
            if ((this.range & 0xFF000000) != 0) continue;
            this.range <<= 8;
            this.shiftLow();
        } while (n2 != 0);
    }

    public static int getDirectBitsPrice(int n) {
        return n << 4;
    }

    static {
        for (int i = 8; i < 2048; i += 16) {
            int n = i;
            int n2 = 0;
            for (int j = 0; j < 4; ++j) {
                n *= n;
                n2 <<= 1;
                while ((n & 0xFFFF0000) != 0) {
                    n >>>= 1;
                    ++n2;
                }
            }
            RangeEncoder.prices[i >> 4] = 161 - n2;
        }
    }
}

