/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.sql.SolrAggregate;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrFilter
extends Filter
implements SolrRel {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern CALCITE_TIMESTAMP_REGEX = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$");
    private final RexBuilder builder;

    SolrFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == SolrRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
        this.builder = child.getCluster().getRexBuilder();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public SolrFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new SolrFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (this.getInput() instanceof SolrAggregate) {
            HavingTranslator translator = new HavingTranslator(SolrRules.solrFieldNames(this.getRowType()), implementor.reverseAggMappings, this.builder);
            String havingPredicate = translator.translateMatch(this.condition);
            implementor.setHavingPredicate(havingPredicate);
        } else {
            Translator translator = new Translator(SolrRules.solrFieldNames(this.getRowType()), this.builder);
            String query = translator.translateMatch(this.condition);
            implementor.addQuery(query);
            implementor.setNegativeQuery(query.startsWith("-"));
        }
    }

    private static class HavingTranslator
    extends Translator {
        private final Map<String, String> reverseAggMappings;

        HavingTranslator(List<String> fieldNames, Map<String, String> reverseAggMappings, RexBuilder builder) {
            super(fieldNames, builder);
            this.reverseAggMappings = reverseAggMappings;
        }

        @Override
        protected String translateMatch(RexNode condition) {
            if (condition.getKind().belongsTo((Collection)SqlKind.COMPARISON)) {
                return this.translateComparison(condition);
            }
            if (condition.isA(SqlKind.AND)) {
                return this.translateAnd(condition);
            }
            if (condition.isA(SqlKind.OR)) {
                return this.translateOr(condition);
            }
            return null;
        }

        @Override
        protected String translateOr(RexNode condition) {
            ArrayList<String> ors = new ArrayList<String>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                ors.add(this.translateMatch(node));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("or(");
            for (int i = 0; i < ors.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)ors.get(i));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String translateAnd(RexNode node0) {
            ArrayList<String> andStrings = new ArrayList<String>();
            ArrayList<String> notStrings = new ArrayList<String>();
            ArrayList ands = new ArrayList();
            ArrayList nots = new ArrayList();
            RelOptUtil.decomposeConjunction((RexNode)node0, ands, nots);
            for (RexNode node : ands) {
                andStrings.add(this.translateMatch(node));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("and(");
            for (int i = 0; i < andStrings.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)andStrings.get(i));
            }
            builder.append(")");
            if (!nots.isEmpty()) {
                for (RexNode node : nots) {
                    notStrings.add(this.translateMatch(node));
                }
                StringBuilder notBuilder = new StringBuilder();
                for (int i = 0; i < notStrings.size(); ++i) {
                    if (i > 0) {
                        notBuilder.append(",");
                    }
                    notBuilder.append("not(");
                    notBuilder.append((String)notStrings.get(i));
                    notBuilder.append(")");
                }
                return "and(" + builder.toString() + "," + notBuilder.toString() + ")";
            }
            return builder.toString();
        }

        @Override
        protected Pair<String, RexLiteral> translateBinary(RexCall call) {
            Pair<String, RexLiteral> b;
            RexNode right;
            List operands = call.getOperands();
            if (operands.size() != 2) {
                throw new AssertionError((Object)("Invalid number of arguments - " + operands.size()));
            }
            RexNode left = (RexNode)operands.get(0);
            Pair<String, RexLiteral> a = this.translateBinary2(left, right = (RexNode)operands.get(1));
            if (a != null) {
                if (this.reverseAggMappings.containsKey(a.getKey())) {
                    return new Pair((Object)this.reverseAggMappings.get(a.getKey()), a.getValue());
                }
                return a;
            }
            if ((call.op.kind == SqlKind.EQUALS || call.op.kind == SqlKind.NOT_EQUALS) && (b = this.translateBinary2(right, left)) != null) {
                return b;
            }
            throw new AssertionError((Object)("cannot translate call " + call));
        }

        @Override
        protected String translateComparison(RexNode node) {
            Pair<String, RexLiteral> binaryTranslated = this.getFieldValuePair(node);
            switch (node.getKind()) {
                case EQUALS: {
                    String terms = ((RexLiteral)binaryTranslated.getValue()).getValue2().toString().trim();
                    return "eq(" + (String)binaryTranslated.getKey() + "," + terms + ")";
                }
                case NOT_EQUALS: {
                    return "not(eq(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + "))";
                }
                case LESS_THAN: {
                    return "lt(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
                case LESS_THAN_OR_EQUAL: {
                    return "lteq(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
                case GREATER_THAN: {
                    return "gt(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
                case GREATER_THAN_OR_EQUAL: {
                    return "gteq(" + (String)binaryTranslated.getKey() + "," + binaryTranslated.getValue() + ")";
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }
    }

    private static class Translator {
        protected final List<String> fieldNames;
        private final RexBuilder builder;

        Translator(List<String> fieldNames, RexBuilder builder) {
            this.fieldNames = fieldNames;
            this.builder = builder;
        }

        protected String translateMatch(RexNode condition) {
            if (log.isDebugEnabled()) {
                log.debug("translateMatch condition={} {}", (Object)condition.getKind(), (Object)condition.getClass().getName());
            }
            SqlKind kind = condition.getKind();
            if (condition.isA(SqlKind.SEARCH)) {
                return this.translateSearch(condition);
            }
            if (kind.belongsTo((Collection)SqlKind.COMPARISON) || kind == SqlKind.NOT) {
                return this.translateComparison(condition);
            }
            if (condition.isA(SqlKind.AND)) {
                return this.translateAndOrBetween(condition);
            }
            if (condition.isA(SqlKind.OR)) {
                return "(" + this.translateOr(condition) + ")";
            }
            if (kind == SqlKind.LIKE) {
                return this.translateLike(condition);
            }
            if (kind == SqlKind.IS_NOT_NULL || kind == SqlKind.IS_NULL) {
                return this.translateIsNullOrIsNotNull(condition);
            }
            return null;
        }

        protected String translateAndOrBetween(RexNode condition) {
            RexCall call = (RexCall)condition;
            List operands = call.getOperands();
            String query = null;
            if (operands.size() == 2) {
                RexNode lhs = (RexNode)operands.get(0);
                RexNode rhs = (RexNode)operands.get(1);
                if (lhs.getKind() == SqlKind.GREATER_THAN_OR_EQUAL && rhs.getKind() == SqlKind.LESS_THAN_OR_EQUAL) {
                    query = this.translateBetween(lhs, rhs);
                } else if (lhs.getKind() == SqlKind.LESS_THAN_OR_EQUAL && rhs.getKind() == SqlKind.GREATER_THAN_OR_EQUAL) {
                    query = this.translateBetween(rhs, lhs);
                }
            }
            String string = query = query != null ? query : this.translateAnd(condition);
            if (log.isDebugEnabled()) {
                log.debug("translated query match={}", (Object)query);
            }
            return "(" + query + ")";
        }

        protected String translateBetween(RexNode gteNode, RexNode lteNode) {
            Pair<String, RexLiteral> gte = this.getFieldValuePair(gteNode);
            Pair<String, RexLiteral> lte = this.getFieldValuePair(lteNode);
            String fieldName = (String)gte.getKey();
            String query = null;
            if (fieldName.equals(lte.getKey()) && this.compareRexLiteral((RexLiteral)gte.right, (RexLiteral)lte.right) < 0) {
                query = fieldName + ":[" + this.toSolrLiteral((RexLiteral)gte.getValue()) + " TO " + this.toSolrLiteral((RexLiteral)lte.getValue()) + "]";
            }
            return query;
        }

        private int compareRexLiteral(RexLiteral gte, RexLiteral lte) {
            return gte.getValue().compareTo(lte.getValue());
        }

        protected String translateIsNullOrIsNotNull(RexNode node) {
            if (!(node instanceof RexCall)) {
                throw new AssertionError((Object)("expected RexCall for predicate but found: " + node));
            }
            RexCall call = (RexCall)node;
            List operands = call.getOperands();
            if (operands.size() != 1) {
                throw new AssertionError((Object)("expected 1 operand for " + node));
            }
            RexNode left = (RexNode)operands.get(0);
            if (left instanceof RexInputRef) {
                String name = this.fieldNames.get(((RexInputRef)left).getIndex());
                SqlKind kind = node.getKind();
                return kind == SqlKind.IS_NOT_NULL ? "+" + name + ":*" : "(*:* -" + name + ":*)";
            }
            throw new AssertionError((Object)("expected field ref but found " + left));
        }

        protected String translateOr(RexNode condition) {
            ArrayList<String> ors = new ArrayList<String>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                String orQuery = this.translateMatch(node);
                if (orQuery.startsWith("-")) {
                    orQuery = "(*:* " + orQuery + ")";
                }
                ors.add(orQuery);
            }
            return String.join((CharSequence)" OR ", ors);
        }

        protected String translateAnd(RexNode node0) {
            ArrayList<String> andStrings = new ArrayList<String>();
            ArrayList<String> notStrings = new ArrayList<String>();
            ArrayList ands = new ArrayList();
            ArrayList nots = new ArrayList();
            RelOptUtil.decomposeConjunction((RexNode)node0, ands, nots);
            for (Object node : ands) {
                String andQuery = this.translateMatch((RexNode)node);
                if (andQuery.startsWith("-")) {
                    andQuery = "(*:* " + andQuery + ")";
                }
                andStrings.add(andQuery);
            }
            String andString = String.join((CharSequence)" AND ", andStrings);
            if (!nots.isEmpty()) {
                for (RexNode node : nots) {
                    notStrings.add(this.translateMatch(node));
                }
                String notString = String.join((CharSequence)" NOT ", notStrings);
                return "(" + andString + ") NOT (" + notString + ")";
            }
            return andString;
        }

        protected String translateLike(RexNode like) {
            Pair<String, RexLiteral> pair = this.getFieldValuePair(like);
            String terms = ((RexLiteral)pair.getValue()).toString().trim();
            terms = terms.replace("'", "").replace('%', '*').replace('_', '?');
            boolean wrappedQuotes = false;
            if (!(terms.startsWith("(") || terms.startsWith("[") || terms.startsWith("{"))) {
                terms = "\"" + ClientUtils.escapeQueryChars((String)terms).replace("\\*", "*").replace("\\?", "?") + "\"";
                wrappedQuotes = true;
            }
            String query = (String)pair.getKey() + ":" + terms;
            return wrappedQuotes ? "{!complexphrase}" + query : query;
        }

        protected String translateComparison(RexNode node) {
            SqlKind kind = node.getKind();
            if (kind == SqlKind.NOT) {
                RexNode negated = (RexNode)((RexCall)node).getOperands().get(0);
                return "-" + (negated.getKind() == SqlKind.LIKE ? this.translateLike(negated) : this.translateMatch(negated));
            }
            Pair<String, RexLiteral> binaryTranslated = this.getFieldValuePair(node);
            String key = (String)binaryTranslated.getKey();
            RexLiteral value = (RexLiteral)binaryTranslated.getValue();
            switch (kind) {
                case EQUALS: {
                    return this.toEqualsClause(key, value, node);
                }
                case NOT_EQUALS: {
                    return "-" + this.toEqualsClause(key, value, node);
                }
                case LESS_THAN: {
                    return "(" + key + ": [ * TO " + this.toSolrLiteral(value) + " })";
                }
                case LESS_THAN_OR_EQUAL: {
                    return "(" + key + ": [ * TO " + this.toSolrLiteral(value) + " ])";
                }
                case GREATER_THAN: {
                    return "(" + key + ": { " + this.toSolrLiteral(value) + " TO * ])";
                }
                case GREATER_THAN_OR_EQUAL: {
                    return "(" + key + ": [ " + this.toSolrLiteral(value) + " TO * ])";
                }
                case LIKE: {
                    return this.translateLike(node);
                }
                case IS_NOT_NULL: 
                case IS_NULL: {
                    return this.translateIsNullOrIsNotNull(node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private String toEqualsClause(String key, RexLiteral value, RexNode node) {
            SqlTypeName fieldTypeName = ((RexNode)((RexCall)node).getOperands().get(0)).getType().getSqlTypeName();
            String terms = this.toSolrLiteralForEquals(value, fieldTypeName).trim();
            boolean wrappedQuotes = false;
            if (!(terms.startsWith("(") || terms.startsWith("[") || terms.startsWith("{"))) {
                terms = "\"" + ClientUtils.escapeQueryChars((String)terms) + "\"";
                wrappedQuotes = true;
            }
            String clause = key + ":" + terms;
            if (terms.contains("*") && wrappedQuotes) {
                clause = "{!complexphrase}" + clause;
            }
            return clause;
        }

        private String toSolrLiteral(RexLiteral literal) {
            Object value2 = literal.getValue2();
            SqlTypeName typeName = literal.getTypeName();
            String solrLiteral = value2 instanceof Long && (typeName == SqlTypeName.TIMESTAMP || typeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) ? Instant.ofEpochMilli((Long)value2).toString() : value2.toString();
            return solrLiteral;
        }

        private String toSolrLiteralForEquals(RexLiteral literal, SqlTypeName fieldTypeName) {
            String solrLiteral;
            Object value2 = literal.getValue2();
            if (value2 instanceof String && fieldTypeName == SqlTypeName.TIMESTAMP && CALCITE_TIMESTAMP_REGEX.matcher((String)value2).matches()) {
                String timestamp = ((String)value2).replace(' ', 'T').replace("'", "");
                if (Character.isDigit(timestamp.charAt(timestamp.length() - 1))) {
                    timestamp = timestamp + "Z";
                }
                solrLiteral = timestamp;
            } else {
                solrLiteral = this.toSolrLiteral(literal);
            }
            return solrLiteral;
        }

        protected Pair<String, RexLiteral> getFieldValuePair(RexNode node) {
            Pair<String, RexLiteral> binaryTranslated;
            if (!(node instanceof RexCall)) {
                throw new AssertionError((Object)("expected RexCall for predicate but found: " + node));
            }
            RexCall call = (RexCall)node;
            Pair<String, RexLiteral> pair = binaryTranslated = call.getOperands().size() == 2 ? this.translateBinary(call) : null;
            if (binaryTranslated == null) {
                throw new AssertionError((Object)("unsupported predicate expression: " + node));
            }
            return binaryTranslated;
        }

        protected Pair<String, RexLiteral> translateBinary(RexCall call) {
            Pair<String, RexLiteral> b;
            RexNode right;
            List operands = call.getOperands();
            if (operands.size() != 2) {
                throw new AssertionError((Object)("Invalid number of arguments - " + operands.size()));
            }
            RexNode left = (RexNode)operands.get(0);
            Pair<String, RexLiteral> a = this.translateBinary2(left, right = (RexNode)operands.get(1));
            if (a != null) {
                return a;
            }
            if ((call.op.kind == SqlKind.EQUALS || call.op.kind == SqlKind.NOT_EQUALS) && (b = this.translateBinary2(right, left)) != null) {
                return b;
            }
            if (left.getKind() == SqlKind.CAST && right.getKind() == SqlKind.CAST) {
                return this.translateBinary2((RexNode)((RexCall)left).operands.get(0), (RexNode)((RexCall)right).operands.get(0));
            }
            if (left.getKind() == SqlKind.INPUT_REF && right.getKind() == SqlKind.CAST) {
                RexCall cast = (RexCall)right;
                if (cast.operands.size() == 1 && ((RexNode)cast.operands.get(0)).getKind() == SqlKind.LITERAL) {
                    return this.translateBinary2(left, (RexNode)cast.operands.get(0));
                }
            }
            throw new AssertionError((Object)("cannot translate call " + call));
        }

        protected Pair<String, RexLiteral> translateBinary2(RexNode left, RexNode right) {
            if (log.isDebugEnabled()) {
                log.debug("translateBinary2 left={} right={}", (Object)left, (Object)right);
            }
            if (right.getKind() != SqlKind.LITERAL) {
                if (log.isDebugEnabled()) {
                    log.debug("right != SqlKind.LITERAL, return null");
                }
                return null;
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    return new Pair((Object)name, (Object)rightLiteral);
                }
                case CAST: {
                    return this.translateBinary2((RexNode)((RexCall)left).operands.get(0), right);
                }
            }
            return null;
        }

        protected String translateSearch(RexNode condition) {
            RexNode peekAt0;
            String fieldName = this.getSolrFieldName(condition);
            RexCall expanded = (RexCall)RexUtil.expandSearch((RexBuilder)this.builder, null, (RexNode)condition);
            RexNode rexNode = peekAt0 = !expanded.operands.isEmpty() ? (RexNode)expanded.operands.get(0) : null;
            if (expanded.op.kind == SqlKind.AND) {
                if (peekAt0 instanceof RexCall) {
                    RexCall op0 = (RexCall)peekAt0;
                    if (op0.op.kind == SqlKind.NOT_EQUALS) {
                        return "*:* -" + fieldName + ":" + this.toOrSetOnSameField(expanded);
                    }
                }
            } else if (expanded.op.kind == SqlKind.OR && peekAt0 instanceof RexCall) {
                RexCall op0 = (RexCall)peekAt0;
                if (op0.op.kind == SqlKind.EQUALS) {
                    return fieldName + ":" + this.toOrSetOnSameField(expanded);
                }
            }
            if (expanded.getKind() != SqlKind.SEARCH) {
                return this.translateMatch((RexNode)expanded);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported search filter: " + condition);
        }

        protected String toOrSetOnSameField(RexCall search) {
            String orClause = search.operands.stream().map(n -> {
                RexCall next = (RexCall)n;
                RexLiteral lit = (RexLiteral)next.getOperands().get(1);
                return "\"" + this.toSolrLiteral(lit) + "\"";
            }).collect(Collectors.joining(" OR "));
            return "(" + orClause + ")";
        }

        protected String getSolrFieldName(RexNode node) {
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.getOperands().get(0);
            if (left instanceof RexInputRef) {
                return this.fieldNames.get(((RexInputRef)left).getIndex());
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Expected Solr field name for " + call.getKind() + " but found " + left);
        }
    }
}

