/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public final class ReplicationStream
extends ObjectInputStream {
    private ClassLoader classLoader = null;

    public ReplicationStream(InputStream stream, ClassLoader classLoader) throws IOException {
        super(stream);
        this.classLoader = classLoader;
    }

    public Class resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException, IOException {
        String name = classDesc.getName();
        boolean tryRepFirst = name.startsWith("org.apache.catalina.cluster");
        try {
            try {
                if (tryRepFirst) {
                    return this.findReplicationClass(name);
                }
                return this.findWebappClass(name);
            }
            catch (Exception x) {
                if (tryRepFirst) {
                    return this.findWebappClass(name);
                }
                return this.findReplicationClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(classDesc);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = this.classLoader;
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class cl = this.findWebappClass(interfaces[i]);
            if (latestLoader == null) {
                latestLoader = cl.getClassLoader();
            }
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    public Class findReplicationClass(String name) throws ClassNotFoundException, IOException {
        return Class.forName(name, false, this.getClass().getClassLoader());
    }

    public Class findWebappClass(String name) throws ClassNotFoundException, IOException {
        return Class.forName(name, false, this.classLoader);
    }
}

