/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.res.StringManager;

public final class Cookies {
    private static Log log;
    private static final StringManager sm;
    public static final int INITIAL_SIZE = 4;
    ServerCookie[] scookies = new ServerCookie[4];
    int cookieCount = 0;
    private int limit = 200;
    boolean unprocessed = true;
    MimeHeaders headers;
    public static final boolean ALLOW_EQUALS_IN_VALUE;
    public static final boolean PRESERVE_COOKIE_HEADER;
    public static final char[] SEPARATORS;
    protected static final boolean[] separators;
    static final int dbg = 0;

    public Cookies(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        if (limit > -1 && this.scookies.length > limit && this.cookieCount <= limit) {
            ServerCookie[] scookiesTmp = new ServerCookie[limit];
            System.arraycopy(this.scookies, 0, scookiesTmp, 0, this.cookieCount);
            this.scookies = scookiesTmp;
        }
    }

    public Cookies() {
    }

    public void setHeaders(MimeHeaders headers) {
        this.recycle();
        this.headers = headers;
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            if (this.scookies[i] == null) continue;
            this.scookies[i].recycle();
        }
        this.cookieCount = 0;
        this.unprocessed = true;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== Cookies ===");
        int count = this.getCookieCount();
        for (int i = 0; i < count; ++i) {
            pw.println(this.getCookie(i).toString());
        }
        return sw.toString();
    }

    public ServerCookie getCookie(int idx) {
        if (this.unprocessed) {
            this.getCookieCount();
        }
        return this.scookies[idx];
    }

    public int getCookieCount() {
        if (this.unprocessed) {
            this.unprocessed = false;
            this.processCookies(this.headers);
        }
        return this.cookieCount;
    }

    public ServerCookie addCookie() {
        ServerCookie c;
        if (this.limit > -1 && this.cookieCount >= this.limit) {
            throw new IllegalArgumentException(sm.getString("cookies.maxCountFail", this.limit));
        }
        if (this.cookieCount >= this.scookies.length) {
            int newSize = Math.min(2 * this.cookieCount, this.limit);
            ServerCookie[] scookiesTmp = new ServerCookie[newSize];
            System.arraycopy(this.scookies, 0, scookiesTmp, 0, this.cookieCount);
            this.scookies = scookiesTmp;
        }
        if ((c = this.scookies[this.cookieCount]) == null) {
            this.scookies[this.cookieCount] = c = new ServerCookie();
        }
        ++this.cookieCount;
        return c;
    }

    public void processCookies(MimeHeaders headers) {
        if (headers == null) {
            return;
        }
        int pos = 0;
        while (pos >= 0 && (pos = headers.findHeader("Cookie", pos)) >= 0) {
            MessageBytes cookieValue = headers.getValue(pos);
            if (cookieValue == null || cookieValue.isNull()) {
                ++pos;
                continue;
            }
            if (cookieValue.getType() == 2) {
                ByteChunk bc = cookieValue.getByteChunk();
                if (PRESERVE_COOKIE_HEADER) {
                    int len = bc.getLength();
                    if (len > 0) {
                        byte[] buf = new byte[len];
                        System.arraycopy(bc.getBytes(), bc.getOffset(), buf, 0, len);
                        this.processCookieHeader(buf, 0, len);
                    }
                } else {
                    this.processCookieHeader(bc.getBytes(), bc.getOffset(), bc.getLength());
                }
            } else {
                this.processCookieHeader(cookieValue.toString());
            }
            ++pos;
        }
    }

    public static boolean equals(String s, byte[] b, int start, int end) {
        int blen = end - start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void processCookieHeader(String cookieString) {
        StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1) continue;
            String name = token.substring(0, i).trim();
            String value = token.substring(i + 1, token.length()).trim();
            value = Cookies.stripQuote(value);
            ServerCookie cookie = this.addCookie();
            cookie.getName().setString(name);
            cookie.getValue().setString(value);
        }
    }

    private static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cookies: " + s));
        }
    }

    public static final boolean isSeparator(byte c) {
        if (c > 0 && c < 126) {
            return separators[c];
        }
        return false;
    }

    public static final boolean isWhiteSpace(byte c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    /*
     * Unable to fully structure code
     */
    public final void processCookieHeader(byte[] bytes, int off, int len) {
        if (len <= 0 || bytes == null) {
            return;
        }
        end = off + len;
        pos = off;
        nameStart = 0;
        nameEnd = 0;
        valueStart = 0;
        valueEnd = 0;
        version = 0;
        sc = null;
        while (pos < end) {
            block22: {
                block21: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (Cookies.isSeparator(bytes[pos]) || Cookies.isWhiteSpace(bytes[pos]))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (bytes[pos] == 36) {
                        isSpecial = true;
                    }
                    valueStart = nameStart = ++pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = Cookies.getTokenEndPosition(bytes, pos, end, true); pos < end && Cookies.isWhiteSpace(bytes[pos]); ++pos) {
                    }
                    if (pos >= end || bytes[pos] != 61) break block21;
                    while (++pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (bytes[pos]) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = Cookies.getQuotedValueEndPosition(bytes, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block22;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block22;
                        }
                        default: {
                            if (Cookies.isSeparator(bytes[pos]) && (bytes[pos] != 61 || !Cookies.ALLOW_EQUALS_IN_VALUE)) ** GOTO lbl47
                            valueStart = pos;
                            pos = valueEnd = Cookies.getTokenEndPosition(bytes, valueStart, end, false);
                            break block22;
lbl47:
                            // 1 sources

                            this.log("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                                ++pos;
                            }
                            ++pos;
                            sc = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                ++pos;
            }
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (Cookies.equals("Version", bytes, nameStart, nameEnd) && sc == null) {
                    if (bytes[valueStart] != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (sc == null) continue;
                if (Cookies.equals("Domain", bytes, nameStart, nameEnd)) {
                    sc.getDomain().setBytes(bytes, valueStart, valueEnd - valueStart);
                    continue;
                }
                if (Cookies.equals("Path", bytes, nameStart, nameEnd)) {
                    sc.getPath().setBytes(bytes, valueStart, valueEnd - valueStart);
                    continue;
                }
                if (Cookies.equals("Port", bytes, nameStart, nameEnd)) continue;
                this.log("Unknown Special Cookie");
                continue;
            }
            sc = this.addCookie();
            sc.setVersion(version);
            sc.getName().setBytes(bytes, nameStart, nameEnd - nameStart);
            if (valueStart != -1) {
                sc.getValue().setBytes(bytes, valueStart, valueEnd - valueStart);
                if (!isQuoted) continue;
                ServerCookie.unescapeDoubleQuotes(sc.getValue().getByteChunk());
                continue;
            }
            sc.getValue().setString("");
        }
    }

    public static final int getTokenEndPosition(byte[] bytes, int off, int end) {
        return Cookies.getTokenEndPosition(bytes, off, end, true);
    }

    private static final int getTokenEndPosition(byte[] bytes, int off, int end, boolean isName) {
        int pos;
        for (pos = off; pos < end && (!Cookies.isSeparator(bytes[pos]) || bytes[pos] == 61 && ALLOW_EQUALS_IN_VALUE && !isName); ++pos) {
        }
        if (pos > end) {
            return end;
        }
        return pos;
    }

    public static final int getQuotedValueEndPosition(byte[] bytes, int off, int end) {
        int pos = off;
        while (pos < end) {
            if (bytes[pos] == 34) {
                return pos;
            }
            if (bytes[pos] == 92 && pos < end - 1) {
                pos += 2;
                continue;
            }
            ++pos;
        }
        return end;
    }

    static {
        int i;
        log = LogFactory.getLog(Cookies.class);
        sm = StringManager.getManager("org.apache.tomcat.util.http.res");
        SEPARATORS = new char[]{'\t', ' ', '\"', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        separators = new boolean[128];
        for (i = 0; i < 128; ++i) {
            Cookies.separators[i] = false;
        }
        for (i = 0; i < SEPARATORS.length; ++i) {
            Cookies.separators[Cookies.SEPARATORS[i]] = true;
        }
        ALLOW_EQUALS_IN_VALUE = Boolean.valueOf(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_EQUALS_IN_VALUE", "false"));
        String preserveCookieHeader = System.getProperty("org.apache.tomcat.util.http.ServerCookie.PRESERVE_COOKIE_HEADER");
        PRESERVE_COOKIE_HEADER = preserveCookieHeader == null ? ServerCookie.STRICT_SERVLET_COMPLIANCE : Boolean.valueOf(preserveCookieHeader);
    }
}

