/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;

public final class FileStore
extends StoreBase {
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String path) {
        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public int getSize() throws IOException {
        File file = this.directory();
        if (file == null) {
            return 0;
        }
        String[] files = file.list();
        int keycount = 0;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(FILE_EXT)) continue;
                ++keycount;
            }
        }
        return keycount;
    }

    public void clear() throws IOException {
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    public String[] keys() throws IOException {
        File file = this.directory();
        if (file == null) {
            return new String[0];
        }
        String[] files = file.list();
        if (files == null || files.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(FILE_EXT)) continue;
            list.add(files[i].substring(0, files[i].length() - n));
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Session load(String id) throws ClassNotFoundException, IOException {
        IOException f222;
        StandardSession standardSession;
        ClassLoader oldThreadContextCL;
        ObjectInputStream ois;
        FileInputStream fis;
        Log containerLog;
        block22: {
            File file = this.file(id);
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            Context context = (Context)this.getManager().getContainer();
            containerLog = context.getLogger();
            if (containerLog.isDebugEnabled()) {
                containerLog.debug((Object)sm.getString(this.getStoreName() + ".loading", id, file.getAbsolutePath()));
            }
            fis = null;
            ois = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            oldThreadContextCL = Thread.currentThread().getContextClassLoader();
            fis = new FileInputStream(file.getAbsolutePath());
            loader = context.getLoader();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            ois = this.getObjectInputStream(fis);
            StandardSession session = (StandardSession)this.manager.createEmptySession();
            session.readObjectData(ois);
            session.setManager(this.manager);
            standardSession = session;
            Object var13_14 = null;
            if (fis == null) break block22;
            try {
                fis.close();
            }
            catch (IOException f222) {
                // empty catch block
            }
        }
        if (ois != null) {
            try {
                ois.close();
            }
            catch (IOException f222) {
                // empty catch block
            }
        }
        Thread.currentThread().setContextClassLoader(oldThreadContextCL);
        return standardSession;
        catch (FileNotFoundException e) {
            IOException f222;
            Session session;
            block24: {
                try {
                    if (containerLog.isDebugEnabled()) {
                        containerLog.debug((Object)"No persisted data file found");
                    }
                    session = null;
                    Object var13_15 = null;
                    if (fis == null) break block24;
                }
                catch (Throwable throwable) {
                    IOException f222;
                    Object var13_16 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException f222) {
                            // empty catch block
                        }
                    }
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException f222) {
                            // empty catch block
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldThreadContextCL);
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException f222) {
                    // empty catch block
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException f222) {
                    // empty catch block
                }
            }
            Thread.currentThread().setContextClassLoader(oldThreadContextCL);
            return session;
        }
    }

    public void remove(String id) throws IOException {
        File file = this.file(id);
        if (file == null) {
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".removing", id, file.getAbsolutePath()));
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        File file = this.file(session.getIdInternal());
        if (file == null) {
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".saving", session.getIdInternal(), file.getAbsolutePath()));
        }
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
        }
        catch (IOException ioe) {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            } else if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        try {
            ((StandardSession)session).writeObjectData(oos);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            oos.close();
            throw throwable;
        }
        oos.close();
    }

    private File directory() {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Context context = (Context)this.manager.getContainer();
            ServletContext servletContext = context.getServletContext();
            File work = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            file = new File(work, this.directory);
        }
        if (!file.exists() || !file.isDirectory()) {
            file.delete();
            file.mkdirs();
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String id) {
        if (this.directory == null) {
            return null;
        }
        String filename = id + FILE_EXT;
        File file = new File(this.directory(), filename);
        return file;
    }
}

