/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.Utilities;
import ints.IntIntMap;
import ints.IntList;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.stream.IntStream;
import main.CompHapSegment;
import phase.LowFreqPhaseIbs;
import phase.PhaseData;
import phase.Steps;
import vcf.XRefGT;

public final class LowFreqPhaseStates {
    private static final int NIL = -103;
    private final LowFreqPhaseIbs ibsHaps;
    private final PhaseData phaseData;
    private final Steps steps;
    private final XRefGT allHaps;
    private final int nMarkers;
    private final int maxStates;
    private final int minSteps;
    private final IntIntMap hapToEnd;
    private final PriorityQueue<CompHapSegment> q;
    private final IntList[] compositeHapToHap;
    private final IntList[] compositeHapToEnd;
    private final int[] segmentIndex;
    private final int[] compHapToHap;
    private final int[] compHapToEnd;

    public LowFreqPhaseStates(LowFreqPhaseIbs lowFreqPhaseIbs, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        this.ibsHaps = lowFreqPhaseIbs;
        this.phaseData = lowFreqPhaseIbs.phaseData();
        this.steps = this.phaseData.fpd().stage1Steps();
        this.allHaps = lowFreqPhaseIbs.allHaps();
        this.nMarkers = this.allHaps.nMarkers();
        this.maxStates = n2;
        float f = this.phaseData.fpd().ibsStep();
        this.minSteps = Math.max(200, (int)Math.ceil(1.0f / f));
        this.hapToEnd = new IntIntMap(n2);
        this.q = new PriorityQueue(n2);
        this.compositeHapToHap = (IntList[])IntStream.range(0, n2).mapToObj(n -> new IntList()).toArray(IntList[]::new);
        this.compositeHapToEnd = (IntList[])IntStream.range(0, n2).mapToObj(n -> new IntList()).toArray(IntList[]::new);
        this.segmentIndex = new int[n2];
        this.compHapToHap = new int[n2];
        this.compHapToEnd = new int[n2];
    }

    public int nTargHaps() {
        return this.phaseData.fpd().targGT().nHaps();
    }

    public int nMarkers() {
        return this.phaseData.fpd().targGT().nMarkers();
    }

    public int maxStates() {
        return this.maxStates;
    }

    public int ibsStates(int n, int[][] nArray, byte[][] byArray) {
        int n2 = this.setCompRefHaps(n);
        this.copyData(n, n2, nArray, byArray);
        return n2;
    }

    private int setCompRefHaps(int n) {
        int n2;
        this.q.clear();
        this.hapToEnd.clear();
        int n3 = this.maxStates;
        for (n2 = 0; n2 < n3; ++n2) {
            this.compositeHapToHap[n2].clear();
            this.compositeHapToEnd[n2].clear();
        }
        n3 = this.steps.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.addIbsHap(this.ibsHaps.fwdIbsHap(n, n2), n2);
            this.addIbsHap(this.ibsHaps.bwdIbsHap(n, n2), n2);
        }
        if (this.q.isEmpty()) {
            this.fillQWithRandomHaps(n);
        }
        n2 = this.setFinalRefSegs();
        return n2;
    }

    private void addIbsHap(int n, int n2) {
        if (n < 0) {
            return;
        }
        if (this.hapToEnd.get(n, -103) == -103) {
            this.updateHeadOfQ();
            if (this.q.size() == this.maxStates || !this.q.isEmpty() && n2 - this.q.peek().ibsStep() >= this.minSteps) {
                CompHapSegment compHapSegment = this.q.poll();
                int n3 = compHapSegment.compHapIndex();
                int n4 = compHapSegment.hap();
                int n5 = this.steps.start(compHapSegment.ibsStep() + n2 >>> 1);
                this.hapToEnd.remove(n4);
                this.compositeHapToHap[n3].add(n);
                this.compositeHapToEnd[n3].add(n5);
                compHapSegment.updateSegment(n, n5, n2);
                this.q.add(compHapSegment);
            } else {
                int n6 = this.q.size();
                this.compositeHapToHap[n6].add(n);
                this.q.add(new CompHapSegment(n, 0, n2, n6));
            }
        }
        this.hapToEnd.put(n, n2);
    }

    private void updateHeadOfQ() {
        CompHapSegment compHapSegment = this.q.peek();
        if (compHapSegment != null) {
            int n = this.hapToEnd.get(compHapSegment.hap(), -103);
            while (compHapSegment.ibsStep() != n) {
                compHapSegment = this.q.poll();
                compHapSegment.updateStep(n);
                this.q.offer(compHapSegment);
                compHapSegment = this.q.peek();
                n = this.hapToEnd.get(compHapSegment.hap(), -103);
            }
        }
    }

    private int setFinalRefSegs() {
        int n = this.q.size();
        CompHapSegment compHapSegment = this.q.poll();
        while (compHapSegment != null) {
            int n2 = compHapSegment.compHapIndex();
            this.compositeHapToEnd[n2].add(this.nMarkers);
            this.segmentIndex[n2] = 0;
            this.compHapToHap[n2] = this.compositeHapToHap[n2].get(0);
            this.compHapToEnd[n2] = this.compositeHapToEnd[n2].get(0);
            compHapSegment = this.q.poll();
        }
        return n;
    }

    private void copyData(int n, int n2, int[][] nArray, byte[][] byArray) {
        for (int i = 0; i < this.nMarkers; ++i) {
            int n3 = this.allHaps.allele(i, n);
            for (int j = 0; j < n2; ++j) {
                int n4;
                if (i == this.compHapToEnd[j]) {
                    int n5 = j;
                    this.segmentIndex[n5] = this.segmentIndex[n5] + 1;
                    this.compHapToHap[j] = this.compositeHapToHap[j].get(this.segmentIndex[j]);
                    this.compHapToEnd[j] = this.compositeHapToEnd[j].get(this.segmentIndex[j]);
                }
                nArray[i][j] = n4 = this.compHapToHap[j];
                byArray[i][j] = this.allHaps.allele(i, n4) == n3 ? (byte)0 : 1;
            }
        }
    }

    private void fillQWithRandomHaps(int n) {
        assert (this.q.isEmpty());
        int n2 = this.allHaps.nHaps();
        int n3 = Math.min(n2 - 2, this.maxStates);
        if (n3 <= 0) {
            Utilities.exit("ERROR: there is only one sample");
        } else {
            Random random = new Random(this.phaseData.seed() + (long)n);
            int n4 = this.steps.size() - 1;
            int n5 = n >> 1;
            for (int i = 0; i < n3; ++i) {
                int n6 = random.nextInt(n2);
                while (n6 >> 1 == n5) {
                    n6 = random.nextInt(n2);
                }
                this.compositeHapToHap[this.q.size()].add(n6);
                this.q.add(new CompHapSegment(n6, 0, n4, i));
            }
        }
    }
}

