/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.shared;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.igoweb.util.DbConn;

public class I18nDesc
extends HashMap<String, String> {
    private Type descType = null;
    private transient boolean inDb = false;

    public I18nDesc() {
    }

    public I18nDesc(Type descType) {
        this.setDescType(descType);
    }

    public I18nDesc(DbConn db, int sourceId, Type descType) throws SQLException {
        this.setDescType(descType);
        this.load(db, sourceId);
    }

    public I18nDesc(I18nDesc base) {
        super(base);
        this.setDescType(base.descType);
    }

    public void setDescType(Type newDescType) {
        if (newDescType == null) {
            throw new IllegalArgumentException("Can't set type to null");
        }
        if (this.inDb) {
            throw new IllegalStateException("Already in DB");
        }
        this.descType = newDescType;
    }

    public Type getDescType() {
        return this.descType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(DbConn db, int sourceId) throws SQLException {
        if (this.descType == null) {
            throw new IllegalStateException();
        }
        try (ResultSet rs = null;){
            PreparedStatement ps = db.get("SELECT locale, description  FROM i18n_descriptions  WHERE source_id = ? AND desc_type = ?");
            ps.setInt(1, sourceId);
            ps.setString(2, this.descType.sqlName);
            rs = ps.executeQuery();
            while (rs.next()) {
                super.put(rs.getString("locale"), rs.getString("description"));
            }
            this.inDb = true;
        }
    }

    public void store(DbConn db, int sourceId) throws SQLException {
        if (this.inDb) {
            throw new IllegalStateException("Already in database");
        }
        if (this.descType == null) {
            throw new IllegalStateException("DescType not set");
        }
        I18nDesc storage = new I18nDesc(db, sourceId, this.descType);
        storage.sync(db, sourceId, this);
        this.clear();
        this.load(db, sourceId);
    }

    @Override
    public String get(Object localeName) {
        if (this.isEmpty()) {
            return null;
        }
        String result = (String)super.get(localeName);
        if (result != null) {
            return result;
        }
        if (!localeName.equals("en_US") && (result = (String)super.get("en_US")) != null) {
            return result;
        }
        return (String)this.values().iterator().next();
    }

    public boolean sync(DbConn db, int sourceId, I18nDesc newDescs) throws SQLException {
        if (!this.inDb || newDescs.inDb) {
            throw new IllegalStateException();
        }
        boolean change = false;
        for (Map.Entry entry : newDescs.entrySet()) {
            String localeId = (String)entry.getKey();
            String value = (String)entry.getValue();
            String prevValue = (String)super.get(localeId);
            PreparedStatement ps = null;
            if (prevValue == null) {
                ps = db.get("INSERT INTO i18n_descriptions    (source_id, desc_type, locale, description)  VALUES    (?, ?, ?, ?)");
                ps.setInt(1, sourceId);
                ps.setString(2, this.descType.sqlName);
                ps.setString(3, localeId);
                ps.setString(4, value);
            } else if (!prevValue.equals(value)) {
                ps = db.get("UPDATE i18n_descriptions  SET description = ?  WHERE source_id = ? AND desc_type = ? AND locale = ?");
                ps.setString(1, value);
                ps.setInt(2, sourceId);
                ps.setString(3, this.descType.sqlName);
                ps.setString(4, localeId);
            }
            if (ps == null) continue;
            ps.execute();
            if (ps.getUpdateCount() != 1) {
                throw new RuntimeException("Update count(" + ps + ") = " + ps.getUpdateCount());
            }
            super.put(localeId, value);
            change = true;
        }
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            String localeId = (String)iter.next();
            if (newDescs.containsKey(localeId)) continue;
            PreparedStatement ps = db.get("DELETE FROM i18n_descriptions  WHERE source_id = ? AND desc_type = ? AND locale = ?");
            ps.setInt(1, sourceId);
            ps.setString(2, this.descType.sqlName);
            ps.setString(3, localeId);
            ps.execute();
            if (ps.getUpdateCount() != 1) {
                throw new RuntimeException("Update count(" + ps + ") = " + ps.getUpdateCount());
            }
            change = true;
            iter.remove();
        }
        return change;
    }

    @Override
    public String put(String key, String value) {
        if (this.inDb) {
            throw new IllegalStateException();
        }
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value == null ? (String)super.remove(key) : super.put(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.descType == ((I18nDesc)o).descType && super.equals(o);
    }

    public static enum Type {
        SCHEDULE_ITEM(false, true),
        TOURN_PRIZE(true, true),
        TOURN_SPONSOR(true, true),
        TOURN_INFO(true, true),
        PRODUCT_NAME(false, false);

        public final String sqlName = this.name().toLowerCase(Locale.US);
        public final boolean isTourn;
        public final boolean isXhtml;
        private static volatile HashMap<String, Type> nameToType;

        private Type(boolean isTourn, boolean isXhtml) {
            this.isTourn = isTourn;
            this.isXhtml = isXhtml;
        }

        public static Type get(String sqlName) {
            Type result;
            HashMap<String, Type> localNtt = nameToType;
            if (localNtt == null) {
                Type.initNameToType();
                localNtt = nameToType;
            }
            if ((result = localNtt.get(sqlName)) == null) {
                throw new IllegalArgumentException("Invalid type sql name: " + sqlName);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void initNameToType() {
            Class<Type> clazz = Type.class;
            synchronized (Type.class) {
                if (nameToType == null) {
                    HashMap<String, Type> map = new HashMap<String, Type>();
                    for (Type type : Type.values()) {
                        map.put(type.sqlName, type);
                    }
                    nameToType = map;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }
}

