/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.passive.AbstractPotentiometer;
import org.diylc.core.ComponentState;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Potentiometer (panel mount)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.SINGLE_CLICK, instanceNamePrefix="VR", description="Panel mount potentiometer with solder lugs", zOrder=4.0, stretchable=false)
public class PotentiometerPanel
extends AbstractPotentiometer {
    private static final long serialVersionUID = 1L;
    protected static Size BODY_DIAMETER = new Size(Double.valueOf(1.0), SizeUnit.in);
    protected static Size SPACING = new Size(Double.valueOf(0.3), SizeUnit.in);
    protected static Size LUG_DIAMETER = new Size(Double.valueOf(0.15), SizeUnit.in);
    protected static Color BODY_COLOR = Color.gray.brighter();
    protected static Color BORDER_COLOR = Color.gray;
    protected Size bodyDiameter = BODY_DIAMETER;
    protected Size spacing = SPACING;
    protected Size lugDiameter = LUG_DIAMETER;
    protected Color bodyColor = BODY_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected transient Area[] body = null;

    public PotentiometerPanel() {
        this.controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
        this.updateControlPoints();
    }

    protected void updateControlPoints() {
        int spacing = (int)this.spacing.convertToPixels();
        switch (this.orientation) {
            case DEFAULT: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x + spacing, this.controlPoints[0].y);
                this.controlPoints[2].setLocation(this.controlPoints[0].x + 2 * spacing, this.controlPoints[0].y);
                break;
            }
            case _90: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x, this.controlPoints[0].y + spacing);
                this.controlPoints[2].setLocation(this.controlPoints[0].x, this.controlPoints[0].y + 2 * spacing);
                break;
            }
            case _180: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x - spacing, this.controlPoints[0].y);
                this.controlPoints[2].setLocation(this.controlPoints[0].x - 2 * spacing, this.controlPoints[0].y);
                break;
            }
            case _270: {
                this.controlPoints[1].setLocation(this.controlPoints[0].x, this.controlPoints[0].y - spacing);
                this.controlPoints[2].setLocation(this.controlPoints[0].x, this.controlPoints[0].y - 2 * spacing);
                break;
            }
        }
    }

    public Area[] getBody() {
        int spacing = (int)this.spacing.convertToPixels();
        int diameter = this.getClosestOdd(this.bodyDiameter.convertToPixels());
        if (this.body == null) {
            int i;
            this.body = new Area[7];
            int lugDiameter = this.getClosestOdd(this.lugDiameter.convertToPixels());
            int holeDiameter = this.getClosestOdd(this.lugDiameter.convertToPixels() / 2.0);
            for (i = 0; i < 3; ++i) {
                Area area;
                this.body[4 + i] = area = new Area(new Ellipse2D.Double(this.controlPoints[i].x - lugDiameter / 2, this.controlPoints[i].y - lugDiameter / 2, lugDiameter, lugDiameter));
            }
            switch (this.orientation) {
                case DEFAULT: {
                    this.body[3] = new Area(new Ellipse2D.Double(this.controlPoints[0].x + spacing - diameter / 2, this.controlPoints[0].y - spacing / 2 - diameter, diameter, diameter));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x - holeDiameter / 2, this.controlPoints[i].y - (spacing + diameter) / 2, holeDiameter, (spacing + diameter) / 2));
                    }
                    break;
                }
                case _90: {
                    this.body[3] = new Area(new Ellipse2D.Double(this.controlPoints[0].x + spacing / 2, this.controlPoints[0].y + spacing - diameter / 2, diameter, diameter));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x, this.controlPoints[i].y - holeDiameter / 2, (spacing + diameter) / 2, holeDiameter));
                    }
                    break;
                }
                case _180: {
                    this.body[3] = new Area(new Ellipse2D.Double(this.controlPoints[0].x - spacing - diameter / 2, this.controlPoints[0].y + spacing / 2, diameter, diameter));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x - holeDiameter / 2, this.controlPoints[i].y, holeDiameter, (spacing + diameter) / 2));
                    }
                    break;
                }
                case _270: {
                    this.body[3] = new Area(new Ellipse2D.Double(this.controlPoints[0].x - spacing / 2 - diameter, this.controlPoints[0].y - spacing - diameter / 2, diameter, diameter));
                    for (i = 0; i < 3; ++i) {
                        this.body[i] = new Area(new Rectangle2D.Double(this.controlPoints[i].x - (spacing + diameter) / 2, this.controlPoints[i].y - holeDiameter / 2, (spacing + diameter) / 2, holeDiameter));
                    }
                    break;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 3; j < 7; ++j) {
                    this.body[i].subtract(this.body[j]);
                }
            }
            for (i = 0; i < 3; ++i) {
                this.body[4 + i].subtract(new Area(new Ellipse2D.Double(this.controlPoints[i].x - holeDiameter / 2, this.controlPoints[i].y - holeDiameter / 2, holeDiameter, holeDiameter)));
            }
        }
        return this.body;
    }

    @Override
    public void setControlPoint(Point point, int index) {
        super.setControlPoint(point, index);
        this.body = null;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        this.updateControlPoints();
        this.body = null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        for (Area shape : this.getBody()) {
            if (shape == null) continue;
            g2d.setColor(this.bodyColor);
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            if (!outlineMode) {
                g2d.fill(shape);
            }
            g2d.setComposite(oldComposite);
            Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
            g2d.setColor(finalBorderColor);
            g2d.draw(shape);
        }
        g2d.setFont(LABEL_FONT);
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR);
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D bodyRect = this.getBody()[3].getBounds2D();
        Rectangle2D rect = fontMetrics.getStringBounds(this.getName(), g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int panelHeight = (int)bodyRect.getHeight();
        int panelWidth = (int)bodyRect.getWidth();
        int x = (panelWidth - textWidth) / 2;
        int y = panelHeight / 2 - textHeight + fontMetrics.getAscent();
        g2d.drawString(this.getName(), (int)(bodyRect.getX() + (double)x), (int)(bodyRect.getY() + (double)y));
        rect = fontMetrics.getStringBounds(this.getValueForDisplay(), g2d);
        textHeight = (int)rect.getHeight();
        textWidth = (int)rect.getWidth();
        x = (panelWidth - textWidth) / 2;
        y = panelHeight / 2 + fontMetrics.getAscent();
        g2d.drawString(this.getValueForDisplay(), (int)(bodyRect.getX() + (double)x), (int)(bodyRect.getY() + (double)y));
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 4 * width / 32;
        int spacing = width / 3 - 1;
        g2d.setColor(BORDER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2 * width / 32));
        g2d.drawLine(width / 2 - spacing, height / 2, width / 2 - spacing, height - margin);
        g2d.drawLine(width / 2 + spacing, height / 2, width / 2 + spacing, height - margin);
        g2d.drawLine(width / 2, height / 2, width / 2, height - margin);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(4 * width / 32));
        g2d.drawLine(width / 2 - spacing, height - margin, width / 2 - spacing, height - margin);
        g2d.drawLine(width / 2 + spacing, height - margin, width / 2 + spacing, height - margin);
        g2d.drawLine(width / 2, height - margin, width / 2, height - margin);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.setColor(BODY_COLOR);
        g2d.fillOval(margin, margin / 2, width - 2 * margin, height - 2 * margin);
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(margin, margin / 2, width - 2 * margin, height - 2 * margin);
    }

    @EditableProperty
    public Size getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Size spacing) {
        this.spacing = spacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Diameter")
    public Size getBodyDiameter() {
        return this.bodyDiameter;
    }

    public void setBodyDiameter(Size bodyDiameter) {
        this.bodyDiameter = bodyDiameter;
        this.body = null;
    }

    @EditableProperty(name="Lug size")
    public Size getLugDiameter() {
        return this.lugDiameter;
    }

    public void setLugDiameter(Size lugDiameter) {
        this.lugDiameter = lugDiameter;
        this.body = null;
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }
}

