/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.apache.jcp.xml.dsig.internal.dom.DOMManifest;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignatureProperties;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignatureProperty;
import org.apache.jcp.xml.dsig.internal.dom.DOMStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMTransform;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class Marshaller {
    private static XmlWriter.ToMarshal<KeyName> Marshal_KeyName = new XmlWriter.ToMarshal<KeyName>(KeyName.class){

        @Override
        public void marshalObject(XmlWriter xwriter, KeyName toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            Marshaller.marshalKeyName(xwriter, toMarshal, dsPrefix);
        }
    };
    private static XmlWriter.ToMarshal<KeyInfo> Marshal_KeyInfo = new XmlWriter.ToMarshal<KeyInfo>(KeyInfo.class){

        @Override
        public void marshalObject(XmlWriter xwriter, KeyInfo toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMKeyInfo.marshal(xwriter, toMarshal, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<KeyValue> Marshal_KeyValue = new XmlWriter.ToMarshal<KeyValue>(KeyValue.class){

        @Override
        public void marshalObject(XmlWriter xwriter, KeyValue toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMKeyValue dkv = (DOMKeyValue)toMarshal;
            dkv.marshal(xwriter, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<X509IssuerSerial> Marshal_X509IssuerSerial = new XmlWriter.ToMarshal<X509IssuerSerial>(X509IssuerSerial.class){

        @Override
        public void marshalObject(XmlWriter xwriter, X509IssuerSerial toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            Marshaller.marshalX509IssuerSerial(xwriter, toMarshal, dsPrefix);
        }
    };
    private static XmlWriter.ToMarshal<X509Data> Marshal_X509Data = new XmlWriter.ToMarshal<X509Data>(X509Data.class){

        @Override
        public void marshalObject(XmlWriter xwriter, X509Data toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMX509Data.marshal(xwriter, toMarshal, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<DigestMethod> Marshal_DigestMethod = new XmlWriter.ToMarshal<DigestMethod>(DigestMethod.class){

        @Override
        public void marshalObject(XmlWriter xwriter, DigestMethod toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMDigestMethod.marshal(xwriter, toMarshal, dsPrefix);
        }
    };
    private static XmlWriter.ToMarshal<PGPData> Marshal_PGPData = new XmlWriter.ToMarshal<PGPData>(PGPData.class){

        @Override
        public void marshalObject(XmlWriter xwriter, PGPData toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            Marshaller.marshalPGPData(xwriter, toMarshal, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<SignatureProperty> Marshal_SignatureProperty = new XmlWriter.ToMarshal<SignatureProperty>(SignatureProperty.class){

        @Override
        public void marshalObject(XmlWriter xwriter, SignatureProperty toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMSignatureProperty.marshal(xwriter, toMarshal, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<SignatureProperties> Marshal_SignatureProperties = new XmlWriter.ToMarshal<SignatureProperties>(SignatureProperties.class){

        @Override
        public void marshalObject(XmlWriter xwriter, SignatureProperties toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMSignatureProperties.marshal(xwriter, toMarshal, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<DOMSignatureMethod> Marshal_DOMSignatureMethod = new XmlWriter.ToMarshal<DOMSignatureMethod>(DOMSignatureMethod.class){

        @Override
        public void marshalObject(XmlWriter xwriter, DOMSignatureMethod toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            toMarshal.marshal(xwriter, dsPrefix);
        }
    };
    private static XmlWriter.ToMarshal<DOMTransform> Marshal_DOMTransform = new XmlWriter.ToMarshal<DOMTransform>(DOMTransform.class){

        @Override
        public void marshalObject(XmlWriter xwriter, DOMTransform toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            toMarshal.marshal(xwriter, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<Manifest> Marshal_Manifest = new XmlWriter.ToMarshal<Manifest>(Manifest.class){

        @Override
        public void marshalObject(XmlWriter xwriter, Manifest toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            DOMManifest.marshal(xwriter, toMarshal, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<DOMStructure> Marshal_DOMStructure = new XmlWriter.ToMarshal<DOMStructure>(DOMStructure.class){

        @Override
        public void marshalObject(XmlWriter xwriter, DOMStructure toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            toMarshal.marshal(xwriter, dsPrefix, context);
        }
    };
    private static XmlWriter.ToMarshal<javax.xml.crypto.dom.DOMStructure> Marshal_JavaXDOMStructure = new XmlWriter.ToMarshal<javax.xml.crypto.dom.DOMStructure>(javax.xml.crypto.dom.DOMStructure.class){

        @Override
        public void marshalObject(XmlWriter xwriter, javax.xml.crypto.dom.DOMStructure toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            Marshaller.marshalGenericNode(xwriter, toMarshal);
        }
    };
    private static final List<XmlWriter.ToMarshal<? extends XMLStructure>> MARSHALLERS = new ArrayList<XmlWriter.ToMarshal<? extends XMLStructure>>();

    private Marshaller() {
    }

    public static List<XmlWriter.ToMarshal<? extends XMLStructure>> getMarshallers() {
        return MARSHALLERS;
    }

    public static void marshalKeyName(XmlWriter xwriter, KeyName keyName, String dsPrefix) {
        xwriter.writeTextElement(dsPrefix, "KeyName", "http://www.w3.org/2000/09/xmldsig#", keyName.getName());
    }

    public static void marshalPGPData(XmlWriter xwriter, PGPData pgpData, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        byte[] keyPacket;
        xwriter.writeStartElement(dsPrefix, "PGPData", "http://www.w3.org/2000/09/xmldsig#");
        byte[] keyId = pgpData.getKeyId();
        if (keyId != null) {
            xwriter.writeTextElement(dsPrefix, "PGPKeyID", "http://www.w3.org/2000/09/xmldsig#", Base64.encode(keyId));
        }
        if ((keyPacket = pgpData.getKeyPacket()) != null) {
            xwriter.writeTextElement(dsPrefix, "XMLSignature.XMLNS", "http://www.w3.org/2000/09/xmldsig#", Base64.encode(keyPacket));
        }
        List<XMLStructure> externalElements = pgpData.getExternalElements();
        for (XMLStructure externalItem : externalElements) {
            xwriter.marshalStructure(externalItem, dsPrefix, context);
        }
        xwriter.writeEndElement();
    }

    public static void marshalX509IssuerSerial(XmlWriter xwriter, X509IssuerSerial issuerSerial, String dsPrefix) {
        xwriter.writeStartElement(dsPrefix, "X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#");
        xwriter.writeTextElement(dsPrefix, "X509IssuerName", "http://www.w3.org/2000/09/xmldsig#", issuerSerial.getIssuerName());
        xwriter.writeTextElement(dsPrefix, "X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#", issuerSerial.getSerialNumber().toString());
        xwriter.writeEndElement();
    }

    private static void marshalGenericNode(XmlWriter xwriter, javax.xml.crypto.dom.DOMStructure xmlStruct) {
        Node node = xmlStruct.getNode();
        if (DOMUtils.isNamespace(node)) {
            xwriter.writeNamespace(node.getLocalName(), node.getTextContent());
        } else if (2 == node.getNodeType()) {
            Marshaller.sendAttributeToWriter(xwriter, (Attr)node);
        } else {
            Marshaller.marshalGenericNode(xwriter, node);
        }
    }

    private static void marshalGenericNode(XmlWriter xwriter, Node node) {
        short nodeType = node.getNodeType();
        if (DOMUtils.isNamespace(node)) {
            xwriter.writeNamespace(node.getLocalName(), node.getTextContent());
        } else if (nodeType == 2) {
            Marshaller.sendAttributeToWriter(xwriter, (Attr)node);
        } else {
            switch (nodeType) {
                case 1: {
                    xwriter.writeStartElement(node.getPrefix(), node.getLocalName(), node.getNamespaceURI());
                    NamedNodeMap nnm = node.getAttributes();
                    for (int idx = 0; idx < nnm.getLength(); ++idx) {
                        Attr attr = (Attr)nnm.item(idx);
                        if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
                            xwriter.writeNamespace(attr.getLocalName(), attr.getValue());
                            continue;
                        }
                        Marshaller.sendAttributeToWriter(xwriter, attr);
                    }
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        Marshaller.marshalGenericNode(xwriter, child);
                    }
                    xwriter.writeEndElement();
                    break;
                }
                case 8: {
                    xwriter.writeComment(node.getTextContent());
                    break;
                }
                case 3: {
                    xwriter.writeCharacters(node.getTextContent());
                    break;
                }
            }
        }
    }

    private static void sendAttributeToWriter(XmlWriter xwriter, Attr attr) {
        if (attr.isId()) {
            xwriter.writeIdAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getTextContent());
        } else if (attr.getNamespaceURI() == null && attr.getLocalName() == null) {
            xwriter.writeAttribute(null, null, attr.getName(), attr.getTextContent());
        } else {
            xwriter.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getTextContent());
        }
    }

    static {
        MARSHALLERS.add(Marshal_KeyName);
        MARSHALLERS.add(Marshal_KeyInfo);
        MARSHALLERS.add(Marshal_KeyValue);
        MARSHALLERS.add(Marshal_X509IssuerSerial);
        MARSHALLERS.add(Marshal_X509Data);
        MARSHALLERS.add(Marshal_DigestMethod);
        MARSHALLERS.add(Marshal_PGPData);
        MARSHALLERS.add(Marshal_SignatureProperty);
        MARSHALLERS.add(Marshal_SignatureProperties);
        MARSHALLERS.add(Marshal_DOMSignatureMethod);
        MARSHALLERS.add(Marshal_DOMTransform);
        MARSHALLERS.add(Marshal_Manifest);
        MARSHALLERS.add(Marshal_DOMStructure);
        MARSHALLERS.add(Marshal_JavaXDOMStructure);
    }
}

