/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public abstract class BaseDateTimeProcessor
implements Processor {
    private final ZoneId zoneId;

    BaseDateTimeProcessor(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    BaseDateTimeProcessor(StreamInput in) throws IOException {
        this.zoneId = ZoneId.of(in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.zoneId.getId());
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public Object process(Object input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof ZonedDateTime)) {
            throw new SqlIllegalArgumentException("A date is required; received {}", input);
        }
        return this.doProcess(((ZonedDateTime)input).withZoneSameInstant(this.zoneId));
    }

    abstract Object doProcess(ZonedDateTime var1);
}

