/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ConnectionHandlerMonitorEntry
extends MonitorEntry {
    static final String CONNECTION_HANDLER_MONITOR_OC = "ds-connectionhandler-monitor-entry";
    private static final String ATTR_CONNECTION = "ds-connectionhandler-connection";
    private static final String ATTR_LISTENER = "ds-connectionhandler-listener";
    private static final String ATTR_NUM_CONNECTIONS = "ds-connectionhandler-num-connections";
    private static final String ATTR_PROTOCOL = "ds-connectionhandler-protocol";
    private static final long serialVersionUID = -2922139631867367609L;
    private final List<String> connections = this.getStrings("ds-connectionhandler-connection");
    private final List<String> listeners = this.getStrings("ds-connectionhandler-listener");
    private final Long numConnections = this.getLong("ds-connectionhandler-num-connections");
    private final String protocol = this.getString("ds-connectionhandler-protocol");

    public ConnectionHandlerMonitorEntry(Entry entry) {
        super(entry);
    }

    public List<String> getConnections() {
        return this.connections;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public Long getNumConnections() {
        return this.numConnections;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_CONNECTION_HANDLER_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_CONNECTION_HANDLER_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(4);
        if (this.protocol != null) {
            ConnectionHandlerMonitorEntry.addMonitorAttribute(attrs, ATTR_PROTOCOL, MonitorMessages.INFO_CONNECTION_HANDLER_DISPNAME_PROTOCOL.get(), MonitorMessages.INFO_CONNECTION_HANDLER_DESC_PROTOCOL.get(), this.protocol);
        }
        if (!this.listeners.isEmpty()) {
            ConnectionHandlerMonitorEntry.addMonitorAttribute(attrs, ATTR_LISTENER, MonitorMessages.INFO_CONNECTION_HANDLER_DISPNAME_LISTENER.get(), MonitorMessages.INFO_CONNECTION_HANDLER_DESC_LISTENER.get(), this.listeners);
        }
        if (this.numConnections != null) {
            ConnectionHandlerMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_CONNECTIONS, MonitorMessages.INFO_CONNECTION_HANDLER_DISPNAME_NUM_CONNECTIONS.get(), MonitorMessages.INFO_CONNECTION_HANDLER_DESC_NUM_CONNECTIONS.get(), this.numConnections);
        }
        if (!this.connections.isEmpty()) {
            ConnectionHandlerMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTION, MonitorMessages.INFO_CONNECTION_HANDLER_DISPNAME_CONNECTION.get(), MonitorMessages.INFO_CONNECTION_HANDLER_DESC_CONNECTION.get(), this.connections);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

