/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLSwitch;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;

public abstract class XSLChooseOrSwitch
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected void prepareAttributes() {
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            this.checkUnknownAttribute(attName);
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        StyleElement fallback = null;
        for (NodeInfo nodeInfo : this.children()) {
            if (nodeInfo instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.otherwise.compileError("xsl:otherwise must come last", "XTSE0010");
                } else if (fallback != null) {
                    fallback.compileError("xsl:fallback must come last", "XTSE0010");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (nodeInfo instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    ((XSLOtherwise)nodeInfo).compileError("Only one xsl:otherwise is allowed in an " + this.getDisplayName(), "XTSE0010");
                    continue;
                }
                if (fallback != null) {
                    fallback.compileError("xsl:fallback must come last", "XTSE0010");
                    continue;
                }
                this.otherwise = (StyleElement)nodeInfo;
                continue;
            }
            if (nodeInfo instanceof XSLFallback && this instanceof XSLSwitch) {
                fallback = (XSLFallback)nodeInfo;
                continue;
            }
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).compileError("Only xsl:when and xsl:otherwise are allowed here", "XTSE0010");
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed within " + this.getDisplayName(), "XTSE0010");
        }
        if (this.numberOfWhens == 0) {
            this.compileError(this.getDisplayName() + " must contain at least one xsl:when", "XTSE0010");
        }
    }

    @Override
    protected boolean markTailCalls() {
        boolean found = false;
        for (NodeInfo nodeInfo : this.children(StyleElement.class::isInstance)) {
            found |= ((StyleElement)nodeInfo).markTailCalls();
        }
        return found;
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        int entries = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] conditions = new Expression[entries];
        Expression[] actions = new Expression[entries];
        this.compileActions(exec, decl, actions);
        this.compileConditions(exec, decl, conditions);
        Choose choose = new Choose(conditions, actions);
        choose.setInstruction(true);
        return choose;
    }

    protected abstract void compileConditions(Compilation var1, ComponentDeclaration var2, Expression[] var3);

    protected void compileActions(Compilation exec, ComponentDeclaration decl, Expression[] actions) throws XPathException {
        int w = 0;
        for (NodeInfo nodeInfo : this.children()) {
            if (!(nodeInfo instanceof XSLWhen) && !(nodeInfo instanceof XSLOtherwise)) continue;
            Expression b = ((StyleElement)nodeInfo).compileSequenceConstructor(exec, decl, true);
            if (b == null) {
                b = Literal.makeEmptySequence();
                b.setRetainedStaticContext(this.makeRetainedStaticContext());
            }
            try {
                actions[w] = b = b.simplify();
            }
            catch (XPathException e) {
                this.compileError(e);
            }
            XSLChooseOrSwitch.setInstructionLocation((StyleElement)nodeInfo, actions[w]);
            ++w;
        }
    }
}

