/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.FilePageCache;

@ApiStatus.Internal
public final class StorageLockContext {
    private static final FilePageCache ourDefaultCache = new FilePageCache();
    private final boolean myCheckThreadAccess;
    @NotNull
    private final ReentrantReadWriteLock myLock;
    @NotNull
    private final FilePageCache myFilePageCache;
    private final boolean myUseReadWriteLock;
    private final boolean myCacheChannels;

    public StorageLockContext(@NotNull FilePageCache filePageCache, boolean checkAccess, boolean useReadWriteLock, boolean cacheChannels) {
        if (filePageCache == null) {
            StorageLockContext.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myFilePageCache = filePageCache;
        this.myCheckThreadAccess = checkAccess;
        this.myUseReadWriteLock = useReadWriteLock;
        this.myCacheChannels = cacheChannels;
    }

    public StorageLockContext(boolean checkAccess, boolean useReadWriteLock) {
        this(ourDefaultCache, checkAccess, useReadWriteLock, false);
    }

    boolean useChannelCache() {
        return this.myCacheChannels;
    }

    public void lockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().lock();
        } else {
            this.myLock.writeLock().lock();
        }
    }

    public void unlockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().unlock();
        } else {
            this.myLock.writeLock().unlock();
        }
    }

    public void lockWrite() {
        this.myLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.myLock.writeLock().unlock();
    }

    @ApiStatus.Internal
    @NotNull
    FilePageCache getBufferCache() {
        FilePageCache filePageCache = this.myFilePageCache;
        if (filePageCache == null) {
            StorageLockContext.$$$reportNull$$$0(1);
        }
        return filePageCache;
    }

    @ApiStatus.Internal
    void checkThreadAccess(boolean read2) {
        if (this.myCheckThreadAccess) {
            if (read2) {
                if (this.myLock.getReadHoldCount() > 0 || this.myLock.writeLock().isHeldByCurrentThread()) {
                    return;
                }
                throw new IllegalStateException("Must hold StorageLock read lock to access PagedFileStorage");
            }
            if (this.myLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock write lock to access PagedFileStorage");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePageCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/StorageLockContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/StorageLockContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

