/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtIoFileSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingKt;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTreeParsingErrorListener;
import org.jetbrains.kotlin.fir.lightTree.LightTreeParsingErrorListenerKt;
import org.jetbrains.kotlin.fir.lightTree.converter.LightTreeRawFirDeclarationBuilder;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinLightParser;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "lightTree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "sourceFile", "Lorg/jetbrains/kotlin/KtSourceFile;", "linesMapping", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "code", "", "makeErrorListener", "Lorg/jetbrains/kotlin/fir/lightTree/LightTreeParsingErrorListener;", "Companion", "light-tree2fir"})
public final class LightTree2Fir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirScopeProvider scopeProvider;
    @Nullable
    private final DiagnosticReporter diagnosticsReporter;
    @NotNull
    private static final KotlinParserDefinition parserDefinition = new KotlinParserDefinition();

    public LightTree2Fir(@NotNull FirSession session2, @NotNull FirScopeProvider scopeProvider, @Nullable DiagnosticReporter diagnosticsReporter2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeProvider, (String)"scopeProvider");
        this.session = session2;
        this.scopeProvider = scopeProvider;
        this.diagnosticsReporter = diagnosticsReporter2;
    }

    public /* synthetic */ LightTree2Fir(FirSession firSession, FirScopeProvider firScopeProvider, DiagnosticReporter diagnosticReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            diagnosticReporter = null;
        }
        this(firSession, firScopeProvider, diagnosticReporter);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file2 = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return this.buildFirFile(file2);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtIoFileSourceFile sourceFile = new KtIoFileSourceFile(file2);
        InputStreamReader $this$buildFirFile_u24lambda_u240 = new InputStreamReader((InputStream)new FileInputStream(file2), Charsets.UTF_8);
        boolean bl = false;
        Pair<CharSequence, KtSourceFileLinesMapping> pair = KtSourceFileLinesMappingKt.readSourceFileWithMapping($this$buildFirFile_u24lambda_u240);
        CharSequence code = (CharSequence)pair.component1();
        KtSourceFileLinesMapping linesMapping = (KtSourceFileLinesMapping)pair.component2();
        return this.buildFirFile(code, (KtSourceFile)sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull FlyweightCapableTreeStructure<LighterASTNode> lightTree, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter(lightTree, (String)"lightTree");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)linesMapping, (String)"linesMapping");
        LightTreeRawFirDeclarationBuilder lightTreeRawFirDeclarationBuilder = new LightTreeRawFirDeclarationBuilder(this.session, this.scopeProvider, lightTree, null, 8, null);
        LighterASTNode lighterASTNode2 = lightTree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode2, (String)"getRoot(...)");
        return lightTreeRawFirDeclarationBuilder.convertFile(lighterASTNode2, sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull CharSequence code, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)linesMapping, (String)"linesMapping");
        LightTreeParsingErrorListener errorListener = this.makeErrorListener(sourceFile);
        FlyweightCapableTreeStructure<LighterASTNode> lightTree = Companion.buildLightTree(code, errorListener);
        return this.buildFirFile(lightTree, sourceFile, linesMapping);
    }

    private final LightTreeParsingErrorListener makeErrorListener(KtSourceFile sourceFile) {
        DiagnosticReporter diagnosticReporter = this.diagnosticsReporter;
        if (diagnosticReporter == null) {
            return null;
        }
        DiagnosticReporter diagnosticsReporter2 = diagnosticReporter;
        return LightTreeParsingErrorListenerKt.toKotlinParsingErrorListener(diagnosticsReporter2, sourceFile, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00140\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir$Companion;", "", "()V", "parserDefinition", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "buildLightTree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "code", "", "errorListener", "Lorg/jetbrains/kotlin/fir/lightTree/LightTreeParsingErrorListener;", "makeLexer", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "reportErrors", "", "node", "tree", "ref", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Ref;", "", "light-tree2fir"})
    public static final class Companion {
        private Companion() {
        }

        private final KotlinLexer makeLexer() {
            return new KotlinLexer();
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTree(@NotNull CharSequence code, @Nullable LightTreeParsingErrorListener errorListener) {
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)this.makeLexer(), code);
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
            PsiBuilder builder2 = psiBuilder;
            FlyweightCapableTreeStructure<LighterASTNode> it = flyweightCapableTreeStructure = KotlinLightParser.parse(builder2);
            boolean bl = false;
            if (errorListener != null) {
                LighterASTNode lighterASTNode2 = it.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode2, (String)"getRoot(...)");
                Intrinsics.checkNotNull(it);
                org.jetbrains.kotlin.fir.lightTree.LightTree2Fir$Companion.reportErrors$default(Companion, lighterASTNode2, it, errorListener, null, 8, null);
            }
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure2 = flyweightCapableTreeStructure;
            Intrinsics.checkNotNullExpressionValue(flyweightCapableTreeStructure2, (String)"also(...)");
            return flyweightCapableTreeStructure2;
        }

        private final void reportErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree, LightTreeParsingErrorListener errorListener, Ref<LighterASTNode[]> ref) {
            tree.getChildren(node, ref);
            LighterASTNode[] lighterASTNodeArray = ref.get();
            if (lighterASTNodeArray == null) {
                return;
            }
            for (LighterASTNode kid : lighterASTNodeArray) {
                if (kid == null) break;
                IElementType tokenType = kid.getTokenType();
                if (Intrinsics.areEqual((Object)tokenType, (Object)TokenType.ERROR_ELEMENT)) {
                    String message2 = PsiBuilderImpl.getErrorMessage(kid);
                    errorListener.onError(kid.getStartOffset(), kid.getEndOffset(), message2);
                }
                ref.set(null);
                this.reportErrors(kid, tree, errorListener, ref);
            }
        }

        static /* synthetic */ void reportErrors$default(Companion companion, LighterASTNode lighterASTNode2, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LightTreeParsingErrorListener lightTreeParsingErrorListener, Ref ref, int n, Object object) {
            if ((n & 8) != 0) {
                ref = new Ref<LighterASTNode[]>();
            }
            companion.reportErrors(lighterASTNode2, flyweightCapableTreeStructure, lightTreeParsingErrorListener, ref);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

