GRAP(1)                 FreeBSD General Commands Manual                GRAP(1)

[1mNAME[0m
     [1mgrap [22m-- Kernighan and Bentley's language for typesetting graphs

[1mSYNOPSIS[0m
     [1mgrap [22m[[1m-d [4m[22mdefines_file[24m] [[1m-D[22m] [[1m-l[22m] [[1m-M [4m[22minclude[24m [4mpath[24m] [[1m-R[22m] [[1m-r[22m] [[1m-v[22m] [[1m-u[22m]
          [[1m-C[22m] [[1m-c[22m] [[1m-h[22m] [[4mfilename[24m [4m...[24m]

[1mDESCRIPTION[0m
     [1mgrap [22mis an implementation of Kernighan and Bentley's language for type-
     setting graphs, as described in ``Grap-A Language for Typesetting Graphs,
     Tutorial and User Manual,'' by Jon L. Bentley and Brian W.  Kernighan,
     revised May 1991, which is the primary source for information on how to
     use [1mgrap[22m.  As of this writing, it is available electronically at
     http://www.kohala.com/start/troff/cstr114.ps.  Additional documentation
     and examples, packaged with [1mgrap[22m, may have been installed locally as
     well.  If available, paths to them can be displayed using [1mgrap -h [22mor [1mgrap[0m
     [1m-v [22m(or [1mgrap --help [22m/ [1mgrap --version[22m)

     This version is a black box implementation of [1mgrap[22m, and some inconsisten-
     cies are to be expected.  The remainder of this manual page will briefly
     outline the [1mgrap [22mlanguage as implemented here.

     [1mgrap [22mis a pic(1) pre-processor.  It takes commands embedded in a troff(1)
     source file which are surrounded by [1m.G1 [22mand [1m.G2 [22mmacros, and rewrites them
     into pic commands to display the graph.  Other lines are copied.  Output
     is always to the standard output, which is usually redirected.  Input is
     from the given [4mfilename[24ms, which are read in order.  A [4mfilename[24m of [1m- [22mis
     the standard input.  If no [4mfilename[24ms are given, input is read from the
     standard input.

     Because [1mgrap [22mis a pic preprocessor, and GNU pic will output TeX, it is
     possible to use [1mgrap [22mwith TeX.

     The [1m-d [22moption specifies a file of macro definitions to be read at
     startup, and defaults to /usr/local/share/grap/grap.defines .  The [1m-D[0m
     option inhibits the reading of any initial macros file (the [1m-l [22mflag is a
     synonym for [1m-D[22m, though I do not remember why).  The defines file can also
     be given using the GRAP_DEFINES environment variable. (See below).

     [1m-v [22mprints the version information on the standard output and exits.
     [1m--version [22mis a synonym for [1m-v[22m.

     [1m-u [22mmakes labels unaligned by default.  This version of [1mgrap [22muses new fea-
     tures of GNU pic to align the left and right labels with the axes, that
     is that the left and right labels run at right angles to the text of the
     paper.  This may be useful in porting old [1mgrap [22mprograms.  [1m-c [22mmakes plot
     strings unclipped by default.  Some versions of [1mgrap [22mallow users to place
     a string anywhere in the coordinate space, rather than only in the frame.
     By default this version of [1mgrap [22mdoes not plot any string centered outside
     the frame.  [1m-c [22mallows strings to be placed anywhere.  See also the
     [1mclipped [22mand [1munclipped [22mstring modifiers described in the [1mplot [22mstatement.

     [1m-M [22mis followed by a colon-separated list of directories used to search
     for relative pathnames included via [1mcopy[22m.  The path is also used to
     locate the defines file, so if the [1m-d [22mchanges the defines file name to a
     relative name, it will be searched for in the path given by [1m-M[22m.  The
     search path always includes the current directory, and by default that
     directory is searched last.

     All numbers used internally by [1mgrap [22mare double precision floating point
     values.  Sometimes using floating point numbers has unintended conse-
     quences.  To help avoid these problems, [1mgrap [22mcan use two thresholds for
     comparison of floating point numbers, set by [1m-R [22mor [1m-r[22m.  The [1m-R [22mflag sets
     coarse comparison mode, which is suitable for most applications.  If you
     are plotting small values - less than 1e-6 or so - consider using [1m-r[0m
     which uses very fine comparisons between numbers.  You may also want to
     rescale your plotted values to be larger in magnitude. The coarse
     comarisons are used by default.

     To be precise, the value by which two numbers must differ for [1mgrap [22mto
     consider them not equal is called the comparison limit and the smallest
     non-zero number is called the minimum value.  The values a given version
     of [1mgrap [22muses for these are included in the output of [1m-v [22mor [1m-h[22m.

     All [1mgrap [22mcommands are included between [1m.G1 [22mand [1m.G2 [22mmacros, which are con-
     sumed by [1mgrap[22m.  The output contains pic between [1m.PS [22mand [1m.PE [22mmacros.  Any
     arguments to the [1m.G1 [22mmacro in the input are arguments to the [1m.PS [22mmacro in
     the output, so graphs can be scaled just like pic diagrams.  If [1m-C [22mis
     given, any macro beginning with .G1 or .G2 is treated as a .G1 or .G2
     macro, for compatibility with old versions of troff.  Using [1m-C [22malso
     forces pure troff syntax on embedded font change commands when strings
     have the [1msize [22mattribute, and all strings to be [1munclipped[22m.

     The [1m-h [22mflag prints a brief help message and exits.  [1m--help [22mis a synonym
     for [1m-h[22m.

     It is possible for someone to cause [1mgrap [22mto fail by passing a bad format
     string and data to the [1msprintf [22mcommand.  If [1mgrap [22mis integrated as part of
     the printing system, this could conceivably provided a path to breaching
     security on the machine.  If you choose to use [1mgrap [22mas part of a printing
     system run by the super-user, you should disable [1msprintf [22mcommands.  This
     can be done by calling [1mgrap [22mwith the [1m-S [22mflag, setting the GRAP_SAFER
     environment variable, or compiling with the GRAP_SAFER preprocessor sym-
     bol defined.  (The GNU configure script included with [1mgrap [22mwill define
     that preprocessor symbol if the [1m--with-grap-safe [22moption is given.)

     The [1mgrap [22mcommands are sketched below.  Refer to Kernighan and Bentley's
     paper for the details.

     New versions of groff(1) will invoke [1mgrap [22mif [1m-G [22mis given.

   [1mCommands[0m
     Commands are separated from one another by newlines or semicolons (;).

     [1mframe [22m[[4mline_description[24m] [[1mht [4m[22mheight[24m | [1mwid [4m[22mwidth[24m] [[([1mtop[22m|[1mbottom[22m|[1mleft[22m|
     [1mright[22m) [4mline_description[24m] ...]

     [1mframe [22m[[1mht [4m[22mheight[24m | [1mwid [4m[22mwidth[24m] [[4mline_description[24m] [[([1mtop[22m|[1mbottom[22m|[1mleft[22m|
     [1mright[22m) [4mline_description[24m] ...]

           This   describes   how   the  axes  for  the  graph  are  drawn.  A
           [4mline_description[24m is a pic line description, e.g.,  dashed  0.5,  or
           the literal solid.  It may also include a [1mcolor [22mkeyword followed by
           the color to draw the string in double quotes.   Any  color  under-
           stood  by  the underlying groff system can be used.  Color can only
           be used under GNU pic, and is not available in compatibility  mode.
           Similarly,  for pic implementations that understand [1mthickness[22m, that
           attribute may be used with a real valued parameter.   [1mThickness  [22mis
           not available in compatibility mode.

           If  the  first  [4mline_description[24m  is given, the frame is drawn with
           that style.  The default is solid.  The height  and  width  of  the
           frame  can also be specified in inches.  The default line style can
           be over-ridden for sides of  the  frame  by  specifying  additional
           parameters to [1mframe[22m.

           If no plotting commands have been given before the [1mframe [22mcommand is
           issued, the frame will be output at  that  point  in  the  plotting
           stream  relative  to embedded troff or pic commands.  Otherwise the
           frame is output before the first  plotted  object  (even  invisible
           ones).

           [1mht [22mand [1mwid [22mare in inches by default, but can be any groff unit.  If
           omitted, the dimensions are 2 inches high by 3 inches wide.

     [1mcoord [22m[[4mname[24m] [[1mx [4m[22mexpr[24m, [4mexpr[24m] [[1my [4m[22mexpr[24m, [4mexpr[24m] [[1mlog x [22m| [1mlog y [22m| [1mlog log[22m]

           The [1mcoord [22mcommand specifies a new coordinate system or sets  limits
           on  the default system.  It defines the largest and smallest values
           that can be plotted, and therefore the scale of  the  data  in  the
           frame.   The limits for the x and y coordinate systems can be given
           separately.  If a [4mname[24m is given, that coordinate system is defined,
           if not the default system is modified.

           A coordinate system created by one [1mcoord [22mcommand may be modified by
           subsequent [1mcoord [22mcommands.  A [1mgrap [22mprogram may declare a coordinate
           space  using  [1mcoord[22m, [1mcopy [22ma file of data through a macro that plots
           the data and finds its maxima and minima, and then define the  size
           of the coordinate system with a second [1mcoord [22mstatement.

           This command also determines if a scale is plotted logarithmically.
           [1mlog log [22mmeans the same thing as [1mlog x log y[22m.

     [1mdraw [22m[[4mline_name[24m] [[4mline_description[24m] [[4mplot_string[24m]

           The [1mdraw [22mcommand defines the style with which a given line will  be
           plotted.   If [4mline_name[24m is given, the style is associated with that
           name, otherwise the default style is set.   [4mline_description[24m  is  a
           pic  line  description, and the optional [4mplot_string[24m is a string to
           be centered at each point.  The default line description is  invis,
           and the default plotting string is a centered bullet, so by default
           each point is a filled circle, and they are unconnected.  If points
           are  being  connected,  each [1mdraw [22mcommand ends any current line and
           begins a new one.

           When defining a line style, that is the first [1mdraw  [22mcommand  for  a
           given  line name, specifying no plot string means that there are to
           be no plot strings.  Omitting the plot string  on  subsequent  [1mdraw[0m
           commands  addressing  the  same  named line means not to change the
           plot string.  If a line has been defined with a  plot  string,  and
           the  format  is  changed  by  a subsequent [1mdraw [22mstatement, the plot
           string can be removed by specifying "" in the [1mdraw [22mstatement.

           The plot  string  can  have  its  format  changed  through  several
           string_modifiers.   String_modifiers  are described in the descrip-
           tion of the [1mplot [22mcommand.

           The standard defines file includes several macros  useful  as  plot
           strings, including [1mbullet[22m, [1msquare[22m, and [1mdelta[22m.

           [1mnew [22mis a synonym for [1mdraw[22m.

     [1mnext [22m[[4mline_name[24m] [1mat [22m[[4mcoordinates_name[24m] [4mexpr[24m, [4mexpr[24m [[4mline_description[24m]

           The  [1mnext  [22mcommand plots the given point using the line style given
           by [4mline_name[24m, or the default if none is  given.   If  [4mline_name[24m  is
           given,  it  should have been defined by an earlier [1mdraw [22mcommand, if
           not a new line style with that name  is  created,  initialized  the
           same  way  as  the  default  style.   The  two expressions give the
           point's x and y values, relative to the optional coordinate system.
           That  system  should have been defined by an earlier [1mcoord [22mcommand,
           if not, grap will exit.  If the optional [4mline_description[24m is given,
           it  overrides  the  style's  default  line description.  You cannot
           over-ride the plotting string.  To use a different plotting  string
           use the [1mplot [22mcommand.

           The  coordinates  may optionally be enclosed in parentheses: ([4mexpr[24m,
           [4mexpr[24m)

     [4mquoted_string[24m [[4mstring_modifiers[24m] [, [4mquoted_string[24m [[4mstring_modifiers[24m]] ...
     [1mat [22m[[4mcoordinates_name[24m] [4mexpr[24m, [4mexpr[0m

     [1mplot [4m[22mexpr[24m [[4mformat_string[24m] [1mat [22m[[4mcoordinates_name[24m] [4mexpr[24m, [4mexpr[0m

           These commands both plot a string at the given point.  In the first
           case the  literal  strings  are  stacked  above  each  other.   The
           string_modifiers  include  the  pic justification modifiers ([1mljust[22m,
           [1mrjust[22m, [1mabove[22m, and [1mbelow[22m), and absolute and relative size modifiers.
           See  the pic documentation for the description of the justification
           modifiers.  [1mgrap [22malso supports the [1maligned [22mand [1munaligned  [22mmodifiers
           which are briefly noted in the description of the [1mlabel [22mcommand.

           The  standard  defines  file includes several macros useful as plot
           strings, including [1mbullet[22m, [1msquare[22m, and [1mdelta[22m.

           Strings placed by either format of the [1mplot [22mcommand are  restricted
           to  being  within  the  frame.  This can be overridden by using the
           [1munclipped [22mattribute, which allows a string to be plotted in or  out
           of  the  frame.   The [1m-c [22mand [1m-C [22mflags set [1munclipped [22mon all strings,
           and to prevent a string from being plotted outside the  frame  when
           those flags are active, the [1mclipped [22mattribute can be used to retore
           clipping behavior.  Though [1mclipped [22mor [1munclipped [22mcan be  applied  to
           any string, it only has meaning for [1mplot [22mstatements.

           size [4mexpr[24m sets the string size to [4mexpr[24m points.  If [4mexpr[24m is preceded
           by a + or -, the size  is  increased  or  decreased  by  that  many
           points.

           If [1mcolor [22mand a color name in double quotes appears, the string will
           be rendered in that color under a version of GNU  troff  that  sup-
           ports color.  Color is not available in compatibility mode.

           In the second version, the [4mexpr[24m is converted to a string and placed
           on the graph.  [4mformat_string[24m is a printf(3)  format  string.   Only
           formatting  escapes for printing floating point numbers make sense.
           The format string is only respected if the [1msprintf [22mcommand is  also
           active.   See  the  description  of [1msprintf [22mfor the various ways to
           disable it.  [1mPlot [22mand [1msprintf [22mrespond differently when [1mgrap [22mis run-
           ning  safely.   [1mSprintf  [22mignores  any arguments, passing the format
           string through  without  substitution.   [1mplot  [22mignores  the  format
           string completely, plotting [4mexpr[24m using the "%g" format.

           Points  are  specified  the same way as for [1mnext [22mcommands, with the
           same consequences for undefined coordinate systems.

           The second form of this command is because the first  form  can  be
           used with a [1mgrap sprintf [22mexpression (See [4mExpressions[24m).

     [1mticks [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m)[ ([1min[22m|[1mout[22m) [[4mexpr[24m]] [[1mon|auto [4m[22mcoord_name[24m]

     [1mticks [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m) ([1min[22m|[1mout[22m) [[4mexpr[24m] [[1mup [4m[22mexpr[24m | [1mdown [4m[22mexpr[24m | [1mleft[0m
     [4mexpr[24m | [1mright [4m[22mexpr[24m] [1mat [22m[[4mcoord_name[24m] [4mexpr[24m [[4mformat_string[24m] [[, [4mexpr[0m
     [[4mformat_string[24m]] ...]

     [1mticks [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m) ([1min[22m|[1mout[22m) [[4mexpr[24m] [[1mup [4m[22mexpr[24m | [1mdown [4m[22mexpr[24m | [1mleft[0m
     [4mexpr[24m | [1mright [4m[22mexpr[24m] [1mfrom [22m[coord_name] [4mstart_expr[24m [1mto [4m[22mend_expr[24m [[1mby [22m[+|-|*|/]
     [4mby_expr[24m] [format_string]

     [1mticks [22m[[1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m] [1moff[0m

           This  command  controls  the  placement  of ticks on the frame.  By
           default, ticks are automatically generated on the left  and  bottom
           sides of the frame.

           The  first version of this command turns on the automatic tick gen-
           eration for a given side.  The [1min [22mor  [1mout  [22mparameter  controls  the
           direction  and  length of the ticks.  If a [4mcoord_name[24m is specified,
           the ticks are automatically generated using that coordinate system.
           If  no  system is specified, the default coordinate system is used.
           As with [1mnext [22mand [1mplot[22m,  the  coordinate  system  must  be  declared
           before  the  [1mticks  [22mstatement  that references it.  This syntax for
           requesting automatically generated ticks is an extension, and  will
           not port to older [1mgrap [22mimplementations.

           The  second  version  of  the [1mticks [22mcommand overrides the automatic
           placement of the ticks by specifying a list of coordinates at which
           to  place  the ticks.  If the ticks are not defined with respect to
           the default coordinate system, the  [4mcoord_name[24m  parameter  must  be
           given.  For each tick a printf(3) style format string can be given.
           The [4mformat_string[24m defaults to "%g".  The  format  string  can  also
           take  string  modifiers as described in the [1mplot [22mcommand.  To place
           ticks with no labels, specify [4mformat_string[24m as "".

           If [1msprintf [22mis disabled, [1mticks [22mbehaves as [1mplot [22mwith respect  to  the
           format string.

           The  labels  on  the ticks may be shifted by specifying a direction
           and the distance in inches  to  offset  the  label.   That  is  the
           optional direction and expression immediately preceding the [1mat[22m.

           The  third  format of the [1mticks [22mcommand over-rides the default tick
           generation with a set of ticks ar regular intervals.  The syntax is
           reminiscent  of  programming  language for loops.  Ticks are placed
           starting at [4mstart_expr[24m ending at [4mend_expr[24m one unit apart.   If  the
           [1mby [22mclause is specified, ticks are [4mby_expr[24m units apart.  If an oper-
           ator appears before [4mby_expr[24m each tick is operated on by that opera-
           tor instead of +.  For example

                       ticks left out from 2 to 32 by *2

           will  put ticks at 2, 4, 8, 16, and 32.  If [4mformat_string[24m is speci-
           fied, all ticks are formatted using it.

           The parameters preceding the [1mfrom [22mact as described above.

           The [1mat [22mand [1mfor [22mforms of tick command may both be issued on the same
           side of a frame.  For example:

                       ticks left out from 2 to 32 by *2
                       ticks left in 3, 5, 7

           will  put ticks on the left side of the frame pointing out at 2, 4,
           8, 16, and 32 and in at 3, 5, and 7.

           The final form of [1mticks [22mturns off ticks on a  given  side.   If  no
           side is given the ticks for all sides are cancelled.

           [1mtick [22mis a synonym for [1mticks[22m.

     [1mgrid [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m) [ticks off] [[4mline_description[24m] [[1mup [4m[22mexpr[24m |
     [1mdown [4m[22mexpr[24m | [1mleft [4m[22mexpr[24m | [1mright [4m[22mexpr[24m] [[1mon|auto [22m[[4mcoord_name[24m]]

     [1mgrid [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m) [ticks off] [[4mline_description[24m] [[1mup [4m[22mexpr[24m |
     [1mdown [4m[22mexpr[24m | [1mleft [4m[22mexpr[24m | [1mright [4m[22mexpr[24m] [1mat [22m[[4mcoord_name[24m] [4mexpr[24m [[4mformat_string[24m]
     [[, [4mexpr[24m [[4mformat_string[24m]] ...]

     [1mgrid [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m) [ticks off] [[4mline_description[24m] [[1mup [4m[22mexpr[24m |
     [1mdown [4m[22mexpr[24m | [1mleft [4m[22mexpr[24m | [1mright [4m[22mexpr[24m] [1mfrom [22m[coord_name] [4mstart_expr[24m [1mto[0m
     [4mend_expr[24m [[1mby [22m[+|-|*|/] [4mby_expr[24m] [format_string]

           The [1mgrid [22mcommand is similar to the [1mticks [22mcommand except  that  [1mgrid[0m
           specifies the placement of lines in the frame.  The syntax is simi-
           lar to [1mticks [22mas well.

           By specifying ticks off in the command, no ticks are drawn on  that
           side  of  the frame.  If ticks appear on a side by default, or have
           been declared by an earlier [1mticks [22mcommand,  [1mgrid  [22mdoes  not  cancel
           them unless ticks off is specified.

           Instead  of  a  direction for ticks, [1mgrid [22mallows the user to pick a
           line description for the grid lines.  The usual pic  line  descrip-
           tions are allowed.

           Grids  are labelled by default.  To omit labels, specify the format
           string as "".

           If [1msprintf [22mis disabled, [1mgrid [22mbehaves as [1mplot [22mwith  respect  to  the
           format string.

     [1mlabel [22m([1mleft[22m|[1mright[22m|[1mtop[22m|[1mbottom[22m) [4mquoted_string[24m [[4mstring_modifiers[24m] [,
     [4mquoted_string[24m [[4mstring_modifiers[24m]] ...  [[1mup [4m[22mexpr[24m | [1mdown [4m[22mexpr[24m | [1mleft [4m[22mexpr[24m |
     [1mright [4m[22mexpr[24m]

           The [1mlabel [22mcommand places a label on the given axis.  It is possible
           to specify several labels, which will be stacked over each other as
           in  pic.  The final argument, if present, specifies how many inches
           the label is shifted from the axis.

           By default the labels on the left and right labels run parallel  to
           the  frame.   You  can  cancel  this  by  specifying unaligned as a
           [4mstring_modifier[24m.

     [1mcircle at [22m[[4mcoordinate_name[24m] [4mexpr[24m, [4mexpr[24m [[1mradius [4m[22mexpr[24m] [[4mlinedesc[24m]

           This draws an circle at the point indicated.  By default, the  cir-
           cle  is small, 0.025 inches.  This can be over-ridden by specifying
           a radius.  The coordinates of the point are relative to  the  named
           coordinate system, or the default system if none is specified.

           This  command  has  been extended to take a line description, e.g.,
           dotted.  It also accepts the filling extensions described below  in
           the  [1mbar  [22mcommand.   It will also accept a [1mcolor [22mkeyword that gives
           the color of the outline of the  circle  in  double  quotes  and  a
           [1mfillcolor [22mcommand that sets the color to fill the circle with simi-
           larly.  Colors are only available when compatibility mode  is  off,
           and using a version of GNU pic that supports color.

     [1mline [22m[[4mline_description[24m] [1mfrom [22m[[4mcoordinate_name[24m] [4mexpr[24m, [4mexpr[24m [1mto[0m
     [[4mcoordinate_name[24m] [4mexpr[24m, [4mexpr[24m [[4mline_description[24m]

     [1marrow [22m[[4mline_description[24m] [1mfrom [22m[[4mcoordinate_name[24m] [4mexpr[24m, [4mexpr[24m [1mto[0m
     [[4mcoordinate_name[24m] [4mexpr[24m, [4mexpr[24m [[4mline_description[24m]

           This draws a line or arrow from the first point to the second using
           the  given  style.   The  default  line  style   is   solid.    The
           [4mline_description[24m  can  be given either before the [1mfrom [22mor after the
           [1mto [22mclause.  If both are given the second is used.  It  is  possible
           to  specify  one point in one coordinate system and one in another,
           note that if both points are in a named coordinate system (even  if
           they  are  in  the  same named coordinate system), both points must
           have [4mcoordinate_name[24m given.

     [1mcopy [22m["[4mfilename[24m"] [[1muntil [22m"[4mstring[24m"] [[1mthru [4m[22mmacro[24m]

           The [1mcopy [22mcommand imports data from another file  into  the  current
           graph.  The form with only a filename given is a simple file inclu-
           sion; the included file is simply read into the  input  stream  and
           can  contain arbitrary [1mgrap [22mcommands.  The more common case is that
           it is a number list; see [4mNumber[24m [4mLists[24m below.

           The second form takes lines from the file, splits them  into  words
           delimited  by  one  or  more spaces, and calls the given macro with
           those words as parameters.  The macro may either be  defined  here,
           or  be a macro defined earlier.  See [4mMacros[24m for more information on
           macros.

           The [4mfilename[24m may be omitted if the [1muntil [22mclause is present.  If  so
           the  current  file  is  treated  as  the input file until [4mstring[24m is
           encountered at the beginning of the line.

           [1mcopy [22mis one of the workhorses of [1mgrap[22m.  Check  out  the  paper  and
           [4m/usr/local/share/examples/grap[24m for more details.  Confirm the loca-
           tion of the examples directory using the [1m-v [22mflag.
     [1mprint [22m([4mexpr|string[24m)

           Prints its argument to the standard error.

     [1msh [4m[22mblock[0m

           This passes [4mblock[24m to sh(1).  Unlike K&B [1mgrap [22mno macro  or  variable
           expansion  is  done.   I believe that this is also true for GNU pic
           version 1.10.  See the [4mMacros[24m section for information  on  defining
           blocks.

     [1mpic [4m[22mpic_statement[0m

           This  issues the given pic statements  in the enclosing [1m.PS [22mand [1m.PE[0m
           at the point where the command is issued.

           Statements  that  begin  with  a  period  are  considered   to   be
           troff(statements)  and  are  output in the enclosing [1m.PS [22mand [1m.PE [22mat
           the point where the command appears.

           For the purposes of relative placement of pic  or  troff  commands,
           the frame is output immediately before the first plotted object, or
           the [1mframe [22mstatement, if any.  If the user specifies  pic  or  troff
           commands  and  neither any plotable object nor a [1mframe [22mcommand, the
           commands will not be output.

     [1mgraph [4m[22mName[24m [4mpic_commands[0m

           This command is used to position graphs with respect to each other.
           The  current  graph  is  given the pic name [4mName[24m (names used by pic
           begin with capital letters).  Any pic commands following the  graph
           are  used  to  position  the next graph.  The frame of the graph is
           available for use with pic name Frame. The following places a  sec-
           ond graph below the first:

                       graph Linear
                       [ graph description ]
                       graph Exponential with .Frame.n at \
                               Linear.Frame.s - (0, .05)
                       [ graph description ]

     [4mname[24m [4m=[24m [4mexpr[0m

           This  assigns  [4mexpr[24m  to  the  variable [4mname[24m.  [1mgrap [22mhas only numeric
           (double) variables.

           Assignment creates a variable if it does not exist.  Variables per-
           sist across graphs.  Assignments can cascade; a = b = 35 assigns 35
           to a and b.

     [1mbar [22m([1mup[22m|[1mright[22m) [[4mcoordinates_name[24m] [4moffset[24m [1mht [4m[22mheight[24m [[1mwid [4m[22mwidth[24m] [[1mbase[0m
     [4mbase_offset[24m] [[4mline_description[24m]

     [1mbar [22m[[4mcoordinates_name[24m] [4mexpr[24m, [4mexpr[24m, [[4mcoordinates_name[24m] [4mexpr[24m, [4mexpr[24m,
     [[4mline_description[24m]

           The [1mbar [22mcommand facilitates drawing bar graphs.  The first form  of
           the command describes the bar somewhat generally and has [1mgrap [22mplace
           it.  The bar may extend up or to the right, is centered  on  [4moffset[0m
           and  extends up or right [4mheight[24m units (in the given coordinate sys-
           tem).  For example

                       bar up 3 ht 2

           draws a 2 unit high bar sitting on the x axis, centered on x=3.  By
           default  bars are 1 unit wide, but this can be changed with the [1mwid[0m
           keyword.  By default bars sit on the base axis, i.e., bars directed
           up  will  extend from y=0.  That may be overridden by the [1mbase [22mkey-
           word.  (The bar described above has corners (2.5, 0) and (3.5, 2).)

           The  line description has been extended to include a [1mfill [4m[22mexpr[24m key-
           word that specifies the shading inside the bar.  Bars may be  drawn
           in  any  line style.  They support the [1mcolor [22mand [1mfillcolor [22mkeywords
           described under [1mcircle[22m.

           The second form of the command draws a box with the two  points  as
           corners.   This can be used to draw boxes highlighting certain data
           as well as bar graphs.  Note that filled bars will cover data drawn
           under them.

   [1mControl Flow[0m
     [1mif [4m[22mexpr[24m [1mthen [4m[22mblock[24m [[1melse [4m[22mblock[24m]

           The [1mif [22mstatement provides simple conditional execution.  If [4mexpr[24m is
           non-zero, the [4mblock[24m after the [1mthen [22mstatement is executed.   If  not
           the  [4mblock[24m  after the [1melse [22mis executed, if present.  See [4mMacros[24m for
           the definition of blocks.  Early versions of this implementation of
           [1mgrap [22mtreated the blocks as macros that were defined and expanded in
           place.  This led to unnecessary confusion because explicit  separa-
           tors  were sometimes called for.  Now, [1mgrap [22minserts a separator (;)
           after the last character in [4mblock[24m, so constructs like

           if (x == 3) { y = y + 1 }
           x = x + 1

           behave as expected.  A separator is also appended to the end  of  a
           [1mfor [22mblock.

     [1mfor [4m[22mname[24m [1mfrom [4m[22mfrom_expr[24m [1mto [4m[22mto_expr[24m [[1mby [22m[+|-|*|/] [4mby_expr[24m] [1mdo [4m[22mblock[0m

           This  command executes [4mblock[24m iteratively.  The variable [4mname[24m is set
           to [4mfrom_expr[24m and incremented by [4mby_expr[24m until it  exceeds  [4mto_expr[24m.
           The  iteration has the semantics defined in the [1mticks [22mcommand.  The
           definition of [4mblock[24m is discussed in  [4mMacros[24m.   See  also  the  note
           about implicit separators in the description of the [1mif [22mcommand.

           An [1m= [22mcan be used in place of [1mfrom[22m.

   [1mExpressions[0m
     [1mgrap [22msupports most standard arithmetic operators: + - / * ^.  The carat
     (^) is exponentiation.  In an [1mif [22mstatement [1mgrap [22malso supports the C logi-
     cal operators ==, !=, &&, || and unary !.  Also in an [1mif[22m, == and != are
     overloaded for the comparison of quoted strings.  Parentheses are used
     for grouping.

     Assignment is not allowed in an expression in any context, except for
     simple cascading of assignments.  a = b = 35 works as expected; a = 3.5 *
     (b = 10) does not execute.

     [1mgrap [22msupports the following functions that take one argument: [1mlog[22m, [1mexp[22m,
     [1mint[22m, [1msin[22m, [1mcos[22m, [1msqrt[22m, [1mrand[22m, [1mfloor[22m, [1mceil[22m.  The logarithms are base 10 and
     the trigonometric functions are in radians.  [1meexp [22mreturns Euler's number
     to the given power and [1mln [22mreturns the natural logarithm.  The natural
     log, exponentiation functions and floor and ceil are extensions and are
     probably not available in other [1mgrap [22mimplementations.

     [1mrand [22mreturns a random number uniformly distributed on [0,1).  The follow-
     ing two-argument functions are supported: [1matan2[22m, [1mmin[22m, [1mmax[22m.  [1matan2 [22mworks
     just like atan2(3).  The random number generator can be seeded by calling
     [1msrand [22mwith a single parameter (converted internally to an integer).
     Because its return value is of no use, you must use [1msrand [22mas a separate
     statement, it is not part of a valid expression.  [1msrand [22mis not portable.

     The [1mgetpid [22mfunction takes no arguments and returns the process id.  This
     may be used to seed the random number generator, but do not expect cryp-
     tographically random values to result.

     Other than string comparison, no expressions can use strings.  One string
     valued function exists: [1msprintf [22m([4mformat[24m, [[4mexpr[24m [[4m,[24m [4mexpr[24m]] ).  It operates
     like sprintf(3), except returning the value.  It can be used anywhere a
     quoted string is used.  If [1mgrap [22mis run with [1m-S[22m, the environment variable
     GRAP_SAFER is defined, or [1mgrap [22mhas been compiled for safer operation, the
     [1msprintf [22mcommand will return the format string.  This mode of operation is
     only intended to be used only if [1mgrap [22mis being used as part of a super-
     user enabled print system.

     [1mgrap [22mversion 1.44 and beyond support two functions for date and time
     manipulation, [1mstrptime [22mand [1mstrptime[22m.  [1mstrptime [22mparses a time using the
     strptime(3) function.  It takes two parameters, both strings, the format
     and a string to parse using that format and returns a number that can be
     sorted directly - the number of seconds since the UNIX epoch.  [1mstrftime[0m
     does the reverse.  It takes a string and a number and formats the number
     into a date.  In both functions, the format is the first parameter.  The
     formats are defined in the documentation for strftime(3).

   [1mMacros[0m
     [1mgrap [22mhas a simple but powerful macro facility.  Macros are defined using
     the [1mdefine [22mcommand :

     [1mdefine [4m[22mname[24m [4mblock[0m
     [1mundefine [4m[22mname[0m

           Every  occurrence  of  [4mname[24m  in the program text is replaced by the
           contents of [4mblock[24m.  [4mblock[24m is defined by a series of  statements  in
           nested { }'s, or a series of statements surrounded by the same let-
           ter.  An example of the latter is

                       define foo  X coord x 1,3 X
           Each time foo appears in the text, it will be replaced by  coord  x
           1,3.   Macros  are  literal,  and can contain newlines.  If a macro
           does not span multiple lines, it should end in a semicolon to avoid
           parsing errors.

           Macros  can take parameters, too.  If a macro call is followed by a
           parenthesized, comma-separated list the  values  starting  with  $1
           will  be  replaced in the macro with the elements of the list.  A $
           not followed by a digit is left unchanged.  This  parsing  is  very
           rudimentary;  no  nesting  or  parentheses or escaping of commas is
           allowed.  Also, there is no way to say argument  1  followed  by  a
           digit (${1}0 in sh(1)).

           The following will draw a line with slope 1.

                       define foo { next at $1, $2 }
                       for i from 1 to 5 { foo(i,i) }
           Macros       persist       across       graphs.       The      file
           [4m/usr/local/share/grap/grap.defines[24m contains simple macros for plot-
           ting common characters.  The [1mundefine [22mcommand deletes a macro.

           See  the directory [4m/usr/local/share/examples/grap[24m for more examples
           of macros.  Confirm the location of the  examples  directory  using
           the [1m-v [22mflag.

   [1mNumber Lists[0m
     A whitespace-separated list of numbers is treated specially.  The list is
     taken to be points to be plotted using the default line style on the
     default coordinate system.  If more than two numbers are given, the extra
     numbers are taken to be additional y values to plot at the first x value.
     Number lists in DWB [1mgrap [22mcan be comma-separated, and this [1mgrap [22msupports
     that as well.  More precisely, numbers in number lists can be separated
     by either whitespace, commas, or both.

           1 2 3
           4 5 6

     Will plot points using the default line style at (1,2), (1,3),(4,5) and
     (4,6).  A simple way to plot a set of numbers in a file named [4m./data[24m is:

           .G1
           copy "./data"
           .G2

   [1mPic Macros[0m
     [1mgrap [22mdefines pic macros that can be used in embedded pic code to place
     elements in the graph.  The macros are [1mx_gg[22m, [1my_gg[22m, and [1mxy_gg[22m.  These
     macros define pic distances that correspond to the given argument.  They
     can be used to size boxes or to plot pic constructs on the graph.  To
     place a given construct on the graph, you should add Frame.Origin to it.
     Other coordinate spaces can be used by replacing [1mgg [22mwith the name of the
     coordinate space.  A coordinate space named [1mgg [22mcannot be reliably
     accessed by these macros.

     The macros are emitted immediately before the frame is drawn.

     DWB [1mgrap [22mmay use these as part of its implementation.  This [1mgrap [22mprovides
     them only for compatibility.  Note that these are very simple macros, and
     may not do what you expect under complex conditions.

[1mENVIRONMENT VARIABLES[0m
     If the environment variable GRAP_DEFINES is defined, [1mgrap [22mwill look for
     its defines file there.  If that value is a relative path name the path
     specified in the [1m-M [22moption will be searched for it.  GRAP_DEFINES over-
     rides the compiled in location of the defines file, but may be overridden
     by the [1m-d [22mor [1m-D [22mflags.

     If GRAP_SAFER is set, [1msprintf [22mis disabled to prevent forcing [1mgrap [22mto core
     dump or smash the stack.

[1mFILES[0m
     [4m/usr/local/share/grap/grap.defines[0m

[1mSEE ALSO[0m
     atan2(3), groff(1), pic(1), printf(3), sh(1), sprintf(3), troff(1)

     If documentation and examples have been installed, [1mgrap --version [22mor [1mgrap[0m
     [1m--help [22mwill display the locations.

[1mBUGS[0m
     There are several small incompatibilities with K&R [1mgrap[22m.  They include
     the [1msh [22mcommand not expanding variables and macros, and a more strict
     adherence to parameter order in the internal commands.

     Although much improved, the error reporting code can still be confused.
     Notably, an error in a macro is not detected until the macro is used, and
     it produces unusual output in the error message.

     Iterating many times over a macro with no newlines can run [1mgrap [22mout of
     memory.

[1mAUTHOR[0m
     This implementation was done by Ted Faber <faber@lunabase.org>.  Bruce
     Lilly <blilly@erols.com> contributed many bug fixes, including a consid-
     erable revamp of the error reporting code.  If you can actually find an
     error in your [1mgrap [22mcode, you can probably thank him.  [1mgrap [22mwas designed
     and specified by Brian Kernighan and Jon Bentley.

FreeBSD 10.0                    March 11, 2006                    FreeBSD 10.0
