/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;

public class DequeMap<K, V> {
    private static final int DEFAULT_INITIAL_DEQUE_CAPACITY = 3;
    private static final int DEFAULT_INITIAL_MAP_CAPACITY = 3;
    private int dequeCapacity = 3;
    private final HashMap<K, ArrayDeque<V>> map;
    private int size = 0;

    public DequeMap() {
        this(3, 3);
    }

    public DequeMap(int initialMapCapacity, int initialDequeCapacity) {
        this.map = new HashMap(initialMapCapacity);
        this.dequeCapacity = initialDequeCapacity;
    }

    public void add(K key, V value) {
        ArrayDeque<Object> deque = this.map.get(key);
        if (deque == null) {
            deque = new ArrayDeque(this.dequeCapacity);
            deque.addFirst(value);
            this.map.put(key, deque);
            ++this.size;
        } else {
            if (deque.isEmpty()) {
                ++this.size;
            }
            deque.addFirst(value);
        }
    }

    public V get(K key) {
        Deque deque = this.map.get(key);
        if (deque == null) {
            return null;
        }
        return (V)deque.peekFirst();
    }

    public V remove(K key) {
        Deque deque = this.map.get(key);
        if (deque == null) {
            return null;
        }
        boolean wasEmpty = deque.isEmpty();
        Object result = deque.pollFirst();
        if (deque.isEmpty() && !wasEmpty) {
            assert (this.size > 0);
            --this.size;
        }
        return (V)result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

