/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jwt;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.security.PrivateKey;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jwt.JwtInfoKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jitsi/jwt/JwtInfo;", "", "privateKey", "Ljava/security/PrivateKey;", "kid", "", "issuer", "audience", "ttl", "Ljava/time/Duration;", "(Ljava/security/PrivateKey;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;)V", "getAudience", "()Ljava/lang/String;", "getIssuer", "getKid", "getPrivateKey", "()Ljava/security/PrivateKey;", "getTtl", "()Ljava/time/Duration;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "jicoco-jwt"})
public final class JwtInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final String kid;
    @NotNull
    private final String issuer;
    @NotNull
    private final String audience;
    @NotNull
    private final Duration ttl;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default((Object)Companion, null, null, (int)3, null);

    public JwtInfo(@NotNull PrivateKey privateKey, @NotNull String kid, @NotNull String issuer, @NotNull String audience, @NotNull Duration ttl) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        this.privateKey = privateKey;
        this.kid = kid;
        this.issuer = issuer;
        this.audience = audience;
        this.ttl = ttl;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final String getKid() {
        return this.kid;
    }

    @NotNull
    public final String getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final String getAudience() {
        return this.audience;
    }

    @NotNull
    public final Duration getTtl() {
        return this.ttl;
    }

    @NotNull
    public final PrivateKey component1() {
        return this.privateKey;
    }

    @NotNull
    public final String component2() {
        return this.kid;
    }

    @NotNull
    public final String component3() {
        return this.issuer;
    }

    @NotNull
    public final String component4() {
        return this.audience;
    }

    @NotNull
    public final Duration component5() {
        return this.ttl;
    }

    @NotNull
    public final JwtInfo copy(@NotNull PrivateKey privateKey, @NotNull String kid, @NotNull String issuer, @NotNull String audience, @NotNull Duration ttl) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        return new JwtInfo(privateKey, kid, issuer, audience, ttl);
    }

    public static /* synthetic */ JwtInfo copy$default(JwtInfo jwtInfo, PrivateKey privateKey, String string, String string2, String string3, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            privateKey = jwtInfo.privateKey;
        }
        if ((n & 2) != 0) {
            string = jwtInfo.kid;
        }
        if ((n & 4) != 0) {
            string2 = jwtInfo.issuer;
        }
        if ((n & 8) != 0) {
            string3 = jwtInfo.audience;
        }
        if ((n & 0x10) != 0) {
            duration = jwtInfo.ttl;
        }
        return jwtInfo.copy(privateKey, string, string2, string3, duration);
    }

    @NotNull
    public String toString() {
        return "JwtInfo(privateKey=" + this.privateKey + ", kid=" + this.kid + ", issuer=" + this.issuer + ", audience=" + this.audience + ", ttl=" + this.ttl + ")";
    }

    public int hashCode() {
        int result = this.privateKey.hashCode();
        result = result * 31 + this.kid.hashCode();
        result = result * 31 + this.issuer.hashCode();
        result = result * 31 + this.audience.hashCode();
        result = result * 31 + this.ttl.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JwtInfo)) {
            return false;
        }
        JwtInfo jwtInfo = (JwtInfo)other;
        if (!Intrinsics.areEqual((Object)this.privateKey, (Object)jwtInfo.privateKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kid, (Object)jwtInfo.kid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.issuer, (Object)jwtInfo.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.audience, (Object)jwtInfo.audience)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.ttl, (Object)jwtInfo.ttl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jitsi/jwt/JwtInfo$Companion;", "", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "fromConfig", "Lorg/jitsi/jwt/JwtInfo;", "jwtConfigObj", "Lcom/typesafe/config/ConfigObject;", "jicoco-jwt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JwtInfo fromConfig(@NotNull ConfigObject jwtConfigObj) {
            Intrinsics.checkNotNullParameter((Object)jwtConfigObj, (String)"jwtConfigObj");
            Config jwtConfig = jwtConfigObj.toConfig();
            logger.info((Object)("got jwtConfig: " + jwtConfig.root().render()));
            try {
                String string = jwtConfig.getString("signing-key-path");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                PrivateKey privateKey = JwtInfoKt.access$parseKeyFile(string);
                String string2 = jwtConfig.getString("kid");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String string3 = jwtConfig.getString("issuer");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                String string4 = jwtConfig.getString("audience");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                Duration duration = jwtConfig.getDuration("ttl");
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getDuration(...)");
                Duration duration2 = Duration.ofMinutes(10L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
                return new JwtInfo(privateKey, string2, string3, string4, JwtInfoKt.access$withMinimum(duration, duration2));
            }
            catch (Throwable t) {
                logger.info((Object)("Unable to create JwtInfo: " + t));
                throw t;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

