/*
 * Decompiled with CFR 0.152.
 */
package free.jin.seek;

import free.jin.Connection;
import free.jin.SeekConnection;
import free.jin.event.ConnectionListener;
import free.jin.event.SeekEvent;
import free.jin.event.SeekListener;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginContext;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.plugin.PluginUIListener;
import free.jin.seek.SoughtGraph;
import free.jin.seek.event.SeekSelectionEvent;
import free.jin.seek.event.SeekSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.net.URL;

public class SoughtGraphPlugin
extends Plugin
implements SeekListener,
SeekSelectionListener,
PluginUIListener,
ConnectionListener {
    protected SoughtGraph soughtGraph;
    protected PluginUIContainer soughtGraphContainer;

    public boolean setContext(PluginContext pluginContext) {
        if (!(pluginContext.getConnection() instanceof SeekConnection)) {
            return false;
        }
        return super.setContext(pluginContext);
    }

    public void start() {
        this.initSoughtGraph();
        this.registerListeners();
    }

    public void stop() {
        this.unregisterListeners();
    }

    protected void initSoughtGraph() {
        this.soughtGraphContainer = this.createContainer("", 1);
        this.soughtGraphContainer.setTitle(this.getI18n().getString("graphContainerTitle"));
        URL uRL = SoughtGraphPlugin.class.getResource("icon.gif");
        if (uRL != null) {
            this.soughtGraphContainer.setIcon(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        this.soughtGraphContainer.addPluginUIListener((PluginUIListener)this);
        this.soughtGraph = this.createSoughtGraph();
        Container container = this.soughtGraphContainer.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.soughtGraph, "Center");
    }

    protected SoughtGraph createSoughtGraph() {
        return new SoughtGraph(this);
    }

    public void pluginUIShown(PluginUIEvent pluginUIEvent) {
        SeekConnection seekConnection = (SeekConnection)this.getConn();
        seekConnection.getSeekListenerManager().addSeekListener((SeekListener)this);
    }

    public void pluginUIHidden(PluginUIEvent pluginUIEvent) {
        this.soughtGraph.removeAllSeeks();
        SeekConnection seekConnection = (SeekConnection)this.getConn();
        seekConnection.getSeekListenerManager().removeSeekListener((SeekListener)this);
    }

    public void pluginUIClosing(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIActivated(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIDeactivated(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIDisposed(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUITitleChanged(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIIconChanged(PluginUIEvent pluginUIEvent) {
    }

    protected void registerListeners() {
        this.soughtGraph.addSeekSelectionListener(this);
        this.getConn().getListenerManager().addConnectionListener((ConnectionListener)this);
    }

    protected void unregisterListeners() {
        SeekConnection seekConnection = (SeekConnection)this.getConn();
        this.soughtGraph.removeSeekSelectionListener(this);
        seekConnection.getSeekListenerManager().removeSeekListener((SeekListener)this);
        this.getConn().getListenerManager().removeConnectionListener((ConnectionListener)this);
    }

    public void seekAdded(SeekEvent seekEvent) {
        this.soughtGraph.addSeek(seekEvent.getSeek());
    }

    public void seekRemoved(SeekEvent seekEvent) {
        this.soughtGraph.removeSeek(seekEvent.getSeek());
    }

    public void seekSelected(SeekSelectionEvent seekSelectionEvent) {
        ((SeekConnection)this.getConn()).acceptSeek(seekSelectionEvent.getSeek());
    }

    public void connectionLost(Connection connection) {
        this.soughtGraph.removeAllSeeks();
    }

    public void connectingFailed(Connection connection, String string) {
    }

    public void connectionAttempted(Connection connection, String string, int n) {
    }

    public void connectionEstablished(Connection connection) {
    }

    public void loginFailed(Connection connection, String string) {
    }

    public void loginSucceeded(Connection connection) {
    }

    public String getId() {
        return "seek";
    }

    public String getName() {
        return this.getI18n().getString("pluginName");
    }
}

