/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board.prefs;

import free.chess.BoardPainter;
import free.chess.ColoredBoardPainter;
import free.chess.ColoredPiecePainter;
import free.chess.PiecePainter;
import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.board.BoardManager;
import free.jin.board.BoardPattern;
import free.jin.board.JinBoard;
import free.jin.board.PieceSet;
import free.jin.board.prefs.BoardModifyingPrefsPanel;
import free.util.AWTUtilities;
import free.util.TableLayout;
import free.util.swing.ColorChooser;
import free.util.swing.PreferredSizedPanel;
import free.util.swing.UrlDisplayingAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BoardLooksPanel
extends BoardModifyingPrefsPanel {
    protected final JList pieceSets;
    protected final ColorChooser whiteColor;
    protected final ColorChooser blackColor;
    protected final ColorChooser whiteOutline;
    protected final ColorChooser blackOutline;
    protected final JList boardPatterns;
    protected final ColorChooser darkSquares;
    protected final ColorChooser lightSquares;
    private Container pieceColorsPanel;
    private Container boardColorsPanel;

    public BoardLooksPanel(BoardManager boardManager, JinBoard jinBoard) {
        super(boardManager, jinBoard);
        I18n i18n = I18n.get((Class)BoardLooksPanel.class);
        this.pieceSets = new JList<PieceSet>(this.getPieceSets());
        this.boardPatterns = new JList<BoardPattern>(this.getBoardPatterns());
        this.whiteColor = i18n.createColorChooser("whiteColorChooser");
        this.blackColor = i18n.createColorChooser("blackColorChooser");
        this.whiteOutline = i18n.createColorChooser("whiteOutlineChooser");
        this.blackOutline = i18n.createColorChooser("blackOutlineChooser");
        this.darkSquares = i18n.createColorChooser("darkSquaresChooser");
        this.lightSquares = i18n.createColorChooser("lightSquaresChooser");
        this.whiteColor.setColor(boardManager.getWhitePieceColor());
        this.blackColor.setColor(boardManager.getBlackPieceColor());
        this.whiteOutline.setColor(boardManager.getWhiteOutlineColor());
        this.blackOutline.setColor(boardManager.getBlackOutlineColor());
        this.darkSquares.setColor(boardManager.getDarkSquareColor());
        this.lightSquares.setColor(boardManager.getLightSquareColor());
        JComponent jComponent = this.createPiecesUI();
        JComponent jComponent2 = this.createBoardUI();
        this.pieceSets.setSelectionMode(0);
        this.boardPatterns.setSelectionMode(0);
        this.pieceSets.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PieceSet pieceSet = (PieceSet)BoardLooksPanel.this.pieceSets.getSelectedValue();
                PiecePainter piecePainter = pieceSet.getPiecePainter();
                if (piecePainter instanceof ColoredPiecePainter) {
                    ColoredPiecePainter coloredPiecePainter = (ColoredPiecePainter)piecePainter;
                    coloredPiecePainter.setWhiteColor(BoardLooksPanel.this.whiteColor.getColor());
                    coloredPiecePainter.setBlackColor(BoardLooksPanel.this.blackColor.getColor());
                    coloredPiecePainter.setWhiteOutline(BoardLooksPanel.this.whiteOutline.getColor());
                    coloredPiecePainter.setBlackOutline(BoardLooksPanel.this.blackOutline.getColor());
                }
                BoardLooksPanel.this.previewBoard.setPiecePainter(piecePainter);
                AWTUtilities.setContainerEnabled((Container)BoardLooksPanel.this.pieceColorsPanel, (boolean)(piecePainter instanceof ColoredPiecePainter));
                BoardLooksPanel.this.fireStateChanged();
            }
        });
        this.boardPatterns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BoardPattern boardPattern = (BoardPattern)BoardLooksPanel.this.boardPatterns.getSelectedValue();
                BoardPainter boardPainter = boardPattern.getBoardPainter();
                if (boardPainter instanceof ColoredBoardPainter) {
                    ColoredBoardPainter coloredBoardPainter = (ColoredBoardPainter)boardPainter;
                    coloredBoardPainter.setDarkColor(BoardLooksPanel.this.darkSquares.getColor());
                    coloredBoardPainter.setLightColor(BoardLooksPanel.this.lightSquares.getColor());
                }
                BoardLooksPanel.this.previewBoard.setBoardPainter(boardPainter);
                AWTUtilities.setContainerEnabled((Container)BoardLooksPanel.this.boardColorsPanel, (boolean)(boardPainter instanceof ColoredBoardPainter));
                BoardLooksPanel.this.fireStateChanged();
            }
        });
        this.pieceSets.setSelectedValue(boardManager.getPieceSet(), true);
        this.boardPatterns.setSelectedValue(boardManager.getBoardPattern(), true);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColoredPiecePainter coloredPiecePainter = (ColoredPiecePainter)BoardLooksPanel.this.previewBoard.getPiecePainter();
                coloredPiecePainter.setWhiteColor(BoardLooksPanel.this.whiteColor.getColor());
                coloredPiecePainter.setBlackColor(BoardLooksPanel.this.blackColor.getColor());
                coloredPiecePainter.setWhiteOutline(BoardLooksPanel.this.whiteOutline.getColor());
                coloredPiecePainter.setBlackOutline(BoardLooksPanel.this.blackOutline.getColor());
                BoardLooksPanel.this.previewBoard.repaint();
                BoardLooksPanel.this.fireStateChanged();
            }
        };
        this.whiteColor.addChangeListener(changeListener);
        this.blackColor.addChangeListener(changeListener);
        this.whiteOutline.addChangeListener(changeListener);
        this.blackOutline.addChangeListener(changeListener);
        ChangeListener changeListener2 = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColoredBoardPainter coloredBoardPainter = (ColoredBoardPainter)BoardLooksPanel.this.previewBoard.getBoardPainter();
                coloredBoardPainter.setDarkColor(BoardLooksPanel.this.darkSquares.getColor());
                coloredBoardPainter.setLightColor(BoardLooksPanel.this.lightSquares.getColor());
                BoardLooksPanel.this.previewBoard.repaint();
                BoardLooksPanel.this.fireStateChanged();
            }
        };
        this.darkSquares.addChangeListener(changeListener2);
        this.lightSquares.addChangeListener(changeListener2);
        JButton jButton = null;
        if (Jin.getInstance().isUserExtensible()) {
            jButton = i18n.createButton("downloadExtrasButton");
            jButton.addActionListener((ActionListener)new UrlDisplayingAction("http://www.jinchess.com/extras/"));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jComponent2.setAlignmentX(0.5f);
        if (jButton != null) {
            jButton.setAlignmentX(0.5f);
        }
        jPanel.add(jComponent2);
        if (jButton != null) {
            jPanel.add(Box.createVerticalStrut(15));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(15));
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("West", jComponent);
        jPanel2.add("Center", Box.createHorizontalStrut(10));
        jPanel2.add("East", jPanel);
        JLabel jLabel = new JLabel(i18n.getString("colorsNotice"));
        jPanel2.setAlignmentX(0.0f);
        jLabel.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        this.add(jPanel2);
        this.add(Box.createVerticalStrut(10));
        this.add(jLabel);
    }

    private PieceSet[] getPieceSets() {
        Map map = this.boardManager.getResources("pieces");
        PieceSet[] pieceSetArray = map.values().toArray(new PieceSet[0]);
        Collections.sort(Arrays.asList(pieceSetArray), new Comparator(){

            public int compare(Object object, Object object2) {
                PieceSet pieceSet = (PieceSet)object;
                PieceSet pieceSet2 = (PieceSet)object2;
                return pieceSet.getName().compareTo(pieceSet2.getName());
            }
        });
        return pieceSetArray;
    }

    private BoardPattern[] getBoardPatterns() {
        Map map = this.boardManager.getResources("boards");
        BoardPattern[] boardPatternArray = map.values().toArray(new BoardPattern[0]);
        Collections.sort(Arrays.asList(boardPatternArray), new Comparator(){

            public int compare(Object object, Object object2) {
                BoardPattern boardPattern = (BoardPattern)object;
                BoardPattern boardPattern2 = (BoardPattern)object2;
                return boardPattern.getName().compareTo(boardPattern2.getName());
            }
        });
        return boardPatternArray;
    }

    public void initPreviewBoard() {
        ColoredPiecePainter coloredPiecePainter;
        Object object;
        PieceSet pieceSet = (PieceSet)this.pieceSets.getSelectedValue();
        if (pieceSet != null) {
            object = pieceSet.getPiecePainter();
            if (object instanceof ColoredPiecePainter) {
                coloredPiecePainter = (ColoredPiecePainter)object;
                coloredPiecePainter.setWhiteColor(this.whiteColor.getColor());
                coloredPiecePainter.setBlackColor(this.blackColor.getColor());
                coloredPiecePainter.setWhiteOutline(this.whiteOutline.getColor());
                coloredPiecePainter.setBlackOutline(this.blackOutline.getColor());
            }
            this.previewBoard.setPiecePainter((PiecePainter)object);
        }
        if ((object = (BoardPattern)this.boardPatterns.getSelectedValue()) != null) {
            coloredPiecePainter = ((BoardPattern)object).getBoardPainter();
            if (coloredPiecePainter instanceof ColoredBoardPainter) {
                ColoredBoardPainter coloredBoardPainter = (ColoredBoardPainter)coloredPiecePainter;
                coloredBoardPainter.setDarkColor(this.darkSquares.getColor());
                coloredBoardPainter.setLightColor(this.lightSquares.getColor());
            }
            this.previewBoard.setBoardPainter((BoardPainter)coloredPiecePainter);
        }
    }

    private JComponent createPiecesUI() {
        I18n i18n = I18n.get((Class)BoardLooksPanel.class);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("piecesPanel"), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        JLabel jLabel = i18n.createLabel("pieceSetLabel");
        jLabel.setLabelFor(this.pieceSets);
        jLabel.setAlignmentX(0.0f);
        JScrollPane jScrollPane = new JScrollPane(this.pieceSets, 22, 31);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel((LayoutManager)new TableLayout(1, 0, 5));
        preferredSizedPanel.setAlignmentX(0.0f);
        preferredSizedPanel.add((Component)this.whiteColor);
        preferredSizedPanel.add((Component)this.blackColor);
        preferredSizedPanel.add((Component)this.whiteOutline);
        preferredSizedPanel.add((Component)this.blackOutline);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add((Component)preferredSizedPanel);
        this.pieceColorsPanel = preferredSizedPanel;
        return jPanel;
    }

    private JComponent createBoardUI() {
        I18n i18n = I18n.get((Class)BoardLooksPanel.class);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("boardPanel"), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        JLabel jLabel = i18n.createLabel("boardPatternLabel");
        jLabel.setLabelFor(this.boardPatterns);
        jLabel.setAlignmentX(0.0f);
        JScrollPane jScrollPane = new JScrollPane(this.boardPatterns, 22, 31);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel((LayoutManager)new TableLayout(1, 0, 5));
        preferredSizedPanel.setAlignmentX(0.0f);
        preferredSizedPanel.add((Component)this.darkSquares);
        preferredSizedPanel.add((Component)this.lightSquares);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add((Component)preferredSizedPanel);
        this.boardColorsPanel = preferredSizedPanel;
        return jPanel;
    }

    public void applyChanges() throws BadChangesException {
        this.boardManager.setPieceSet((PieceSet)this.pieceSets.getSelectedValue());
        this.boardManager.setBoardPattern((BoardPattern)this.boardPatterns.getSelectedValue());
        this.boardManager.setWhitePieceColor(this.whiteColor.getColor());
        this.boardManager.setBlackPieceColor(this.blackColor.getColor());
        this.boardManager.setWhiteOutlineColor(this.whiteOutline.getColor());
        this.boardManager.setBlackOutlineColor(this.blackOutline.getColor());
        this.boardManager.setDarkSquareColor(this.darkSquares.getColor());
        this.boardManager.setLightSquareColor(this.lightSquares.getColor());
    }
}

