/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0002\u0002\u001d\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t!A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!A\u0002+ie\u0016\fG\r\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\t9\fW.Z\u000b\u0002/A\u0011\u0001$\t\b\u00033}\u0001\"AG\u000f\u000e\u0003mQ!\u0001\b\u0004\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001j\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u000b9\fW.\u001a\u0011\t\u0011\u001d\u0002!Q1A\u0005\u0002!\nq\"[:J]R,'O];qi&\u0014G.Z\u000b\u0002SA\u0011!fK\u0007\u0002;%\u0011A&\b\u0002\b\u0005>|G.Z1o\u0011!q\u0003A!A!\u0002\u0013I\u0013\u0001E5t\u0013:$XM\u001d:vaRL'\r\\3!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q\u0019!g\r\u001b\u0011\u0005E\u0001\u0001\"B\u000b0\u0001\u00049\u0002bB\u00140!\u0003\u0005\r!\u000b\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0003E\u0019\b.\u001e;e_^t\u0017J\\5uS\u0006$X\rZ\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u000bG>t7-\u001e:sK:$(BA\u001f\r\u0003\u0011)H/\u001b7\n\u0005}R$AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001d\u0002%MDW\u000f\u001e3po:Le.\u001b;jCR,G\r\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u00038\u0003A\u0019\b.\u001e;e_^t7i\\7qY\u0016$X\r\u0003\u0004F\u0001\u0001\u0006I\u0001O\u0001\u0012g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016\u0004\u0003\"B$\u0001\t\u0003A\u0015\u0001C:ikR$wn\u001e8\u0015\u0003%\u0003\"A\u000b&\n\u0005-k\"\u0001B+oSRDQ!\u0014\u0001\u0005\u0002!\n!#[:TQV$Hm\\<o\u0007>l\u0007\u000f\\3uK\")q\n\u0001C\u0001!\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c\u000b\u0002S!)!\u000b\u0001C\u0001\u0011\u0006i\u0011m^1jiNCW\u000f\u001e3po:DQ\u0001\u0016\u0001\u0005\u0002U\u000bQ\u0001]1vg\u0016$2!\u0013,\\\u0011\u001596\u000b1\u0001Y\u0003\u001d!\u0018.\\3pkR\u0004\"AK-\n\u0005ik\"\u0001\u0002'p]\u001eDQ\u0001X*A\u0002u\u000bA!\u001e8jiB\u0011\u0011HX\u0005\u0003?j\u0012\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\u0006C\u00021\t\u0001S\u0001\u0007I><vN]6\t\u000b\r\u0004A\u0011\t%\u0002\u0007I,h\u000eC\u0003f\u0001\u0011\u0005\u0001&A\u0005jgJ+hN\\5oO\u001e9qMAA\u0001\u0012\u0003A\u0017AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"!E5\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001UN\u0011\u0011n\u001b\t\u0003U1L!!\\\u000f\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0001\u0014\u000e\"\u0001p)\u0005A\u0007bB9j#\u0003%\tA]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003MT#!\u000b;,\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0013Ut7\r[3dW\u0016$'B\u0001>\u001e\u0003)\tgN\\8uCRLwN\\\u0005\u0003y^\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public abstract class ShutdownableThread
extends Thread
implements Logging {
    private final String name;
    private final boolean isInterruptible;
    private final CountDownLatch shutdownInitiated;
    private final CountDownLatch shutdownComplete;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return ShutdownableThread$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ShutdownableThread shutdownableThread = this;
        synchronized (shutdownableThread) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public boolean isInterruptible() {
        return this.isInterruptible;
    }

    private CountDownLatch shutdownInitiated() {
        return this.shutdownInitiated;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    public void shutdown() {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete().getCount() == 0L;
    }

    public synchronized boolean initiateShutdown() {
        boolean bl;
        if (this.isRunning()) {
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutting down");
            this.shutdownInitiated().countDown();
            if (this.isInterruptible()) {
                this.interrupt();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutdown completed");
    }

    public void pause(long timeout, TimeUnit unit) {
        block0: {
            if (!this.shutdownInitiated().await(timeout, unit)) break block0;
            this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "shutdownInitiated latch count reached zero. Shutdown called.");
        }
    }

    public abstract void doWork();

    @Override
    public void run() {
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Starting");
        try {
            try {
                while (this.isRunning()) {
                    this.doWork();
                }
            }
            catch (FatalExitError e) {
                this.shutdownInitiated().countDown();
                this.shutdownComplete().countDown();
                this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stopped");
                throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
            }
            catch (Throwable e) {
                if (this.isRunning()) {
                    this.error((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Error due to", (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> e);
                }
            }
        }
        finally {
            this.shutdownComplete().countDown();
        }
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stopped");
    }

    public boolean isRunning() {
        return this.shutdownInitiated().getCount() != 0L;
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        this.name = name;
        this.isInterruptible = isInterruptible;
        super(name);
        Logging.$init$(this);
        this.setDaemon(false);
        this.logIdent_$eq("[" + name + "]: ");
        this.shutdownInitiated = new CountDownLatch(1);
        this.shutdownComplete = new CountDownLatch(1);
    }
}

