/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjSlice;

public class VSlice
extends ClosedShape {
    public int[] xpcoords;
    public int[] ypcoords;
    public static final double RAD2DEG_FACTOR = 57.29577951308232;
    public static final double DEG2RAD_FACTOR = Math.PI / 180;
    public LongPoint p1 = new LongPoint(0L, 0L);
    public LongPoint p2 = new LongPoint(0L, 0L);
    public LongPoint p3 = new LongPoint(0L, 0L);
    public LongPoint p4 = new LongPoint(0L, 0L);
    public long vr;
    public double angle;
    public double orient;
    public int angleDeg;
    public int orientDeg;
    public ProjSlice[] pc;

    public VSlice() {
        this.initCoordArray(3);
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.p1 = new LongPoint(10L, 10L);
        this.p2 = new LongPoint(-10L, 10L);
        this.computeSize();
        this.computeOrient();
        this.computeAngle();
        this.computePolygonEdges();
        this.setColor(Color.WHITE);
        this.setBorderColor(Color.BLACK);
    }

    public VSlice(LongPoint[] v, int z, Color c, Color bc) {
        this.initCoordArray(3);
        this.vx = v[0].x;
        this.vy = v[0].y;
        this.vz = z;
        this.p1 = v[1];
        this.p2 = v[2];
        this.computeSize();
        this.computeOrient();
        this.computeAngle();
        this.computePolygonEdges();
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public VSlice(long x, long y, int z, long vs, double ag, double or, Color c, Color bc) {
        this.initCoordArray(3);
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = vs;
        this.vr = vs;
        this.orient = or;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
        this.angle = ag;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
        this.computeSliceEdges();
        this.computePolygonEdges();
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public VSlice(long x, long y, int z, long vs, int ag, int or, Color c, Color bc) {
        this.initCoordArray(3);
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = vs;
        this.vr = vs;
        this.orient = (double)or * (Math.PI / 180);
        this.orientDeg = or;
        this.angle = (double)ag * (Math.PI / 180);
        this.angleDeg = ag;
        this.computeSliceEdges();
        this.computePolygonEdges();
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCoordArray(int n) {
        this.xpcoords = new int[n];
        this.ypcoords = new int[n];
    }

    public void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.p1.x - this.vx, 2.0) + Math.pow(this.p1.y - this.vy, 2.0));
        this.vr = Math.round(this.size);
    }

    public void computeOrient() {
        double c = Math.sqrt(Math.pow(this.p1.x - this.vx, 2.0) + Math.pow(this.p1.y - this.vy, 2.0));
        double a1 = this.p1.y - this.vy >= 0L ? Math.acos((double)(this.p1.x - this.vx) / c) : Math.PI * 2 - Math.acos((double)(this.p1.x - this.vx) / c);
        double a2 = this.p2.y - this.vy >= 0L ? Math.acos((double)(this.p2.x - this.vx) / c) : Math.PI * 2 - Math.acos((double)(this.p2.x - this.vx) / c);
        this.orient = (a1 + a2) / 2.0;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
    }

    public void computeAngle() {
        double c = Math.sqrt(Math.pow(this.p1.x - this.vx, 2.0) + Math.pow(this.p1.y - this.vy, 2.0));
        double a1 = this.p1.y - this.vy >= 0L ? Math.acos((double)(this.p1.x - this.vx) / c) : Math.PI * 2 - Math.acos((double)(this.p1.x - this.vx) / c);
        double a2 = this.p2.y - this.vy >= 0L ? Math.acos((double)(this.p2.x - this.vx) / c) : Math.PI * 2 - Math.acos((double)(this.p2.x - this.vx) / c);
        this.angle = a2 - a1;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
    }

    public void computeSliceEdges() {
        this.p1.x = Math.round(Math.cos(this.orient - this.angle / 2.0) * (double)this.size) + this.vx;
        this.p1.y = Math.round(Math.sin(this.orient - this.angle / 2.0) * (double)this.size) + this.vy;
        this.p2.x = Math.round(Math.cos(this.orient + this.angle / 2.0) * (double)this.size) + this.vx;
        this.p2.y = Math.round(Math.sin(this.orient + this.angle / 2.0) * (double)this.size) + this.vy;
    }

    public void computePolygonEdges() {
        if (this.angle < Math.PI) {
            this.p3.x = this.vx + Math.round((double)(this.p1.x - this.vx) / Math.cos(this.angle / 2.0));
            this.p3.y = this.vy + Math.round((double)(this.p1.y - this.vy) / Math.cos(this.angle / 2.0));
            this.p4.x = this.vx + Math.round((double)(this.p2.x - this.vx) / Math.cos(this.angle / 2.0));
            this.p4.y = this.vy + Math.round((double)(this.p2.y - this.vy) / Math.cos(this.angle / 2.0));
        } else if (this.angle > Math.PI) {
            this.p3.x = this.vx - Math.round((double)(this.p1.x - this.vx) / Math.cos(this.angle / 2.0));
            this.p3.y = this.vy - Math.round((double)(this.p1.y - this.vy) / Math.cos(this.angle / 2.0));
            this.p4.x = this.vx - Math.round((double)(this.p2.x - this.vx) / Math.cos(this.angle / 2.0));
            this.p4.y = this.vy - Math.round((double)(this.p2.y - this.vy) / Math.cos(this.angle / 2.0));
        } else {
            this.p3.x = this.p1.x;
            this.p3.y = this.p1.y;
            this.p4.x = this.p2.x;
            this.p4.y = this.p2.y;
        }
    }

    public void initCams(int nbCam) {
        this.pc = new ProjSlice[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjSlice();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjSlice[] ta = this.pc;
                this.pc = new ProjSlice[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjSlice();
            } else {
                System.err.println("VSlice:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjSlice[1];
            this.pc[0] = new ProjSlice();
        } else {
            System.err.println("VSlice:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public void sizeTo(float sz) {
        this.size = sz;
        this.vr = Math.round(this.size);
        this.computeSliceEdges();
        this.computePolygonEdges();
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vr = Math.round(this.size);
        this.computeSliceEdges();
        this.computePolygonEdges();
    }

    public void orientTo(float ag) {
        this.orient = (double)ag > Math.PI * 2 ? (double)ag % (Math.PI * 2) : (double)ag;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
        this.computeSliceEdges();
        this.computePolygonEdges();
    }

    public void setAngle(double ag) {
        this.angle = ag > Math.PI * 2 ? ag % (Math.PI * 2) : ag;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
        this.computeSliceEdges();
        this.computePolygonEdges();
    }

    public double getAngle() {
        return this.angle;
    }

    public float getSize() {
        return this.size;
    }

    public float getOrient() {
        return (float)this.orient;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return Math.sqrt(Math.pow(jpx - this.pc[camIndex].cx, 2.0) + Math.pow(jpy - this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].outerCircleRadius && (this.angle < Math.PI && this.pc[camIndex].boundingPolygon.contains(jpx, jpy) || this.angle > Math.PI && !this.pc[camIndex].boundingPolygon.contains(jpx, jpy) || this.angle == Math.PI && this.coordInsideHemisphere(jpx, jpy, camIndex));
    }

    public boolean coordInsideHemisphere(int x, int y, int camIndex) {
        if (this.orient == 0.0) {
            return x >= this.pc[camIndex].cx;
        }
        if (this.orient == Math.PI) {
            return x <= this.pc[camIndex].cx;
        }
        double a = (this.pc[camIndex].p2y - this.pc[camIndex].p1y) / (this.pc[camIndex].p2x - this.pc[camIndex].p1x);
        double b = (this.pc[camIndex].p1y * this.pc[camIndex].p2x - this.pc[camIndex].p2y * this.pc[camIndex].p1x) / (this.pc[camIndex].p2x - this.pc[camIndex].p1x);
        return this.orient < Math.PI && (double)y <= a * (double)x + b || this.orient > Math.PI && (double)y >= a * (double)x + b;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt(Math.pow(this.vx - dvx, 2.0) + Math.pow(this.vy - dvy, 2.0)) < (double)(dvr + this.vr) && (this.angle < Math.PI && this.pc[camIndex].boundingPolygon.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr) || this.angle > Math.PI && !this.pc[camIndex].boundingPolygon.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr) || this.angle == Math.PI && this.coordInsideHemisphere(jpx, jpy, camIndex));
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        int hw = d.width / 2;
        int hh = d.height / 2;
        this.pc[i].cx = hw + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = hh - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].p1x = hw + Math.round((float)(this.p1.x - c.posx) * this.coef);
        this.pc[i].p1y = hh - Math.round((float)(this.p1.y - c.posy) * this.coef);
        this.pc[i].p2x = hw + Math.round((float)(this.p2.x - c.posx) * this.coef);
        this.pc[i].p2y = hh - Math.round((float)(this.p2.y - c.posy) * this.coef);
        this.xpcoords[0] = this.pc[i].cx;
        this.ypcoords[0] = this.pc[i].cy;
        this.xpcoords[1] = hw + Math.round((float)(this.p3.x - c.posx) * this.coef);
        this.ypcoords[1] = hh - Math.round((float)(this.p3.y - c.posy) * this.coef);
        this.xpcoords[2] = hw + Math.round((float)(this.p4.x - c.posx) * this.coef);
        this.ypcoords[2] = hh - Math.round((float)(this.p4.y - c.posy) * this.coef);
        if (this.pc[i].boundingPolygon == null) {
            this.pc[i].boundingPolygon = new Polygon(this.xpcoords, this.ypcoords, 3);
        } else {
            for (int j = 0; j < this.xpcoords.length; ++j) {
                this.pc[i].boundingPolygon.xpoints[j] = this.xpcoords[j];
                this.pc[i].boundingPolygon.ypoints[j] = this.ypcoords[j];
            }
            this.pc[i].boundingPolygon.invalidate();
        }
        this.pc[i].outerCircleRadius = Math.round(this.size * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        int hw = lensWidth / 2;
        int hh = lensHeight / 2;
        this.pc[i].lcx = hw + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = hh - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lp1x = hw + Math.round((float)(this.p1.x - lensx) * this.coef);
        this.pc[i].lp1y = hh - Math.round((float)(this.p1.y - lensy) * this.coef);
        this.pc[i].lp2x = hw + Math.round((float)(this.p2.x - lensx) * this.coef);
        this.pc[i].lp2y = hh - Math.round((float)(this.p2.y - lensy) * this.coef);
        this.xpcoords[0] = this.pc[i].lcx;
        this.ypcoords[0] = this.pc[i].lcy;
        this.xpcoords[1] = hw + Math.round((float)(this.p3.x - lensx) * this.coef);
        this.ypcoords[1] = hh - Math.round((float)(this.p3.y - lensy) * this.coef);
        this.xpcoords[2] = hw + Math.round((float)(this.p4.x - lensx) * this.coef);
        this.ypcoords[2] = hh - Math.round((float)(this.p4.y - lensy) * this.coef);
        if (this.pc[i].lboundingPolygon == null) {
            this.pc[i].lboundingPolygon = new Polygon(this.xpcoords, this.ypcoords, 3);
        } else {
            for (int j = 0; j < this.xpcoords.length; ++j) {
                this.pc[i].lboundingPolygon.xpoints[j] = this.xpcoords[j];
                this.pc[i].lboundingPolygon.ypoints[j] = this.ypcoords[j];
            }
            this.pc[i].lboundingPolygon.invalidate();
        }
        this.pc[i].louterCircleRadius = Math.round(this.size * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].outerCircleRadius > 2) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillArc(dx + this.pc[i].cx - this.pc[i].outerCircleRadius, dy + this.pc[i].cy - this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg - 1);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawArc(dx + this.pc[i].cx - this.pc[i].outerCircleRadius, dy + this.pc[i].cy - this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg - 1);
                    g.drawLine(dx + this.pc[i].cx, dy + this.pc[i].cy, this.pc[i].p1x, this.pc[i].p1y);
                    g.drawLine(dx + this.pc[i].cx, dy + this.pc[i].cy, this.pc[i].p2x, this.pc[i].p2y);
                    g.setStroke(stdS);
                } else {
                    g.drawArc(dx + this.pc[i].cx - this.pc[i].outerCircleRadius, dy + this.pc[i].cy - this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, 2 * this.pc[i].outerCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg - 1);
                    g.drawLine(dx + this.pc[i].cx, dy + this.pc[i].cy, this.pc[i].p1x, this.pc[i].p1y);
                    g.drawLine(dx + this.pc[i].cx, dy + this.pc[i].cy, this.pc[i].p2x, this.pc[i].p2y);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].louterCircleRadius > 2) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillArc(dx + this.pc[i].lcx - this.pc[i].louterCircleRadius, dy + this.pc[i].lcy - this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg - 1);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawArc(dx + this.pc[i].lcx - this.pc[i].louterCircleRadius, dy + this.pc[i].lcy - this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg - 1);
                    g.drawLine(dx + this.pc[i].lcx, dy + this.pc[i].lcy, this.pc[i].lp1x, this.pc[i].lp1y);
                    g.drawLine(dx + this.pc[i].lcx, dy + this.pc[i].lcy, this.pc[i].lp2x, this.pc[i].lp2y);
                    g.setStroke(stdS);
                } else {
                    g.drawArc(dx + this.pc[i].lcx - this.pc[i].louterCircleRadius, dy + this.pc[i].lcy - this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, 2 * this.pc[i].louterCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg - 1);
                    g.drawLine(dx + this.pc[i].lcx, dy + this.pc[i].lcy, this.pc[i].lp1x, this.pc[i].lp1y);
                    g.drawLine(dx + this.pc[i].lcx, dy + this.pc[i].lcy, this.pc[i].lp2x, this.pc[i].lp2y);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        return null;
    }
}

