/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.PerforceRepository;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

public class PerforceHistoryParser {
    private static final Pattern REVISION_PATTERN = Pattern.compile("#(\\d+) change \\d+ \\S+ on (\\d{4})/(\\d{2})/(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2}) by ([^@]+)");
    private static final Pattern CHANGE_PATTERN = Pattern.compile("Change (\\d+) on (\\d{4})/(\\d{2})/(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2}) by ([^@]+)@\\S* '([^']*)'");

    History parse(File file, Repository repos) throws HistoryException {
        History history;
        if (!PerforceRepository.isInP4Depot(file)) {
            return null;
        }
        try {
            history = file.isDirectory() ? this.parseDirectory(file) : PerforceHistoryParser.getRevisions(file, null);
        }
        catch (IOException ioe) {
            throw new HistoryException(ioe);
        }
        return history;
    }

    private History parseDirectory(File file) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("p4");
        cmd.add("changes");
        cmd.add("-t");
        cmd.add("...");
        Executor executor = new Executor(cmd, file.getCanonicalFile());
        executor.exec();
        return PerforceHistoryParser.parseChanges(executor.getOutputReader());
    }

    public static History getRevisions(File file, String rev) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("p4");
        cmd.add("filelog");
        cmd.add("-lt");
        cmd.add(file.getName() + (rev == null ? "" : "#" + rev));
        Executor executor = new Executor(cmd, file.getCanonicalFile().getParentFile());
        executor.exec();
        return PerforceHistoryParser.parseFileLog(executor.getOutputReader());
    }

    protected static History parseChanges(Reader fileHistory) throws IOException {
        History history = new History();
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        try (BufferedReader reader = new BufferedReader(fileHistory);){
            String line;
            Matcher matcher = CHANGE_PATTERN.matcher("");
            while ((line = reader.readLine()) != null) {
                matcher.reset(line);
                if (!matcher.find()) continue;
                HistoryEntry entry = new HistoryEntry();
                entry.setRevision(matcher.group(1));
                int year = Integer.parseInt(matcher.group(2));
                int month = Integer.parseInt(matcher.group(3));
                int day = Integer.parseInt(matcher.group(4));
                int hour = Integer.parseInt(matcher.group(5));
                int minute = Integer.parseInt(matcher.group(6));
                int second = Integer.parseInt(matcher.group(7));
                entry.setDate(PerforceHistoryParser.newDate(year, month, day, hour, minute, second));
                entry.setAuthor(matcher.group(8));
                entry.setMessage(matcher.group(9).trim());
                entry.setActive(true);
                entries.add(entry);
            }
        }
        history.setHistoryEntries(entries);
        return history;
    }

    protected static History parseFileLog(Reader fileLog) throws IOException {
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        HistoryEntry entry = null;
        try (BufferedReader reader = new BufferedReader(fileLog);){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = REVISION_PATTERN.matcher(line);
                if (matcher.find()) {
                    if (entry != null) {
                        entries.add(entry);
                        entry = null;
                    }
                    entry = new HistoryEntry();
                    entry.setRevision(matcher.group(1));
                    int year = Integer.parseInt(matcher.group(2));
                    int month = Integer.parseInt(matcher.group(3));
                    int day = Integer.parseInt(matcher.group(4));
                    int hour = Integer.parseInt(matcher.group(5));
                    int minute = Integer.parseInt(matcher.group(6));
                    int second = Integer.parseInt(matcher.group(7));
                    entry.setDate(PerforceHistoryParser.newDate(year, month, day, hour, minute, second));
                    entry.setAuthor(matcher.group(8));
                    entry.setActive(true);
                    continue;
                }
                if (entry == null) continue;
                if (line.startsWith("... ...")) {
                    entries.add(entry);
                    entry = null;
                    continue;
                }
                entry.appendMessage(line);
            }
        }
        if (entry != null) {
            entries.add(entry);
        }
        History history = new History();
        history.setHistoryEntries(entries);
        return history;
    }

    private static Date newDate(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, second);
        return cal.getTime();
    }
}

