/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.util.IOUtils;
import org.opensolaris.opengrok.web.EftarFile;

public class EftarFileReader {
    private final RandomAccessFile f;
    private boolean isOpen;
    private static final Logger log = Logger.getLogger(EftarFileReader.class.getName());

    public EftarFileReader(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public EftarFileReader(File file) throws FileNotFoundException {
        this.f = new RandomAccessFile(file, "r");
        this.isOpen = true;
    }

    public FNode getNode(String path) throws IOException {
        StringTokenizer toks = new StringTokenizer(path, "/");
        this.f.seek(0L);
        FNode n = new FNode();
        if (File.separator.equals(path) || path.length() == 0) {
            return n;
        }
        FNode next = null;
        while (toks.hasMoreTokens() && (next = n.get(EftarFile.myHash(toks.nextToken()))) != null) {
            n = next;
        }
        if (!toks.hasMoreElements()) {
            return next;
        }
        return null;
    }

    public String getChildTag(FNode fn, String name) throws IOException {
        FNode ch;
        if (fn != null && fn.childOffset != 0 && fn.numChildren != 0 && (ch = fn.binarySearch(fn.offset + (long)fn.childOffset, fn.numChildren, EftarFile.myHash(name))) != null) {
            return ch.getTag();
        }
        return null;
    }

    public String get(String path) throws IOException {
        StringTokenizer toks = new StringTokenizer(path, "/");
        this.f.seek(0L);
        FNode n = new FNode();
        long tagOffset = 0L;
        int tagLength = 0;
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (tok == null || tok.length() == 0) continue;
            FNode next = n.get(EftarFile.myHash(tok));
            if (next == null) break;
            if (next.tagOffset != 0) {
                tagOffset = next.offset + (long)next.tagOffset;
                tagLength = next.childOffset == 0 ? next.numChildren : next.childOffset - next.tagOffset;
            }
            n = next;
        }
        if (tagOffset != 0L) {
            this.f.seek(tagOffset);
            byte[] desc = new byte[tagLength];
            int len = this.f.read(desc);
            if (len == -1) {
                throw new EOFException();
            }
            return new String(desc, 0, len);
        }
        return "";
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void close() {
        if (this.isOpen) {
            IOUtils.close(this.f);
            this.isOpen = false;
        }
    }

    class FNode {
        public long offset;
        public long hash;
        public int childOffset;
        public int numChildren;
        public int tagOffset;

        public FNode() throws IOException {
            this.offset = EftarFileReader.this.f.getFilePointer();
            try {
                this.hash = EftarFileReader.this.f.readLong();
                this.childOffset = EftarFileReader.this.f.readUnsignedShort();
                this.numChildren = EftarFileReader.this.f.readUnsignedShort();
                this.tagOffset = EftarFileReader.this.f.readUnsignedShort();
            }
            catch (EOFException e) {
                this.numChildren = 0;
                this.tagOffset = 0;
            }
        }

        public FNode(long hash, long offset, int childOffset, int num, int tagOffset) {
            this.hash = hash;
            this.offset = offset;
            this.childOffset = childOffset;
            this.numChildren = num;
            this.tagOffset = tagOffset;
        }

        public FNode get(long hash) throws IOException {
            if (this.childOffset == 0 || this.numChildren == 0) {
                return null;
            }
            return this.binarySearch(this.offset + (long)this.childOffset, this.numChildren, hash);
        }

        private FNode binarySearch(long start, int len, long hash) throws IOException {
            int b = 0;
            int e = len;
            while (b <= e) {
                int m = (b + e) / 2;
                EftarFileReader.this.f.seek(start + (long)(m * 14));
                long mhash = EftarFileReader.this.f.readLong();
                if (hash > mhash) {
                    b = m + 1;
                    continue;
                }
                if (hash < mhash) {
                    e = m - 1;
                    continue;
                }
                return new FNode(mhash, EftarFileReader.this.f.getFilePointer() - 8L, EftarFileReader.this.f.readUnsignedShort(), EftarFileReader.this.f.readUnsignedShort(), EftarFileReader.this.f.readUnsignedShort());
            }
            return null;
        }

        public String getTag() throws IOException {
            if (this.tagOffset == 0) {
                return null;
            }
            EftarFileReader.this.f.seek(this.offset + (long)this.tagOffset);
            byte[] tagString = this.childOffset == 0 ? new byte[this.numChildren] : new byte[this.childOffset - this.tagOffset];
            int len = EftarFileReader.this.f.read(tagString);
            if (len == -1) {
                throw new EOFException();
            }
            return new String(tagString, 0, len);
        }

        public String toString() {
            String tagString = null;
            try {
                tagString = this.getTag();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Got excption while getting the tag: ", e);
            }
            return "H[" + this.hash + "] num = " + this.numChildren + " tag = " + tagString;
        }
    }
}

