/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpUtil;

public class HttpInputStream
extends BufferedInputStream {
    private static final int BUFFER_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private static final String CRLF2 = "\r\n\r\n";
    private static final String LF = "\n";
    private static final String LF2 = "\n\n";
    private byte[] mBuffer = new byte[4096];
    private Socket mSocket = null;

    public HttpInputStream(Socket socket) throws IOException {
        super(socket.getInputStream(), 4096);
        this.setSocket(socket);
    }

    public HttpRequestHeader readRequestHeader(boolean bl) throws HttpMalformedHeaderException, IOException {
        return new HttpRequestHeader(this.readHeader(), bl);
    }

    public synchronized String readHeader() throws IOException {
        String string = "";
        int n = -1;
        boolean bl = false;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer(200);
        do {
            if ((n = super.read()) == -1) {
                bl = true;
                if (!bl2) break;
                HttpUtil.sleep(50);
                continue;
            }
            bl2 = false;
            stringBuffer.append((char)n);
            if ((char)n != '\n' || !this.isHeaderEnd(stringBuffer)) continue;
            bl = true;
            string = stringBuffer.toString();
        } while (!bl || bl2);
        return string;
    }

    private boolean isHeaderEnd(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n > 2 && LF2.equals(stringBuffer.substring(n - 2))) {
            return true;
        }
        return n > 4 && CRLF2.equals(stringBuffer.substring(n - 4));
    }

    public synchronized HttpBody readBody(HttpHeader httpHeader) {
        int n = httpHeader.getContentLength();
        int n2 = 0;
        int n3 = 0;
        HttpBody httpBody = n > 0 ? new HttpBody(n) : new HttpBody();
        try {
            while (n == -1 || n2 < n) {
                n3 = this.readBody(n, n2, this.mBuffer);
                if (n3 > 0) {
                    n2 += n3;
                }
                httpBody.append(this.mBuffer, n3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return httpBody;
    }

    private int readBody(int n, int n2, byte[] byArray) throws IOException {
        int n3 = 0;
        int n4 = 0;
        if (n == -1) {
            n3 = super.read(byArray);
        } else {
            n4 = n - n2;
            if (n4 < byArray.length && n4 > 0) {
                n3 = super.read(byArray, 0, n4);
            } else if (n4 > byArray.length) {
                n3 = super.read(byArray);
            }
        }
        return n3;
    }

    public void setSocket(Socket socket) {
        this.mSocket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        int n = 0;
        int n2 = 0;
        n = super.available();
        if (n == 0 && this.mSocket != null && this.mSocket instanceof SSLSocket) {
            try {
                n2 = this.mSocket.getSoTimeout();
                this.mSocket.setSoTimeout(1);
                super.mark(256);
                super.read();
                super.reset();
                n = super.available();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                n = 0;
            }
            finally {
                this.mSocket.setSoTimeout(n2);
            }
        }
        return n;
    }

    public int read() throws IOException {
        return super.read();
    }

    public int read(byte[] byArray) throws IOException {
        return super.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

