/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as C,css as k,html as E}from"lit";import{property as p,customElement as w}from"lit/decorators.js";import{SeverityEnum as L}from"@typo3/backend/enum/severity.js";import b from"@typo3/backend/modal.js";import{lll as v}from"@typo3/core/lit-helper.js";import A from"@typo3/core/ajax/ajax-request.js";import S from"@typo3/backend/notification.js";var m=function(s,t,n,e){var r=arguments.length,o=r<3?t:e===null?e=Object.getOwnPropertyDescriptor(t,n):e,c;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")o=Reflect.decorate(s,t,n,e);else for(var d=s.length-1;d>=0;d--)(c=s[d])&&(o=(r<3?c(o):r>3?c(t,n,o):c(t,n))||o);return r>3&&o&&Object.defineProperty(t,n,o),o},l,h;(function(s){s.columnsSelector=".t3js-column-selector",s.columnsContainerSelector=".t3js-column-selector-container",s.columnsFilterSelector='input[name="columns-filter"]',s.columnsSelectorActionsSelector=".t3js-column-selector-actions"})(h||(h={}));var f;(function(s){s.toggle="select-toggle",s.all="select-all",s.none="select-none"})(f||(f={}));let u=class extends C{static{l=this}static{this.styles=[k`:host{cursor:pointer;appearance:button}`]}constructor(){super(),this.modalTitle="Show columns",this.buttonOk=v("button.ok")||"Update",this.buttonClose=v("button.close")||"Close",this.errorMessage="Could not update columns",this.addEventListener("click",t=>{t.preventDefault(),this.showColumnSelectorModal()}),this.addEventListener("keydown",t=>{(t.key==="Enter"||t.key===" ")&&(t.preventDefault(),this.showColumnSelectorModal())})}static toggleSelectorActions(t,n,e,r=!1){n.classList.add("disabled");for(let o=0;o<t.length;o++)if(!t[o].disabled&&!t[o].checked&&(r||!l.isColumnHidden(t[o]))){n.classList.remove("disabled");break}e.classList.add("disabled");for(let o=0;o<t.length;o++)if(!t[o].disabled&&t[o].checked&&(r||!l.isColumnHidden(t[o]))){e.classList.remove("disabled");break}}static isColumnHidden(t){return t.closest(h.columnsContainerSelector)?.classList.contains("hidden")}static filterColumns(t,n){n.forEach(e=>{const r=e.closest(h.columnsContainerSelector);if(!e.disabled&&r!==null){const o=r.querySelector(".form-check-label")?.textContent;o&&o.length&&r.classList.toggle("hidden",t.value!==""&&!RegExp(t.value,"i").test(o.trim().replace(/\[\]/g,"").replace(/\s+/g," ")))}})}connectedCallback(){this.hasAttribute("role")||this.setAttribute("role","button"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0")}render(){return E`<slot></slot>`}showColumnSelectorModal(){if(!this.modalUrl||!this.modalTarget)return;const t=b.advanced({content:this.modalUrl,title:this.modalTitle,severity:L.notice,size:b.sizes.medium,type:b.types.ajax,buttons:[{text:this.buttonClose,active:!0,btnClass:"btn-default",name:"cancel",trigger:(n,e)=>e.hideModal()},{text:this.buttonOk,btnClass:"btn-primary",name:"update",trigger:(n,e)=>this.processSelection(e)}],ajaxCallback:()=>this.handleModalContentLoaded(t)})}processSelection(t){const n=t.querySelector("form");if(n===null){this.abortSelection();return}new A(TYPO3.settings.ajaxUrls.show_columns).post(new FormData(n)).then(async e=>{const r=await e.resolve();r.success===!0?(this.ownerDocument.location.href=this.modalTarget,this.ownerDocument.location.reload()):S.error(r.message||"No update was performed"),b.dismiss()}).catch(()=>{this.abortSelection()})}handleModalContentLoaded(t){const n=t.querySelector("form");if(n===null)return;n.addEventListener("submit",a=>{a.preventDefault()});const e=t.querySelectorAll(h.columnsSelector),r=t.querySelector(h.columnsFilterSelector),o=t.querySelector(h.columnsSelectorActionsSelector),c=o.querySelector('button[data-action="'+f.all+'"]'),d=o.querySelector('button[data-action="'+f.none+'"]');!e.length||r===null||c===null||d===null||(l.toggleSelectorActions(e,c,d,!0),e.forEach(a=>{a.addEventListener("change",()=>{l.toggleSelectorActions(e,c,d)})}),r.addEventListener("keydown",a=>{const g=a.target;a.code==="Escape"&&(a.stopImmediatePropagation(),g.value="")}),r.addEventListener("keyup",a=>{l.filterColumns(a.target,e),l.toggleSelectorActions(e,c,d)}),r.addEventListener("search",a=>{l.filterColumns(a.target,e),l.toggleSelectorActions(e,c,d)}),o.querySelectorAll("button[data-action]").forEach(a=>{a.addEventListener("click",g=>{g.preventDefault();const y=g.currentTarget;if(y.dataset.action){switch(y.dataset.action){case f.toggle:e.forEach(i=>{!i.disabled&&!l.isColumnHidden(i)&&(i.checked=!i.checked)});break;case f.all:e.forEach(i=>{!i.disabled&&!l.isColumnHidden(i)&&(i.checked=!0)});break;case f.none:e.forEach(i=>{!i.disabled&&!l.isColumnHidden(i)&&(i.checked=!1)});break;default:S.warning("Unknown selector action")}l.toggleSelectorActions(e,c,d)}})}))}abortSelection(){S.error(this.errorMessage),b.dismiss()}};m([p({type:String,attribute:"data-url"})],u.prototype,"modalUrl",void 0),m([p({type:String,attribute:"data-target"})],u.prototype,"modalTarget",void 0),m([p({type:String,attribute:"data-title"})],u.prototype,"modalTitle",void 0),m([p({type:String,attribute:"data-button-ok"})],u.prototype,"buttonOk",void 0),m([p({type:String,attribute:"data-button-close"})],u.prototype,"buttonClose",void 0),m([p({type:String,attribute:"data-error-message"})],u.prototype,"errorMessage",void 0),u=l=m([w("typo3-backend-column-selector-button")],u);export{u as ColumnSelectorButton};
