/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaCoveragePackageNotFoundException
extends ExecutionException
implements HyperlinkListener {
    private static final String SAVE_DEV_OPTION = "--save-dev";
    private final ExecutionEnvironment myEnv;
    private final NodeJsInterpreter myInterpreter;
    private final String myInstallWorkingDirectory;
    private final boolean mySaveDev;

    private MochaCoveragePackageNotFoundException(@NotNull String reason, @NotNull ExecutionEnvironment env, @NotNull NodeJsInterpreter interpreter, @NotNull String installWorkingDirectory, boolean saveDev) {
        if (reason == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(0);
        }
        if (env == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(1);
        }
        if (interpreter == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(2);
        }
        if (installWorkingDirectory == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(3);
        }
        super(reason);
        this.myEnv = env;
        this.myInterpreter = interpreter;
        this.myInstallWorkingDirectory = installWorkingDirectory;
        this.mySaveDev = saveDev;
    }

    public static MochaCoveragePackageNotFoundException create(@NotNull Project project, @NotNull NodePackage mochaPackage, @NotNull ExecutionEnvironment env, @NotNull NodeJsInterpreter interpreter, @NotNull String workingDirectory) {
        String installWorkingDirectory;
        boolean saveDev;
        String mochaRootPath;
        if (project == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(4);
        }
        if (mochaPackage == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(5);
        }
        if (env == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(6);
        }
        if (interpreter == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(7);
        }
        if (workingDirectory == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(8);
        }
        if (new File(mochaRootPath = PathUtil.getParentPath((String)PathUtil.getParentPath((String)mochaPackage.getSystemDependentPath())), "package.json").isFile()) {
            saveDev = true;
            installWorkingDirectory = mochaRootPath;
        } else if (new File(workingDirectory, "package.json").isFile()) {
            saveDev = true;
            installWorkingDirectory = workingDirectory;
        } else {
            saveDev = false;
            installWorkingDirectory = mochaRootPath;
        }
        String text = "Cannot find 'nyc' or 'istanbul' package to run Mocha tests with coverage.<p>Please run " + MochaCoveragePackageNotFoundException.createNpmInstallLink(saveDev);
        String path = MochaCoveragePackageNotFoundException.getPresentablePath(project, installWorkingDirectory);
        if (!path.equals(PathUtil.getFileName((String)path))) {
            text = text + " to install it in " + path;
        }
        return new MochaCoveragePackageNotFoundException(text, env, interpreter, installWorkingDirectory, saveDev);
    }

    @NotNull
    private static String getPresentablePath(@NotNull Project project, @NotNull String path) {
        VirtualFile dir;
        if (project == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(9);
        }
        if (path == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(10);
        }
        String string = (dir = LocalFileSystem.getInstance().findFileByPath(path)) != null ? JsbtUtil.getRelativePath((Project)project, (VirtualFile)dir) : FileUtil.getLocationRelativeToUserHome((String)path);
        if (string == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static String createNpmInstallLink(boolean saveDev) {
        return "<a href='install'>npm install " + (saveDev ? "--save-dev " : "") + "nyc" + "</a>";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Project project = this.myEnv.getProject();
            NpmPackageInstallerLight installerLight = (NpmPackageInstallerLight)ServiceManager.getService(NpmPackageInstallerLight.class);
            installerLight.installPackage(project, this.myInterpreter, "nyc", null, new File(this.myInstallWorkingDirectory), new PackageManagementService.Listener(){

                public void operationStarted(String packageName) {
                }

                public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    if (errorDescription == null) {
                        ExecutionUtil.restart((ExecutionEnvironment)MochaCoveragePackageNotFoundException.this.myEnv);
                    }
                }
            }, this.mySaveDev ? SAVE_DEV_OPTION : "");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installWorkingDirectory";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/coverage/MochaCoveragePackageNotFoundException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/coverage/MochaCoveragePackageNotFoundException";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

