/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpEnvironmentComboBox
extends ComboBox<HttpEnvironmentItem> {
    private static final HttpEnvironmentItem EMPTY = new HttpRegularEnvironmentItem("<No Environment>", true);
    private static final HttpEnvironmentItem DEFAULT = new HttpRegularEnvironmentItem("<Default Environment>", true);

    public HttpEnvironmentComboBox() {
        this.setEditable(false);
        this.setToolTipText(RestClientBundle.message("http.request.run.configuration.env.combo.box.tooltip", new Object[0]));
    }

    public void reset(final @NotNull Project project, final @Nullable PsiFile file, @Nullable String selectEnv) {
        if (project == null) {
            HttpEnvironmentComboBox.$$$reportNull$$$0(0);
        }
        ArrayList<HttpEnvironmentItem> items = new ArrayList<HttpEnvironmentItem>();
        items.add(DEFAULT);
        for (String env : HttpRequestIndex.getAllEnvironments(project, file)) {
            items.add(new HttpRegularEnvironmentItem(env, true));
        }
        items.add(EMPTY);
        HttpEnvironmentItem toSelect = HttpEnvironmentComboBox.findItemByName(items, selectEnv);
        if (toSelect == null && StringUtil.isNotEmpty((String)selectEnv)) {
            toSelect = new HttpRegularEnvironmentItem(selectEnv, false);
        }
        this.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)DEFAULT));
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<HttpEnvironmentItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends HttpEnvironmentItem> list, HttpEnvironmentItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    return;
                }
                boolean isValid = value.isValid();
                String name = value.getName();
                this.append(name, isValid ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                if (HttpEnvironmentComboBox.isDefaultEnv(name)) {
                    String defaultEnvName = HttpRequestEnvironment.isDefaultEnvironmentValid(project, file) ? HttpRequestEnvironment.getDefaultEnvName(project) : null;
                    SimpleTextAttributes attributes = isValid ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                    this.append(" (" + StringUtil.notNullize((String)defaultEnvName, (String)"no environment") + ")", attributes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ws/http/request/run/config/HttpEnvironmentComboBox$1", "customizeCellRenderer"));
            }
        });
        if (toSelect != null) {
            this.getModel().setSelectedItem(toSelect);
        }
    }

    private static boolean isDefaultEnv(@Nullable String name) {
        return StringUtil.equals((CharSequence)name, (CharSequence)"<Default Environment>");
    }

    @Nullable
    private static HttpEnvironmentItem findItemByName(@NotNull List<HttpEnvironmentItem> items, @Nullable String name) {
        if (items == null) {
            HttpEnvironmentComboBox.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)name)) {
            for (HttpEnvironmentItem item : items) {
                if (!StringUtil.equals((CharSequence)item.getName(), (CharSequence)name)) continue;
                return item;
            }
        }
        return null;
    }

    @Nullable
    public HttpEnvironmentItem getSelectedItem() {
        return (HttpEnvironmentItem)super.getSelectedItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/config/HttpEnvironmentComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findItemByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HttpRegularEnvironmentItem
    implements HttpEnvironmentItem {
        private final String myName;
        private final boolean myValid;

        private HttpRegularEnvironmentItem(@NotNull String name, boolean valid) {
            if (name == null) {
                HttpRegularEnvironmentItem.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myValid = valid;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                HttpRegularEnvironmentItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/config/HttpEnvironmentComboBox$HttpRegularEnvironmentItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/config/HttpEnvironmentComboBox$HttpRegularEnvironmentItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface HttpEnvironmentItem {
        @NotNull
        public String getName();

        public boolean isValid();
    }
}

